/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.math.BigDecimal;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentLargeProject;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPerson;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentProject;

public class ConcurrentReadFetchJoinWithUOWLocksTest
extends AutoVerifyTestCase {
    protected ConcurrentPerson person = null;
    protected ConcurrentLargeProject project;
    protected boolean deadlockDetected = false;

    public void setup() {
        this.deadlockDetected = false;
        this.getExecutor().swapServerSession();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.person = (ConcurrentPerson)uow.registerObject((Object)new ConcurrentPerson());
        this.person.name = "SomeoneSpecial";
        this.project = (ConcurrentLargeProject)uow.registerObject((Object)new ConcurrentLargeProject());
        this.project.setName("ConcurrentRFJUOWLock Project");
        ConcurrentAddress address = (ConcurrentAddress)uow.registerObject((Object)new ConcurrentAddress());
        address.setStreet("99 Bank St");
        this.project.setLocation(address);
        uow.commit();
        uow.release();
    }

    public void test() {
        block6: {
            Server server = this.getServerSession();
            UnitOfWork uow = server.acquireUnitOfWork();
            ConcurrentLargeProject clonedProject = (ConcurrentLargeProject)uow.registerObject((Object)this.project);
            clonedProject.getLocation().setPostalCode("K1P 1A4");
            ConcurrentPerson clonedPerson = (ConcurrentPerson)uow.registerObject((Object)this.person);
            clonedPerson.setHobby(clonedProject);
            uow.writeChanges();
            Thread thread1 = new Thread((Runnable)new ProjectReader((Session)server.acquireClientSession(), this.project.getId()), "Test Thread 1");
            ConcurrentProject.RUNNING_TEST = ConcurrentProject.READ_WITH_UOW_LOCKS_TESTS;
            thread1.start();
            try {
                thread1.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread thread2 = new Thread((Runnable)new UOWCommit(uow), "Test Thread 2");
            thread2.start();
            try {
                thread1.join(20000L);
                if (!thread1.isAlive()) break block6;
                try {
                    thread1.interrupt();
                    thread2.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.deadlockDetected = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void verify() {
        if (this.deadlockDetected) {
            throw new TestErrorException("Deadlock detected in UnitOfWork when reading a joined 1-1.");
        }
    }

    public void reset() throws InterruptedException {
        Thread.sleep(1000L);
        ConcurrentProject.RUNNING_TEST = Integer.MIN_VALUE;
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.person);
        uow.deleteObject((Object)this.project);
        uow.deleteObject((Object)this.project.getLocation());
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getExecutor().resetSession();
    }

    public class ProjectReader
    implements Runnable {
        private Session session;
        private BigDecimal idToUse;

        public ProjectReader(Session session, BigDecimal id) {
            this.session = session;
            this.idToUse = id;
        }

        @Override
        public void run() {
            ReadAllQuery query = new ReadAllQuery(ConcurrentLargeProject.class);
            query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal((Object)this.idToUse));
            query.addJoinedAttribute("location");
            query.refreshIdentityMapResult();
            this.session.executeQuery((DatabaseQuery)query);
        }
    }

    public class UOWCommit
    implements Runnable {
        private UnitOfWork uow;

        public UOWCommit(UnitOfWork uow) {
            this.uow = uow;
        }

        @Override
        public void run() {
            this.uow.commit();
        }
    }
}

