/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PreInsertModifyChangeSetTest
extends AutoVerifyTestCase {
    protected static int callCount = 0;
    protected Employee employee = null;
    protected DescriptorEventAdapter eventAdapter = new DescriptorEventAdapter(){

        public void preInsert(DescriptorEvent event) {
            if (event.getQuery().getDescriptor() != null) {
                event.updateAttributeWithObject("salary", (Object)callCount);
                ++callCount;
            }
        }
    };

    public PreInsertModifyChangeSetTest() {
        this.setDescription("Test to ensure change sets modified by events actually affect the cache.");
    }

    public void setup() {
        this.getSession().getDescriptor(Employee.class).getEventManager().addListener((DescriptorEventListener)this.eventAdapter);
        this.beginTransaction();
    }

    public void test() {
        this.employee = new Employee();
        this.employee.setFirstName("Homer");
        this.employee.setLastName("Sampson");
        this.employee.setSalary(200000);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.employee);
        uow.commit();
    }

    public void verify() {
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression exp = emp.get("id").equal((Object)this.employee.getId());
        Employee result = (Employee)this.getSession().readObject(Employee.class, exp);
        if (result.getSalary() == 200000) {
            throw new TestErrorException("Update of change set in preInsert event did not correctly change the cache.");
        }
        if (result.getSalary() != 0) {
            throw new TestErrorException("preInsert Called multiple times for same object");
        }
        callCount = 0;
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getDescriptor(Employee.class).getEventManager().removeListener((DescriptorEventListener)this.eventAdapter);
    }
}

