/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UpdateAllQueryTest
extends AutoVerifyTestCase {
    private Session m_session;
    private String m_firstName;

    protected void setup() {
        this.m_session = this.getSession();
        if (this.m_session.getDatasourcePlatform().isSymfoware()) {
            this.throwWarning("Test UpdateAllQueryTest skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
        }
        this.beginTransaction();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() {
        Employee emp = (Employee)this.m_session.readObject(Employee.class);
        this.m_firstName = emp.getFirstName();
        ExpressionBuilder eb = new ExpressionBuilder();
        UpdateAllQuery updateQuery = new UpdateAllQuery(Employee.class);
        updateQuery.setSelectionCriteria(eb.get("firstName").equal((Object)this.m_firstName));
        updateQuery.addUpdate(eb.get("lastName"), (Object)"oneverynonelikelylastname");
        this.m_session.executeQuery((DatabaseQuery)updateQuery);
    }

    protected void verify() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        Vector emps = this.m_session.readAllObjects(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)this.m_firstName));
        for (int i = 0; i < emps.size(); ++i) {
            Employee emp = (Employee)emps.elementAt(i);
            if (emp.getLastName().equals("oneverynonelikelylastname")) continue;
            throw new TestErrorException("Employee (" + emp.getFirstName() + ") had the wrong last name (" + emp.getLastName());
        }
    }
}

