/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;
import org.eclipse.persistence.testing.models.transparentindirection.IndirectMapProject;
import org.eclipse.persistence.testing.models.transparentindirection.MappedOrder;
import org.eclipse.persistence.testing.models.transparentindirection.MappedOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.MappedSalesRep;
import org.eclipse.persistence.testing.tests.transparentindirection.IndirectContainerTestDatabase;

public class IndirectMapTestDatabase
extends IndirectContainerTestDatabase {
    public IndirectMapTestDatabase(String name) {
        super(name);
    }

    @Override
    protected AbstractOrder buildOrderShell() {
        return new MappedOrder();
    }

    @Override
    protected AbstractOrder buildTestOrderShell(String customerName) {
        return new MappedOrder(customerName);
    }

    @Override
    protected AbstractOrderLine newOrderLine(String item, int quanity) {
        return new MappedOrderLine(item, quanity);
    }

    @Override
    protected AbstractSalesRep newSalesRep(String name) {
        return new MappedSalesRep(name);
    }

    public Project setUpProjectFromCode() {
        return new IndirectMapProject();
    }

    public void testKeysAndValues() {
        AbstractOrder key = this.buildOrderShell();
        key.id = this.originalID;
        MappedOrder orderFromDB = (MappedOrder)this.getSession().readObject((Object)key);
        AbstractSalesRep tempSalesRep = (AbstractSalesRep)((MappedOrder)this.buildTestOrder1()).salesReps.values().iterator().next();
        IndirectMapTestDatabase.assertEquals((String)"Invalid sales rep key/value pair.", (String)tempSalesRep.name, (String)((AbstractSalesRep)orderFromDB.salesReps.get((Object)tempSalesRep.getKey())).name);
        AbstractOrderLine tempLine = (AbstractOrderLine)((MappedOrder)this.buildTestOrder1()).lines.values().iterator().next();
        IndirectMapTestDatabase.assertEquals((String)"Invalid order line key/value pair.", (String)tempLine.itemName, (String)((AbstractOrderLine)orderFromDB.lines.get((Object)tempLine.getKey())).itemName);
    }
}

