/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmBasicTest;

public class RCMWithJmsTopicTest
extends RcmBasicTest {
    public RCMWithJmsTopicTest() {
        this.sessionsXmlFileName = "org/eclipse/persistence/testing/models/sessionsxml/sessions_rcm_jms_topic.xml";
    }

    public static void main(String[] args) {
        RCMWithJmsTopicTest test = new RCMWithJmsTopicTest();
        test.setup();
        test.verify();
    }

    public void verify() {
        String contextFactory;
        String userName;
        RemoteCommandManager rcm = (RemoteCommandManager)((AbstractSession)this.loadedSession).getCommandManager();
        JMSTopicTransportManager transportMgr = (JMSTopicTransportManager)rcm.getTransportManager();
        Vector<Object> errors = new Vector<Object>();
        if (!rcm.getChannel().equals("new_channel")) {
            errors.add("channel = " + rcm.getChannel());
        }
        if (!((AbstractSession)this.loadedSession).shouldPropagateChanges()) {
            errors.add("cache sync is not enable");
        }
        if (rcm.getTransportManager().shouldRemoveConnectionOnError()) {
            errors.add("remove connection on error");
        }
        if (!rcm.shouldPropagateAsynchronously()) {
            errors.add("send mode is synchronous but should always be asynchronous by default.");
        }
        if (transportMgr.getTopicHostUrl() == null || !transportMgr.getTopicHostUrl().equals("ormi://jms_topic_host")) {
            errors.add("topic-host-url = " + transportMgr.getTopicHostUrl());
        }
        if (!transportMgr.getTopicConnectionFactoryName().equals("test-topic-connection-factory-name")) {
            errors.add("test-topic-connection-factory-name = " + transportMgr.getTopicConnectionFactoryName());
        }
        if (!transportMgr.getTopicName().equals("test-topic-name")) {
            errors.add("test-topic-name = " + transportMgr.getTopicName());
        }
        if (transportMgr.getTopicHostUrl() == null || !transportMgr.getTopicHostUrl().equals("ormi://jms_topic_host")) {
            errors.add("topic-host-url = " + transportMgr.getTopicHostUrl());
        }
        if (!rcm.getUrl().equals("ormi://jms_topic_host")) {
            errors.add("Url = " + rcm.getUrl());
        }
        if ((userName = (String)transportMgr.getRemoteContextProperties().get("java.naming.security.principal")) == null || !userName.equals("new_user_name")) {
            errors.add("user name = " + userName);
        }
        String password = (String)transportMgr.getRemoteContextProperties().get("java.naming.security.credentials");
        password = new SecurableObjectHolder().getSecurableObject().decryptPassword(password);
        if (password == null || !password.equals("new_password")) {
            errors.add("password = " + password);
        }
        if ((contextFactory = (String)transportMgr.getRemoteContextProperties().get("java.naming.factory.initial")) == null || !contextFactory.equals("new_initial_context_factory_name")) {
            errors.add("initial context factory name = " + contextFactory);
        }
        String propertyValue1 = (String)transportMgr.getRemoteContextProperties().get("name1");
        String propertyValue2 = (String)transportMgr.getRemoteContextProperties().get("name2");
        if (propertyValue1 == null || !propertyValue1.equals("value1")) {
            errors.add("extra property name =  name1, value = " + propertyValue1);
        }
        if (propertyValue2 == null || !propertyValue2.equals("value2")) {
            errors.add("extra property name =  name2, value = " + propertyValue2);
        }
        if (!errors.isEmpty()) {
            Object errorString = "The following RCM elements do not match their expected values:";
            Enumeration enumtr = errors.elements();
            while (enumtr.hasMoreElements()) {
                errorString = (String)errorString + "\n   " + enumtr.nextElement();
            }
            throw new TestErrorException((String)errorString);
        }
    }
}

