/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class GetLeafMappingForReportQueryTest
extends ReportQueryTestCase {
    public GetLeafMappingForReportQueryTest() {
        this.setDescription("Tests recursive behavior of this method.");
    }

    @Override
    protected void buildExpectedResults() throws Exception {
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        ExpressionBuilder builder = new ExpressionBuilder();
        this.reportQuery = new ReportQuery(builder);
        Expression expression = null;
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("address ids", builder.anyOf("projects").get("teamLeader").get("address").get("id"));
        this.reportQuery.setSelectionCriteria(expression);
    }

    @Override
    public void verify() {
        ReportItem item = (ReportItem)this.reportQuery.getItems().get(0);
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Address.class);
        DatabaseMapping mapping = descriptor.getMappingForAttributeName("id");
        if (!(this.getSession() instanceof RemoteSession) && item.getMapping() != mapping) {
            throw new TestErrorException("The mapping was not set correctly on the ReportItem: " + item.getMapping());
        }
    }
}

