/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.mapping.Employee;

public class UpdateTestCase
extends TestCase {
    DescriptorQueryManager qm;
    Employee emp;
    static String HINT_STRING = "/*+ RULE */";

    public UpdateTestCase() {
        this.setName("Update Test");
        this.setDescription("Tests the use of a hint in an update");
    }

    public void setup() {
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        this.qm = employeeDescriptor.getQueryManager();
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        this.qm.setUpdateQuery(updateQuery);
        this.emp = new Employee();
        this.emp.firstName = "Matt";
        this.emp.lastName = "MacIvor";
        this.emp.sex = "male";
        this.getAbstractSession().writeObject((Object)this.emp);
    }

    public void reset() {
        this.qm.setUpdateQuery(null);
        this.getAbstractSession().deleteObject((Object)this.emp);
    }

    public void test() {
        UpdateObjectQuery updateQuery = this.qm.getUpdateQuery();
        updateQuery.setHintString(HINT_STRING);
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("lastName").equal((Object)"MacIvor"));
        emp.firstName = "Matthew";
        this.getAbstractSession().updateObject((Object)emp);
    }
}

