/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PredefinedQueryToUpperOnParameterTest
extends ReadObjectTest {
    public PredefinedQueryToUpperOnParameterTest() {
    }

    public PredefinedQueryToUpperOnParameterTest(Object originalObject) {
        super(originalObject);
        this.setName("PredefinedQueryToUpperOnParameterTest(" + originalObject + ")");
    }

    protected void setup() {
        if (this.getSession().getLogin().getDatasourcePlatform().isDB2()) {
            throw new TestWarningException("DB2 doesn't support UCASE() on Parameter");
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression firstNameExpression = builder.get("firstName").toUpperCase().equal(builder.getParameter("firstName").toUpperCase());
        Expression lastNameExpression = builder.get("lastName").equal(builder.getParameter("lastName"));
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(firstNameExpression.and(lastNameExpression));
        query.addArgument("firstName");
        query.addArgument("lastName");
        ClassDescriptor descriptor = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getDescriptor(Employee.class) : this.getSession().getDescriptor(Employee.class);
        this.getSession().removeQuery("getEmployee");
        descriptor.getQueryManager().addQuery("getEmployee", (DatabaseQuery)query);
    }

    protected void test() {
        this.objectFromDatabase = this.getSession().executeQuery("getEmployee", Employee.class, (Object)"Bob", (Object)"Smith");
    }
}

