/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.sql.Timestamp;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.RegisterInIdentityMapTest;

public class MergeWithNoIdentityMap
extends RegisterInIdentityMapTest {
    public Employee clone;
    public OptimisticLockingPolicy lockPolicy;

    public MergeWithNoIdentityMap(Class<? extends IdentityMap> mapClass) {
        super(mapClass);
    }

    @Override
    public String getDescription() {
        return "This test verifies that ValueHolders are not triggered when object is updated";
    }

    @Override
    public void reset() {
        super.reset();
        this.getSession().getDescriptor(Employee.class).getQueryManager().checkCacheForDoesExist();
        this.getSession().getDescriptor(Employee.class).setOptimisticLockingPolicy(this.lockPolicy);
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).getQueryManager().checkDatabaseForDoesExist();
        this.lockPolicy = this.getSession().getDescriptor(Employee.class).getOptimisticLockingPolicy();
        this.getSession().getDescriptor(Employee.class).setOptimisticLockingPolicy(null);
    }

    @Override
    public void test() {
        Employee employee = (Employee)this.getSession().readObject(Employee.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.clone = (Employee)uow.registerObject((Object)employee);
        this.clone.setFirstName("No identity at: " + new Timestamp(System.currentTimeMillis()));
        uow.commit();
    }

    @Override
    public void verify() {
        if (this.clone.address.isInstantiated() || this.clone.manager.isInstantiated() || this.clone.managedEmployees.isInstantiated() || this.clone.phoneNumbers.isInstantiated() || this.clone.projects.isInstantiated()) {
            throw new TestErrorException("Unexpected triggerings of ValueHolders during an updat -  NoIdentityMap");
        }
    }
}

