/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.dynamichelper;

import java.util.List;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DynamicHelperTestSuite {
    public static final String PACKAGE_PREFIX = DynamicHelperTestSuite.class.getPackage().getName();
    public static final String EMPLOYEE_CLASSNAME = PACKAGE_PREFIX + ".Employee";
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class empClass = dcl.createDynamicClass(EMPLOYEE_CLASSNAME);
        DynamicTypeBuilder typeBuilder = new DynamicTypeBuilder(empClass, null, new String[]{"D_EMPLOYEE"});
        typeBuilder.setPrimaryKeyFields(new String[]{"EMP_ID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "EMP_ID");
        typeBuilder.addDirectMapping("firstName", String.class, "F_NAME");
        typeBuilder.addDirectMapping("lastName", String.class, "L_NAME");
        dynamicHelper.addTypes(true, false, new DynamicType[]{typeBuilder.getType()});
        DynamicType empType = new DynamicHelper(session).getType("Employee");
        Assert.assertNotNull((String)"No type found for Employee", (Object)empType);
        DynamicEntity e1 = empType.newDynamicEntity();
        e1.set("id", (Object)1);
        e1.set("firstName", (Object)"Mike");
        e1.set("lastName", (Object)"Norman");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)e1);
        uow.commit();
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @Test
    public void createQuery_ValidReadObjectQuery() throws Exception {
        ReadObjectQuery query = dynamicHelper.newReadObjectQuery("Employee");
        Assert.assertNotNull((Object)query);
        query.setSelectionCriteria(query.getExpressionBuilder().get("id").equal(1L));
        DynamicEntity emp = (DynamicEntity)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)emp);
    }

    @Test
    public void createQuery_ValidReadAllQuery() throws Exception {
        ReadAllQuery query = dynamicHelper.newReadAllQuery("Employee");
        Assert.assertNotNull((Object)query);
        List emps = (List)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)emps);
    }

    @Test
    public void createQuery_ValidReportQuery() throws Exception {
        ReportQuery query = dynamicHelper.newReportQuery("Employee", new ExpressionBuilder());
        Assert.assertNotNull((Object)query);
        query.addCount();
        query.setShouldReturnSingleValue(true);
        Number count = (Number)session.executeQuery((DatabaseQuery)query);
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.longValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullArgs() {
        new DynamicHelper(DynamicTestingHelper.createEmptySession()).newReadAllQuery(null);
    }
}

