/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeObjectTest;

public class ConfigurableUpdateChangeObjectTest
extends UpdateChangeObjectTest {
    protected Hashtable cacheSyncConfigValues = null;
    protected Hashtable oldCacheSyncConfigValues = null;

    public ConfigurableUpdateChangeObjectTest(Employee employee, Hashtable cacheSyncConfigValues) {
        super(employee);
        this.cacheSyncConfigValues = cacheSyncConfigValues;
    }

    @Override
    public void setup() {
        this.oldCacheSyncConfigValues = new Hashtable();
        Enumeration keys = this.cacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            if (descriptor == null) continue;
            int cacheSyncType = descriptor.getCacheSynchronizationType();
            Object newCacheSyncType = this.cacheSyncConfigValues.get(keyClass);
            if (newCacheSyncType == null) continue;
            this.oldCacheSyncConfigValues.put(keyClass, cacheSyncType);
            descriptor.setCacheSynchronizationType(((Integer)newCacheSyncType).intValue());
        }
        super.setup();
    }

    @Override
    public void verify() {
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (this.isObjectValidOnDistributedServer(this.objectFromDatabase)) {
            throw new TestErrorException("Object was not invalidated in remote cache.");
        }
        super.verify();
    }

    @Override
    public void reset() {
        super.reset();
        Enumeration keys = this.oldCacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            int newCacheSyncType = (Integer)this.oldCacheSyncConfigValues.get(keyClass);
            descriptor.setCacheSynchronizationType(newCacheSyncType);
        }
    }
}

