/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.DirectEntityU1MMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;
import org.eclipse.persistence.testing.tests.collections.map.TestReadDirectEntityU1MMapMapping;

public class TestUpdateDirectEntityU1MMapMapping
extends TestReadDirectEntityU1MMapMapping {
    protected OneToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldPrivateOwnedValue = false;
    protected DirectEntityU1MMapHolder changedHolder = null;

    public TestUpdateDirectEntityU1MMapMapping() {
    }

    public TestUpdateDirectEntityU1MMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateDirectEntity1MMapMapping privateOwned=" + usePrivateOwned);
    }

    @Override
    public void setup() {
        this.mapping = (OneToManyMapping)this.getSession().getProject().getDescriptor(DirectEntityU1MMapHolder.class).getMappingForAttributeName("directToEntityMap");
        this.oldPrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        super.setup();
    }

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(DirectEntityU1MMapHolder.class, this.holderExp);
        this.changedHolder = (DirectEntityU1MMapHolder)this.holders.get(0);
        this.changedHolder.removeDirectToEntityMapItem(11);
        EntityMapValue mapValue = new EntityMapValue();
        mapValue.setId(3);
        mapValue = (EntityMapValue)uow.registerObject((Object)mapValue);
        this.changedHolder.addDirectToEntityMapItem(33, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.holders = this.getSession().readAllObjects(DirectEntityU1MMapHolder.class, this.holderExp);
        DirectEntityU1MMapHolder holder = (DirectEntityU1MMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (holder.getDirectToEntityMap().containsKey(1)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        EntityMapValue value = (EntityMapValue)holder.getDirectToEntityMap().get(33);
        if (value.getId() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EntityMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned EntityMapValue was not deleted.");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mapping.setIsPrivateOwned(this.oldPrivateOwnedValue);
    }
}

