/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateDirectMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;

public class TestReadAggregateDirectMapMapping
extends TestCase {
    protected List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected DirectCollectionMapping mapping = null;
    protected Expression holderExp;

    public TestReadAggregateDirectMapMapping() {
    }

    public TestReadAggregateDirectMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadAggregateDirectMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (DirectCollectionMapping)this.getSession().getProject().getDescriptor(AggregateDirectMapHolder.class).getMappingForAttributeName("aggregateToDirectMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(AggregateDirectMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AggregateDirectMapHolder holder = new AggregateDirectMapHolder();
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(1);
        holder.addAggregateToDirectMapItem(mapKey, 1);
        AggregateMapKey mapKey2 = new AggregateMapKey();
        mapKey2.setKey(2);
        holder.addAggregateToDirectMapItem(mapKey2, 2);
        uow.registerObject((Object)holder);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(holder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(AggregateDirectMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        AggregateDirectMapHolder holder = (AggregateDirectMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getAggregateToDirectMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getAggregateToDirectMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of Map values was read.");
        }
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(1);
        Integer value = (Integer)holder.getAggregateToDirectMap().get(mapKey);
        if (value != 1) {
            throw new TestErrorException("Incorrect map value was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

