/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Parent;
import org.eclipse.persistence.testing.models.aggregate.StepChild;

public class AggregateRelationshipsTargetOneToOneTestCase
extends TestCase {
    protected Parent originalParent;
    protected Parent readParent;

    public AggregateRelationshipsTargetOneToOneTestCase() {
        this.setDescription("AggregateRelationships: test target OneToOneMapping");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalParent = new Parent();
        StepChild stepChild = new StepChild();
        this.originalParent.getAggregate().setStepChild(stepChild);
        stepChild.setParent(this.originalParent);
        uow.registerObject((Object)this.originalParent);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        int id = this.originalParent.getId();
        try {
            this.readParent = (Parent)this.getSession().readObject(Parent.class, new ExpressionBuilder().get("id").equal(id));
        }
        catch (EclipseLinkException exception) {
            this.throwError("An exception occurred whilst reading back a Parent object with id " + id, exception);
        }
    }

    public void verify() {
        AggregateRelationshipsTargetOneToOneTestCase.assertNotNull((String)"Parent read back should not be null", (Object)this.readParent);
        this.compareObjects(this.originalParent, this.readParent);
        this.compareObjects(this.originalParent.getAggregate().getStepChild(), this.readParent.getAggregate().getStepChild());
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.deleteObject((Object)this.originalParent.getAggregate().getStepChild());
        uow.deleteObject((Object)this.originalParent);
        uow.commit();
    }
}

