/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.events;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.CreditCard;
import org.eclipse.persistence.testing.models.events.EmailAccount;
import org.eclipse.persistence.testing.models.events.Order;
import org.eclipse.persistence.testing.models.events.Phone;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Customer {
    public Address address;
    public Phone phoneNumber;
    public EmailAccount email;
    public CreditCard creditCard;
    public String name;
    public ValueHolderInterface orders;
    public Vector associations = new Vector(3);
    public Number id;
    public boolean preWrite;
    public boolean postWrite;
    public boolean preUpdate;

    public Customer() {
        this.orders = new ValueHolder(new Vector());
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Customer.class);
        descriptor.setTableName("EVENTCUSTOMER");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.dontUseIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("EVENTCUSTOMER.ADDRESS_ID", "EADDRESS.ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToOneMapping phoneMapping = new OneToOneMapping();
        phoneMapping.setAttributeName("phoneNumber");
        phoneMapping.setReferenceClass(Phone.class);
        phoneMapping.dontUseIndirection();
        phoneMapping.privateOwnedRelationship();
        phoneMapping.addForeignKeyFieldName("EVENTCUSTOMER.PHONE_ID", "EPHONE.ID");
        descriptor.addMapping((DatabaseMapping)phoneMapping);
        OneToOneMapping emailMapping = new OneToOneMapping();
        emailMapping.setAttributeName("email");
        emailMapping.setReferenceClass(EmailAccount.class);
        emailMapping.dontUseIndirection();
        emailMapping.privateOwnedRelationship();
        emailMapping.addForeignKeyFieldName("EVENTCUSTOMER.EMAIL_ID", "EMAILACC.ID");
        descriptor.addMapping((DatabaseMapping)emailMapping);
        DirectCollectionMapping associationsMapping = new DirectCollectionMapping();
        associationsMapping.setAttributeName("associations");
        associationsMapping.dontUseIndirection();
        associationsMapping.setReferenceTableName("EASSOCIATIONS");
        associationsMapping.setDirectFieldName("EASSOCIATIONS.DESCRIP");
        associationsMapping.addReferenceKeyFieldName("EASSOCIATIONS.CUSTOMER_ID", "EVENTCUSTOMER.ID");
        descriptor.addMapping((DatabaseMapping)associationsMapping);
        OneToManyMapping ordersMapping = new OneToManyMapping();
        ordersMapping.setAttributeName("orders");
        ordersMapping.setReferenceClass(Order.class);
        ordersMapping.useBasicIndirection();
        ordersMapping.addTargetForeignKeyFieldName("EVENTORDER.CUSTOMER_ID", "EVENTCUSTOMER.ID");
        descriptor.addMapping((DatabaseMapping)ordersMapping);
        AggregateObjectMapping creditMapping = new AggregateObjectMapping();
        creditMapping.setAttributeName("creditCard");
        creditMapping.setReferenceClass(CreditCard.class);
        creditMapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)creditMapping);
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("name", "NAME");
        return descriptor;
    }

    public static Customer example1() {
        Customer customer = new Customer();
        customer.address = Address.example1();
        customer.email = EmailAccount.example1();
        customer.phoneNumber = Phone.example1();
        ((Vector)customer.orders.getValue()).add(Order.example2());
        ((Vector)customer.orders.getValue()).add(Order.example1());
        customer.associations.add("Mickey Mouse Club");
        customer.associations.add("Canadian Penitentiary System");
        customer.name = "John Lancy";
        customer.creditCard = new CreditCard();
        customer.creditCard.number = "346556544565";
        customer.creditCard.expiry = "04/03";
        return customer;
    }

    public static Customer example2() {
        Customer customer = new Customer();
        customer.address = Address.example2();
        customer.email = EmailAccount.example2();
        customer.phoneNumber = Phone.example2();
        ((Vector)customer.orders.getValue()).add(Order.example3());
        ((Vector)customer.orders.getValue()).add(Order.example4());
        customer.associations.add("Masons");
        customer.associations.add("Illuminaty");
        customer.name = "Bobby Ore";
        customer.creditCard = new CreditCard();
        customer.creditCard.number = "456556544565";
        customer.creditCard.expiry = "03/03";
        return customer;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("EVENTCUSTOMER");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("ADDRESS_ID", BigDecimal.class, 15);
        definition.addField("PHONE_ID", BigDecimal.class, 15);
        definition.addField("EMAIL_ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 40);
        definition.addField("CARD_NUMBER", String.class, 12);
        definition.addField("CARD_EXPIRY", String.class, 5);
        return definition;
    }

    public static TableDefinition directCollectionTableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("EASSOCIATIONS");
        definition.addField("CUSTOMER_ID", BigDecimal.class, 15);
        definition.addField("DESCRIP", String.class, 40);
        return definition;
    }
}

