/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PrivateDeleteTest
extends TestCase {
    protected Employee m_employeeFromDatabase;
    protected Number m_nManagedEmployeeID;
    protected Number m_nAddressId;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.beginTransaction();
        ExpressionBuilder expBldr = new ExpressionBuilder();
        Expression whatWeWant = expBldr.get("lastName").equal((Object)"May");
        this.m_employeeFromDatabase = (Employee)this.getSession().readObject(Employee.class, whatWeWant);
    }

    public void test() {
        this.m_nAddressId = this.m_employeeFromDatabase.getAddress().getId();
        this.m_nManagedEmployeeID = ((Employee)this.m_employeeFromDatabase.getManagedEmployees().elementAt(0)).getId();
        this.getSession().executeNonSelectingCall((Call)new SQLCall("update PROJECT set LEADER_ID = null where LEADER_ID = " + this.m_employeeFromDatabase.getId()));
        this.getSession().executeNonSelectingCall((Call)new SQLCall("update EMPLOYEE set MANAGER_ID = null where MANAGER_ID = " + this.m_employeeFromDatabase.getId()));
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setObject((Object)this.m_employeeFromDatabase);
        query.cascadePrivateParts();
        this.getSession().executeQuery((DatabaseQuery)query);
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Expression expression = new ExpressionBuilder().get("id").equal(this.m_nManagedEmployeeID.intValue());
        Employee managedEmployee = (Employee)this.getSession().readObject(Employee.class, expression);
        Expression expression2 = new ExpressionBuilder().get("id").equal(this.m_nAddressId.intValue());
        Address address = (Address)this.getSession().readObject(Address.class, expression2);
        if (address != null) {
            throw new TestErrorException("The private delete test failed.  The private owned relationship was not deleted");
        }
        if (managedEmployee == null) {
            throw new TestErrorException("The private delete test failed.  The non-private member was deleted");
        }
    }
}

