/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking.cascaded;

import java.util.ArrayList;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.Cat;
import org.eclipse.persistence.testing.models.optimisticlocking.Toy;

public class Cascaded12MInheritanceOptimisticLockingTest
extends AutoVerifyTestCase {
    private Toy toy = null;
    private Cat cat = null;
    private int catVersion = 0;
    private int toyVersion = 0;

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.cat = new Cat();
        this.cat.setName("Bud");
        this.toy = new Toy();
        this.toy.setName("Ball");
        ArrayList<Toy> toys = new ArrayList<Toy>();
        toys.add(this.toy);
        this.cat.setToys(toys);
        this.toy.setOwner(this.cat);
        uow.registerObject((Object)this.cat);
        uow.registerObject((Object)this.toy);
        uow.commit();
        this.cat = (Cat)this.getSession().refreshObject((Object)this.cat);
        this.toy = (Toy)this.getSession().refreshObject((Object)this.toy);
        this.catVersion = this.cat.getVersion();
        this.toyVersion = this.toy.getVersion();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.cat = (Cat)uow.readObject((Object)this.cat);
        this.toy = (Toy)this.cat.getToys().get(0);
        this.toy.setName("Red Ball");
        uow.commit();
    }

    public void verify() {
        this.cat = (Cat)this.getSession().refreshObject((Object)this.cat);
        if (this.cat.getVersion() <= this.catVersion) {
            throw new TestErrorException("Version of owner was not updated through cascading.");
        }
    }
}

