/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Phone;
import org.eclipse.persistence.testing.models.mapping.Shipment;

public class MTMPrivateOwnedWithValueholderDeleteObjectTest
extends DeleteObjectTest {
    Vector phonesBeforeDelete;

    public MTMPrivateOwnedWithValueholderDeleteObjectTest() {
    }

    public MTMPrivateOwnedWithValueholderDeleteObjectTest(Object originalObject) {
        super(originalObject);
    }

    protected void setup() {
        this.beginTransaction();
        this.originalObject = this.getSession().readObject(Employee.class);
        this.phonesBeforeDelete = ((Employee)this.originalObject).getPhoneNumbers();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalObject = uow.readObject(Employee.class);
        Employee emp = (Employee)this.originalObject;
        uow.deleteObject((Object)emp);
        Enumeration enumtr = emp.getShipments().elements();
        while (enumtr.hasMoreElements()) {
            Shipment ship = (Shipment)enumtr.nextElement();
            ship.employees.removeElement(emp);
        }
        enumtr = emp.getManagedEmployees().elements();
        while (enumtr.hasMoreElements()) {
            Employee emp2 = (Employee)enumtr.nextElement();
            emp2.manager = null;
        }
        uow.commit();
    }

    protected void verify() {
        Enumeration enumBeforeDelete = this.phonesBeforeDelete.elements();
        while (enumBeforeDelete.hasMoreElements()) {
            Phone phoneBeforeDelete = (Phone)enumBeforeDelete.nextElement();
            if (this.verifyDelete(phoneBeforeDelete)) continue;
            throw new TestErrorException("The entry in the relation table is deleted before the value holder is triggered");
        }
    }
}

