/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class SeqMapIter
extends PlanIter {
    private final PlanIter theInputIter;
    private final PlanIter theMapIter;
    private final int theCtxItemReg;

    public SeqMapIter(Expr e, int resultReg, PlanIter inputIter, PlanIter mapIter, int ctxItemReg) {
        super(e, resultReg);
        this.theInputIter = inputIter;
        this.theMapIter = mapIter;
        this.theCtxItemReg = ctxItemReg;
    }

    SeqMapIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theCtxItemReg = in.readInt();
        this.theInputIter = SeqMapIter.deserializeIter(in, serialVersion);
        this.theMapIter = SeqMapIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeInt(this.theCtxItemReg);
        SeqMapIter.serializeIter(this.theInputIter, out, serialVersion);
        SeqMapIter.serializeIter(this.theMapIter, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SEQ_MAP;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new SeqMapState());
        this.theInputIter.open(rcb);
        this.theMapIter.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInputIter.reset(rcb);
        this.theMapIter.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInputIter.close(rcb);
        this.theMapIter.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        SeqMapState state = (SeqMapState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        while (true) {
            boolean more;
            if (state.theCtxItem == null) {
                more = this.theInputIter.next(rcb);
                if (!more) {
                    state.done();
                    return false;
                }
                state.theCtxItem = rcb.getRegVal(this.theInputIter.getResultReg());
                rcb.setRegVal(this.theCtxItemReg, state.theCtxItem);
                this.theMapIter.reset(rcb);
            }
            if (more = this.theMapIter.next(rcb)) break;
            state.theCtxItem = null;
        }
        FieldValueImpl res = rcb.getRegVal(this.theMapIter.getResultReg());
        rcb.setRegVal(this.theResultReg, res);
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInputIter.display(sb, formatter);
        sb.append(",\n");
        this.theMapIter.display(sb, formatter);
        if (this.theCtxItemReg >= 0) {
            sb.append(",\n");
            formatter.indent(sb);
            sb.append("theCtxItemReg : ").append(this.theCtxItemReg);
        }
    }

    private static class SeqMapState
    extends PlanIterState {
        FieldValueImpl theCtxItem;

        private SeqMapState() {
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCtxItem = null;
        }

        @Override
        public void close() {
            super.close();
            this.theCtxItem = null;
        }
    }
}

