/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint.net;

import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.InstanceLogger;
import com.sleepycat.je.rep.net.SSLAuthenticator;
import com.sleepycat.je.rep.utilint.net.AbstractDataChannel;
import java.io.IOException;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLDataChannel
extends AbstractDataChannel {
    private static final ReadableByteChannel NULL_READ_CHANNEL = new NullReadChannel();
    private volatile ReadableByteChannel wrappedReadChannel;
    private final SSLEngine sslEngine;
    private final ByteBuffer netRecvBuffer;
    private final ByteBuffer netXmitBuffer;
    private final ByteBuffer appRecvBuffer;
    private final ByteBuffer emptyXmitBuffer;
    private final ReentrantLock readLock = new ReentrantLock();
    private final ReentrantLock writeLock = new ReentrantLock();
    private volatile boolean channelClosed = false;
    private volatile boolean sslInboundClosed = false;
    private final String targetHost;
    private final SSLAuthenticator authenticator;
    private final HostnameVerifier hostVerifier;
    private volatile boolean peerTrusted = false;
    private final InstanceLogger logger;

    public SSLDataChannel(SocketChannel socketChannel, SSLEngine sslEngine, String targetHost, HostnameVerifier hostVerifier, SSLAuthenticator authenticator, InstanceLogger logger) {
        super(socketChannel);
        this.sslEngine = sslEngine;
        this.targetHost = targetHost;
        this.authenticator = authenticator;
        this.hostVerifier = hostVerifier;
        this.logger = logger;
        SSLSession sslSession = sslEngine.getSession();
        int netBufferSize = sslSession.getPacketBufferSize();
        int appBufferSize = sslSession.getApplicationBufferSize();
        this.emptyXmitBuffer = ByteBuffer.allocate(1);
        this.netXmitBuffer = ByteBuffer.allocate(3 * netBufferSize);
        this.appRecvBuffer = ByteBuffer.allocate(2 * appBufferSize);
        this.netRecvBuffer = ByteBuffer.allocate(2 * netBufferSize);
        try {
            this.wrappedReadChannel = this.isBlocking() ? Channels.newChannel(socketChannel.socket().getInputStream()) : socketChannel;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get stream from connected socket " + socketChannel, e);
        }
    }

    @Override
    public synchronized void configureBlocking(boolean block) throws IOException {
        if (block == this.isBlocking()) {
            return;
        }
        this.wrappedReadChannel = NULL_READ_CHANNEL;
        this.socketChannel.configureBlocking(block);
        this.wrappedReadChannel = block ? Channels.newChannel(this.socketChannel.socket().getInputStream()) : this.socketChannel;
        this.configuredBlocking = block;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isTrustCapable() {
        return this.authenticator != null;
    }

    @Override
    public boolean isTrusted() {
        return this.peerTrusted;
    }

    @Override
    public int read(ByteBuffer toFill) throws IOException, SSLException {
        return (int)this.read(new ByteBuffer[]{toFill}, 0, 1);
    }

    @Override
    public long read(ByteBuffer[] toFill) throws IOException, SSLException {
        return this.read(toFill, 0, toFill.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] toFill, int offset, int length) throws IOException, SSLException {
        if (offset < 0 || length < 0 || offset > toFill.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.channelClosed) {
            throw new ClosedChannelException();
        }
        int toFillRemaining = 0;
        for (int i = offset; i < offset + length; ++i) {
            toFillRemaining += toFill[i].remaining();
        }
        if (toFillRemaining <= 0) {
            return 0L;
        }
        if (!this.isBlocking()) {
            this.flush_internal();
        }
        this.readLock.lock();
        try {
            if (this.appRecvBuffer.position() > 0) {
                this.appRecvBuffer.flip();
                int count = this.transfer(this.appRecvBuffer, toFill, offset, length);
                this.appRecvBuffer.compact();
                long l = count;
                return l;
            }
        }
        finally {
            this.readLock.unlock();
        }
        int readCount = 0;
        while (readCount == 0) {
            if (this.sslEngine.isInboundDone()) {
                return -1L;
            }
            HSProcStatus pstatus = this.processAnyHandshakes(false);
            this.readLock.lock();
            try {
                if (this.appRecvBuffer.position() > 0) {
                    this.appRecvBuffer.flip();
                    readCount = this.transfer(this.appRecvBuffer, toFill, offset, length);
                    this.appRecvBuffer.compact();
                    break;
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                boolean progress = false;
                this.readLock.lock();
                try {
                    if (this.netRecvBuffer.position() > 0) {
                        int initialPos = this.netRecvBuffer.position();
                        this.netRecvBuffer.flip();
                        SSLEngineResult engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                        this.netRecvBuffer.compact();
                        int updatedPos = this.netRecvBuffer.position();
                        if (updatedPos != initialPos) {
                            progress = true;
                        }
                        switch (engineResult.getStatus()) {
                            case BUFFER_UNDERFLOW: {
                                break;
                            }
                            case BUFFER_OVERFLOW: {
                                throw new BufferOverflowException();
                            }
                            case CLOSED: {
                                this.socketChannel.socket().shutdownInput();
                                break;
                            }
                        }
                    }
                    if (progress) continue;
                    int count = this.readFromChannel();
                    if (count < 0) {
                        readCount = count;
                        continue;
                    }
                    if (count != 0) continue;
                    break;
                }
                finally {
                    this.readLock.unlock();
                    continue;
                }
            }
            if (this.isBlocking() || pstatus == HSProcStatus.APP_WAIT) continue;
            if (pstatus == HSProcStatus.AGAIN) {
                throw new AssertionError();
            }
            break;
        }
        if (readCount < 0) {
            this.sslEngine.closeInbound();
            this.sslInboundClosed = true;
        }
        if (this.sslEngine.isInboundDone()) {
            return -1L;
        }
        return readCount;
    }

    @Override
    public int write(ByteBuffer toSend) throws IOException, SSLException {
        return (int)this.write(new ByteBuffer[]{toSend}, 0, 1);
    }

    @Override
    public long write(ByteBuffer[] toSend) throws IOException, SSLException {
        return this.write(toSend, 0, toSend.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public long write(ByteBuffer[] toSend, int offset, int length) throws IOException, SSLException {
        if (offset < 0 || length < 0 || offset > toSend.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.channelClosed) {
            throw new ClosedChannelException();
        }
        toSendRemaining = 0;
        for (i = offset; i < offset + length; ++i) {
            toSendRemaining += toSend[i].remaining();
        }
        if (toSendRemaining == 0) {
            return 0L;
        }
        toSendTotal = toSendRemaining;
        this.flush_internal();
        do {
            this.writeLock.lock();
            try {
                engineResult = this.sslEngine.wrap(toSend, offset, length, this.netXmitBuffer);
                toSendRemaining -= engineResult.bytesConsumed();
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[engineResult.getStatus().ordinal()]) {
                    case 2: {
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        throw new BufferUnderflowException();
                    }
                    case 3: {
                        throw new SSLException("Attempt to write to a closed SSL Channel");
                    }
                    ** default:
lbl28:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.writeLock.unlock();
            }
            this.processAnyHandshakes(false);
            this.flush_internal();
        } while (toSendRemaining != 0 && this.isBlocking());
        return toSendTotal - toSendRemaining;
    }

    @Override
    public DataChannel.FlushStatus flush() throws IOException {
        return this.flush_internal();
    }

    private DataChannel.FlushStatus flush_internal() throws IOException {
        if (this.writeLock.tryLock()) {
            try {
                block14: {
                    int count;
                    block13: {
                        DataChannel.FlushStatus flushStatus;
                        if (this.netXmitBuffer.position() == 0) {
                            DataChannel.FlushStatus flushStatus2 = DataChannel.FlushStatus.DONE;
                            return flushStatus2;
                        }
                        this.netXmitBuffer.flip();
                        try {
                            count = this.socketChannel.write(this.netXmitBuffer);
                            if (this.netXmitBuffer.remaining() != 0) break block13;
                            flushStatus = DataChannel.FlushStatus.DONE;
                            this.netXmitBuffer.compact();
                        }
                        catch (Throwable throwable) {
                            this.netXmitBuffer.compact();
                            throw throwable;
                        }
                        return flushStatus;
                    }
                    if (count == 0) break block14;
                    DataChannel.FlushStatus flushStatus = DataChannel.FlushStatus.AGAIN;
                    this.netXmitBuffer.compact();
                    return flushStatus;
                }
                DataChannel.FlushStatus flushStatus = DataChannel.FlushStatus.SO_WAIT_WRITE;
                this.netXmitBuffer.compact();
                return flushStatus;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return DataChannel.FlushStatus.CONTENTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, SSLException {
        block14: {
            try {
                HSProcStatus pstatus;
                this.ensureCloseForBlocking();
                DataChannel.FlushStatus fstatus = this.flush_internal();
                if (fstatus == DataChannel.FlushStatus.CONTENTION) {
                    throw new IOException("Concurrent operations during close");
                }
                if (!this.sslEngine.isOutboundDone()) {
                    this.sslEngine.closeOutbound();
                    pstatus = this.processAnyHandshakes(true);
                } else {
                    pstatus = !this.sslEngine.isInboundDone() && this.sslInboundClosed ? this.processOneHandshake(true) : HSProcStatus.DONE;
                }
                if (pstatus != HSProcStatus.CONTENTION) break block14;
                throw new IOException("Concurrent operations during close");
            }
            catch (Throwable throwable) {
                try {
                    this.socketChannel.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.channelClosed = true;
                }
                throw throwable;
            }
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.channelClosed = true;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public DataChannel.CloseAsyncStatus closeAsync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CASE], 13[SWITCH], 28[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void closeForcefully() throws IOException {
        try {
            this.sslEngine.closeOutbound();
            this.socketChannel.close();
        }
        finally {
            this.channelClosed = true;
        }
    }

    @Override
    public boolean isOpen() {
        if (!this.socketChannel.isOpen()) {
            return false;
        }
        return !this.channelClosed;
    }

    private int transfer(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) {
        int transferred = 0;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer dst = dsts[i];
            int space = dst.remaining();
            if (src.remaining() > space) {
                ByteBuffer slice = src.slice();
                slice.limit(space);
                dst.put(slice);
                src.position(src.position() + space);
                transferred += space;
                continue;
            }
            transferred += src.remaining();
            dst.put(src);
            break;
        }
        return transferred;
    }

    private HSProcStatus processAnyHandshakes(boolean isClosing) throws IOException {
        HSProcStatus pstatus;
        block4: while (true) {
            pstatus = this.processOneHandshake(isClosing);
            switch (pstatus) {
                case AGAIN: {
                    continue block4;
                }
                case CONTENTION: 
                case DONE: 
                case APP_WAIT: 
                case SO_WAIT_READ: 
                case SO_WAIT_WRITE: {
                    return pstatus;
                }
            }
            break;
        }
        throw new AssertionError((Object)("Unknown HSProcStatus: " + (Object)((Object)pstatus)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HSProcStatus processOneHandshake(boolean isClosing) throws IOException {
        int readCount = 0;
        DataChannel.FlushStatus fstatus = DataChannel.FlushStatus.DONE;
        SSLEngineResult engineResult = null;
        switch (this.sslEngine.getHandshakeStatus()) {
            case FINISHED: {
                return HSProcStatus.DONE;
            }
            case NEED_TASK: {
                this.runDelegatedTasks();
                return HSProcStatus.AGAIN;
            }
            case NEED_UNWRAP: {
                boolean unwrapped = false;
                try {
                    this.flush_internal();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                if (isClosing) {
                    if (!this.readLock.tryLock()) {
                        return HSProcStatus.CONTENTION;
                    }
                } else {
                    this.readLock.lock();
                }
                try {
                    if (this.netRecvBuffer.position() > 0) {
                        this.netRecvBuffer.flip();
                        engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                        this.netRecvBuffer.compact();
                        if (engineResult.getStatus() == SSLEngineResult.Status.OK) {
                            unwrapped = true;
                        }
                    }
                    if (unwrapped || this.sslEngine.isInboundDone()) break;
                    readCount = this.readFromChannel();
                    if (readCount < 0) {
                        try {
                            this.sslEngine.closeInbound();
                            this.sslInboundClosed = true;
                        }
                        catch (SSLException sSLException) {
                            // empty catch block
                        }
                    }
                    this.netRecvBuffer.flip();
                    engineResult = this.sslEngine.unwrap(this.netRecvBuffer, this.appRecvBuffer);
                    this.netRecvBuffer.compact();
                    break;
                }
                finally {
                    this.readLock.unlock();
                }
            }
            case NEED_WRAP: {
                if (isClosing) {
                    if (!this.writeLock.tryLock()) {
                        return HSProcStatus.CONTENTION;
                    }
                } else {
                    this.writeLock.lock();
                }
                try {
                    engineResult = this.sslEngine.wrap(this.emptyXmitBuffer, this.netXmitBuffer);
                }
                finally {
                    this.writeLock.unlock();
                }
                if (engineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                    try {
                        this.flush_internal();
                    }
                    catch (SocketException socketException) {}
                    break;
                }
                fstatus = this.flush_internal();
                break;
            }
            case NOT_HANDSHAKING: {
                return HSProcStatus.DONE;
            }
        }
        if (engineResult == null) return HSProcStatus.AGAIN;
        if (engineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.sslEngine.getUseClientMode()) {
                if (this.hostVerifier != null) {
                    this.peerTrusted = this.hostVerifier.verify(this.targetHost, this.sslEngine.getSession());
                    if (!this.peerTrusted) {
                        this.logger.log(Level.INFO, "SSL host verifier reports that connection target is NOT valid");
                        throw new IOException("Server identity could not be verified");
                    }
                    this.logger.log(Level.FINE, "SSL host verifier reports that connection target is valid");
                }
            } else if (this.authenticator != null) {
                this.peerTrusted = this.authenticator.isTrusted(this.sslEngine.getSession());
                if (this.peerTrusted) {
                    this.logger.log(Level.FINE, "SSL authenticator reports that channel is trusted");
                } else {
                    this.logger.log(Level.INFO, "SSL authenticator reports that channel is NOT trusted");
                }
            }
        }
        switch (engineResult.getStatus()) {
            case BUFFER_UNDERFLOW: {
                if (readCount <= 0) return HSProcStatus.SO_WAIT_READ;
                return HSProcStatus.AGAIN;
            }
            case BUFFER_OVERFLOW: {
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return HSProcStatus.APP_WAIT;
                }
                switch (fstatus) {
                    case DISABLED: {
                        throw new AssertionError();
                    }
                    case AGAIN: 
                    case DONE: {
                        return HSProcStatus.AGAIN;
                    }
                    case SO_WAIT_WRITE: {
                        return HSProcStatus.SO_WAIT_WRITE;
                    }
                    case CONTENTION: {
                        return HSProcStatus.CONTENTION;
                    }
                }
                throw new AssertionError((Object)("Unknown flush status: " + (Object)((Object)fstatus)));
            }
            case CLOSED: {
                if (!this.sslEngine.isOutboundDone()) return HSProcStatus.DONE;
                try {
                    this.socketChannel.socket().shutdownOutput();
                    return HSProcStatus.DONE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return HSProcStatus.DONE;
            }
        }
        return HSProcStatus.AGAIN;
    }

    private void runDelegatedTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    private int readFromChannel() throws IOException {
        return this.wrappedReadChannel.read(this.netRecvBuffer);
    }

    private static class NullReadChannel
    implements ReadableByteChannel {
        private NullReadChannel() {
        }

        @Override
        public int read(ByteBuffer dst) {
            throw new IllegalStateException("Reading from a channel that should not be used. This indicates that a channel is switching between blocking and non-blocking mode while a concurrent read happens. We do not support such behavior");
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isOpen() {
            return true;
        }
    }

    private static enum HSProcStatus {
        CONTENTION,
        SO_WAIT_READ,
        SO_WAIT_WRITE,
        AGAIN,
        APP_WAIT,
        DONE;

    }
}

