/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryAcrossOneToOneMapping
extends TestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.allEmployees = new Vector();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").greaterThan((Object)"Montreal"));
        this.getSession().removeQuery("getAllEmployees");
        this.getSession().addQuery("getAllEmployees", (DatabaseQuery)this.queryAll);
        this.allEmployees = (Vector)this.getSession().executeQuery("getAllEmployees");
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            ((Employee)enumtr.nextElement()).getAddress();
        }
    }

    public void test() {
        this.queryObject = new ReadObjectQuery();
        this.queryObject.setReferenceClass(Employee.class);
        this.queryObject.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.get("address").get("city").equal((Object)"Ottawa");
        this.queryObject.setSelectionCriteria(exp);
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
    }

    public void verify() {
        if (!this.allEmployees.contains(this.employee)) {
            throw new TestErrorException("Employee is not the same as the one in cache!");
        }
    }
}

