/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import oracle.kv.impl.async.CreatorEndpoint;
import oracle.kv.impl.async.DialogHandler;
import oracle.kv.impl.async.DialogHandlerFactory;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.async.EndpointGroup;
import oracle.kv.impl.async.EndpointHandler;
import oracle.kv.impl.async.EndpointHandlerManager;
import oracle.kv.impl.async.NetworkAddress;
import oracle.kv.impl.async.NullDialogStart;
import oracle.kv.impl.async.exception.ConnectionEndpointShutdownException;
import oracle.kv.impl.async.exception.InitialConnectIOException;
import oracle.kv.impl.util.ObjectUtil;

public abstract class AbstractCreatorEndpoint
implements CreatorEndpoint,
EndpointHandlerManager {
    private final EndpointGroup endpointGroup;
    protected final NetworkAddress remoteAddress;
    protected final EndpointConfig endpointConfig;
    private final Map<Integer, DialogHandlerFactory> dialogHandlerFactories = new ConcurrentHashMap<Integer, DialogHandlerFactory>();
    private final AtomicReference<EndpointHandler> handlerRef = new AtomicReference<Object>(null);
    private boolean isShutdown = false;

    protected AbstractCreatorEndpoint(EndpointGroup endpointGroup, NetworkAddress remoteAddress, EndpointConfig endpointConfig) {
        ObjectUtil.checkNull("endpointGroup", endpointGroup);
        ObjectUtil.checkNull("remoteAddress", remoteAddress);
        ObjectUtil.checkNull("endpointConfig", endpointConfig);
        this.endpointGroup = endpointGroup;
        this.remoteAddress = remoteAddress;
        this.endpointConfig = endpointConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDialog(int dialogType, DialogHandler dialogHandler, long timeoutMillis) {
        ObjectUtil.checkNull("dialogHandler", dialogHandler);
        EndpointHandler handler = this.handlerRef.get();
        if (handler != null) {
            handler.startDialog(dialogType, dialogHandler, timeoutMillis);
            return;
        }
        AbstractCreatorEndpoint abstractCreatorEndpoint = this;
        synchronized (abstractCreatorEndpoint) {
            if (this.isShutdown) {
                NullDialogStart.fail(dialogHandler, new ConnectionEndpointShutdownException(false, "endpoint already shutdown").getDialogException(false), this.endpointGroup.getSchedExecService());
                return;
            }
            try {
                handler = this.getOrConnect();
            }
            catch (IOException e) {
                NullDialogStart.fail(dialogHandler, new InitialConnectIOException(e, this.remoteAddress).getDialogException(false), null);
                return;
            }
        }
        handler.startDialog(dialogType, dialogHandler, timeoutMillis);
    }

    @Override
    public void enableResponding(int dialogType, DialogHandlerFactory factory) {
        ObjectUtil.checkNull("factory", factory);
        this.dialogHandlerFactories.put(dialogType, factory);
    }

    @Override
    public void disableResponding(int dialogType) {
        this.dialogHandlerFactories.remove(dialogType);
    }

    @Override
    public NetworkAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public EndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    @Override
    public int getNumDialogsLimit() {
        EndpointHandler handler = this.handlerRef.get();
        if (handler == null) {
            return -1;
        }
        return handler.getNumDialogsLimit();
    }

    @Override
    public void onHandlerShutdown(EndpointHandler handler) {
        if (!this.handlerRef.compareAndSet(handler, null)) {
            throw new IllegalStateException("The endpoint handler reference should not fail compareAndSet upon Shutting down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String detail, boolean force) {
        AbstractCreatorEndpoint abstractCreatorEndpoint = this;
        synchronized (abstractCreatorEndpoint) {
            this.isShutdown = true;
        }
        EndpointHandler handler = this.handlerRef.get();
        if (handler != null) {
            handler.shutdown(detail, force);
        }
    }

    public Map<Integer, DialogHandlerFactory> getDialogHandlerFactories() {
        return this.dialogHandlerFactories;
    }

    protected abstract EndpointHandler newEndpointHandler() throws IOException;

    private EndpointHandler getOrConnect() throws IOException {
        EndpointHandler handler = this.handlerRef.get();
        if (handler != null) {
            return handler;
        }
        handler = this.newEndpointHandler();
        if (!this.handlerRef.compareAndSet(null, handler)) {
            throw new AssertionError();
        }
        return handler;
    }

    public EndpointHandler getEndpointHandler() {
        return this.handlerRef.get();
    }
}

