/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.HashSet;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRDynamicEntity;
import org.eclipse.persistence.internal.xr.XRDynamicEntityAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicEntityVHAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicPropertiesManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class ProjectHelper {
    public static void fixOROXAccessors(Project orProject, Project oxProject) {
        XRDynamicClassLoader xrdecl;
        ConversionManager conversionManager;
        Platform platform;
        for (ClassDescriptor desc : orProject.getDescriptors().values()) {
            Class clz = desc.getJavaClass();
            if (!XRDynamicEntity.class.isAssignableFrom(clz)) continue;
            ClassDescriptor xdesc = null;
            if (oxProject != null) {
                xdesc = oxProject.getDescriptorForAlias(desc.getAlias());
            }
            XRDynamicPropertiesManager xrDPM = null;
            if (!clz.getName().endsWith("_CollectionWrapper")) {
                try {
                    XRDynamicEntity newInstance = (XRDynamicEntity)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    xrDPM = newInstance.fetchPropertiesManager();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HashSet<String> propertiesNameSet = new HashSet<String>();
            for (DatabaseMapping dm : desc.getMappings()) {
                String attributeName = dm.getAttributeName();
                DatabaseMapping xdm = null;
                if (xdesc != null) {
                    xdm = xdesc.getMappingForAttributeName(attributeName);
                }
                dm.setAttributeAccessor(new XRDynamicEntityAccessor(dm));
                if (xdm != null) {
                    if (dm.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frm = (ForeignReferenceMapping)dm;
                        if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                            xdm.setAttributeAccessor(new XRDynamicEntityVHAccessor(dm));
                        } else {
                            xdm.setAttributeAccessor(new XRDynamicEntityAccessor(dm));
                        }
                    } else {
                        xdm.setAttributeAccessor(new XRDynamicEntityAccessor(dm));
                    }
                }
                propertiesNameSet.add(attributeName);
            }
            if (xrDPM == null) continue;
            xrDPM.setPropertyNames(propertiesNameSet);
        }
        ClassLoader cl = null;
        Login login = orProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl != null && cl instanceof XRDynamicClassLoader) {
            xrdecl = (XRDynamicClassLoader)cl;
            xrdecl.dontGenerateSubclasses();
        }
        if (oxProject != null) {
            cl = null;
            login = oxProject.getDatasourceLogin();
            if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
                cl = conversionManager.getLoader();
            }
            if (cl != null && cl instanceof XRDynamicClassLoader) {
                xrdecl = (XRDynamicClassLoader)cl;
                xrdecl.dontGenerateSubclasses();
            }
        }
    }
}

