/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote.rmi.iiop;

import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.remote.RemoteCommand;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.remote.rmi.iiop.RMIRemoteSessionController;

public class RMIConnection
extends RemoteConnection {
    RMIRemoteSessionController remoteSessionController;

    public RMIConnection(RMIRemoteSessionController controller) {
        this.remoteSessionController = controller;
    }

    public void processCommand(RemoteCommand command) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject((Object)command);
            transporter.prepare((AbstractSession)this.session);
            transporter = this.getRemoteSessionController().processCommand(transporter);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public void beginTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().beginTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public void beginEarlyTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().beginEarlyTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public RemoteUnitOfWork commitRootUnitOfWork(RemoteUnitOfWork theRemoteUnitOfWork) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject((Object)theRemoteUnitOfWork);
            transporter.prepare((AbstractSession)this.session);
            transporter = this.getRemoteSessionController().commitRootUnitOfWork(transporter);
            transporter.expand((AbstractSession)this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (RemoteUnitOfWork)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public void commitTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().commitTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Session createRemoteSession() {
        return new RemoteSession((RemoteConnection)this);
    }

    public void cursoredStreamClose(ObjID remoteCursoredStreamOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamClose(new Transporter((Object)remoteCursoredStreamOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Vector cursoredStreamNextPage(RemoteCursoredStream remoteCursoredStream, ReadQuery query, DistributedSession session, int pageSize) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamNextPage(new Transporter((Object)remoteCursoredStream.getID()), pageSize);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Vector<Object> serverNextPageObjects = (Vector<Object>)transporter.getObject();
        if (serverNextPageObjects == null) {
            this.cursoredStreamClose(remoteCursoredStream.getID());
            return null;
        }
        Vector<Object> clientNextPageObjects = serverNextPageObjects;
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            clientNextPageObjects = new Vector<Object>(serverNextPageObjects.size());
            Enumeration objEnum = serverNextPageObjects.elements();
            while (objEnum.hasMoreElements()) {
                Object clientObject = session.getObjectCorrespondingTo(objEnum.nextElement(), transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
                clientNextPageObjects.addElement(clientObject);
            }
        }
        return clientNextPageObjects;
    }

    public int cursoredStreamSize(ObjID remoteCursoredStreamID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamSize(new Transporter((Object)remoteCursoredStreamID));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy policy, DistributedSession session) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter((Object)policy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
            remoteCursoredStream.setSession((AbstractSession)session);
            remoteCursoredStream.setPolicy((CursorPolicy)policy);
            if (policy.getQuery().isReadAllQuery() && !policy.getQuery().isReportQuery()) {
                this.fixObjectReferences(transporter, (ObjectLevelReadQuery)policy.getQuery(), session);
            }
            return remoteCursoredStream;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy policy, DistributedSession session) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter((Object)policy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteScrollableCursor remoteScrollableCursor = (RemoteScrollableCursor)transporter.getObject();
            remoteScrollableCursor.setSession((AbstractSession)session);
            remoteScrollableCursor.setPolicy((CursorPolicy)policy);
            return remoteScrollableCursor;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Vector getDefaultReadOnlyClasses() {
        try {
            Transporter transporter = this.getRemoteSessionController().getDefaultReadOnlyClasses();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Vector)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public ClassDescriptor getDescriptor(Class domainClass) {
        try {
            Transporter transporter = this.getRemoteSessionController().getDescriptor(new Transporter((Object)domainClass));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (ClassDescriptor)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        try {
            Transporter transporter = this.getRemoteSessionController().getDescriptorForAlias(new Transporter((Object)alias));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (ClassDescriptor)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Login getLogin() {
        try {
            Transporter transporter = this.getRemoteSessionController().getLogin();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Login)transporter.getObject();
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public RMIRemoteSessionController getRemoteSessionController() {
        return this.remoteSessionController;
    }

    public Object getSequenceNumberNamed(Object remoteFunctionCall) {
        try {
            Transporter transporter = this.getRemoteSessionController().getSequenceNumberNamed(new Transporter(remoteFunctionCall));
            Object returnValue = transporter.getObject();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return returnValue;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public void initializeIdentityMapsOnServerSession() {
        try {
            Transporter transporter = this.getRemoteSessionController().initializeIdentityMapsOnServerSession();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Transporter instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        try {
            Transporter transporter = this.getRemoteSessionController().instantiateRemoteValueHolderOnServer(new Transporter((Object)remoteValueHolder));
            transporter.expand((AbstractSession)this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Transporter remoteExecute(DatabaseQuery query) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject((Object)query);
            transporter.prepare((AbstractSession)this.session);
            transporter = this.getRemoteSessionController().executeQuery(transporter);
            transporter.expand((AbstractSession)this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public Transporter remoteExecuteNamedQuery(String name, Class javaClass, Vector arguments) {
        try {
            Transporter transporter = this.getRemoteSessionController().executeNamedQuery(new Transporter((Object)name), new Transporter((Object)javaClass), new Transporter((Object)arguments));
            transporter.expand((AbstractSession)this.session);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public void rollbackTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().rollbackTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
    }

    public boolean scrollableCursorAbsolute(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAbsolute(new Transporter((Object)remoteScrollableCursorOid), rows);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public void scrollableCursorAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorBeforeFirst(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorClose(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorClose(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public int scrollableCursorCurrentIndex(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return -1;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public boolean scrollableCursorFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorFirst(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsAfterLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsAfterLast(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsBeforeFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsBeforeFirst(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsFirst(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsFirst(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsLast(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorLast(ObjID remoteScrollableCursorOid) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorLast(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public Object scrollableCursorNextObject(ObjID remoteScrollableCursorOid, ReadQuery query, DistributedSession session) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorNextObject(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    public Object scrollableCursorPreviousObject(ObjID remoteScrollableCursorOid, ReadQuery query, DistributedSession session) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorPreviousObject(new Transporter((Object)remoteScrollableCursorOid));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (query.isReadAllQuery() && !query.isReportQuery()) {
            object = session.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashMap(), (ObjectLevelReadQuery)query);
        }
        return object;
    }

    public boolean scrollableCursorRelative(ObjID remoteScrollableCursorOid, int rows) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorRelative(new Transporter((Object)remoteScrollableCursorOid), rows);
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public int scrollableCursorSize(ObjID cursorId) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorSize(new Transporter((Object)cursorId));
        }
        catch (RemoteException exception) {
            throw CommunicationException.errorInInvocation((Exception)exception);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public void setRemoteSessionController(RMIRemoteSessionController remoteSessionController) {
        this.remoteSessionController = remoteSessionController;
    }
}

