/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class UpdateAllQueryTestHelper {
    public static String execute(Session mainSession, Class referenceClass, HashMap updateClauses, Expression selectionExpression) {
        return UpdateAllQueryTestHelper.execute(mainSession, referenceClass, updateClauses, selectionExpression, true);
    }

    public static String execute(Session mainSession, Class referenceClass, HashMap updateClauses, Expression selectionExpression, boolean handleChildren) {
        return UpdateAllQueryTestHelper.execute(mainSession, UpdateAllQueryTestHelper.createUpdateAllQuery(referenceClass, updateClauses, selectionExpression), true);
    }

    public static String execute(Session mainSession, UpdateAllQuery uq) {
        return UpdateAllQueryTestHelper.execute(mainSession, uq, true);
    }

    public static String execute(Session mainSession, UpdateAllQuery uq, boolean handleChildren) {
        String errorMsg;
        Class rootClass = uq.getReferenceClass();
        ClassDescriptor descriptor = mainSession.getClassDescriptor(uq.getReferenceClass());
        if (descriptor.hasInheritance()) {
            ClassDescriptor parentDescriptor = descriptor;
            while (!parentDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
                parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
            }
            rootClass = parentDescriptor.getJavaClass();
        }
        if ((errorMsg = UpdateAllQueryTestHelper.execute(mainSession, uq, handleChildren, rootClass)).length() == 0) {
            return null;
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String execute(Session mainSession, UpdateAllQuery uq, boolean handleChildren, Class rootClass) {
        String errorMsg = "";
        ClassDescriptor descriptor = mainSession.getDescriptor(uq.getReferenceClass());
        UpdateAllQueryTestHelper.clearCache(mainSession);
        Vector objects = mainSession.readAllObjects(rootClass);
        ReportQuery rq = new ReportQuery(uq.getReferenceClass(), uq.getExpressionBuilder());
        rq.setSelectionCriteria(uq.getSelectionCriteria());
        rq.setShouldRetrievePrimaryKeys(true);
        Vector<String> fieldsWithNullValues = new Vector<String>();
        for (Map.Entry entry : uq.getUpdateClauses().entrySet()) {
            Expression valueExpression;
            String keyString = UpdateAllQueryTestHelper.getQualifiedFieldNameFromKey(entry.getKey(), rq.getReferenceClass(), descriptor, mainSession);
            Object value = entry.getValue();
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForField(new DatabaseField(keyString));
            if (mapping != null && mapping.isOneToOneMapping() && value != null) {
                if (((OneToOneMapping)mapping).getSourceToTargetKeyFields().size() > 1) {
                    errorMsg = "Attribute " + mapping.getAttributeName() + " mapped with 1to1 mapping that has more than one targetKeyField. UpdateAllQueryTestHelper currently doesn't support that.";
                }
                DatabaseField targetField = (DatabaseField)((OneToOneMapping)mapping).getSourceToTargetKeyFields().get(new DatabaseField(keyString));
                if (value instanceof Expression) {
                    valueExpression = ((Expression)((Expression)value).clone()).getField(targetField);
                } else {
                    ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
                    Object fieldValue = targetDescriptor.getObjectBuilder().extractValueFromObjectForField(value, targetField, (AbstractSession)mainSession);
                    valueExpression = rq.getExpressionBuilder().value(fieldValue);
                }
            } else {
                valueExpression = value instanceof Expression ? (Expression)value : rq.getExpressionBuilder().value(value);
            }
            if (value == null) {
                fieldsWithNullValues.add(keyString);
                continue;
            }
            rq.addAttribute(keyString, valueExpression);
        }
        UnitOfWork uow = mainSession.acquireUnitOfWork();
        AbstractSession session = uow.getParent();
        Vector result = (Vector)session.executeQuery((DatabaseQuery)rq);
        Vector<Object> objectsAfterOneByOneUpdate = new Vector<Object>(objects.size());
        session.beginTransaction();
        try {
            int i;
            for (i = 0; i < result.size(); ++i) {
                DatabaseField field;
                String name;
                int j;
                ReportQueryResult reportResult = (ReportQueryResult)result.elementAt(i);
                Object obj = reportResult.readObject(rq.getReferenceClass(), (Session)uow);
                DatabaseRecord row = new DatabaseRecord();
                for (j = 0; j < reportResult.getNames().size(); ++j) {
                    name = (String)reportResult.getNames().get(j);
                    field = new DatabaseField(name);
                    Object value = reportResult.getResults().get(j);
                    row.add(field, value);
                }
                for (j = 0; j < fieldsWithNullValues.size(); ++j) {
                    name = (String)fieldsWithNullValues.elementAt(j);
                    field = new DatabaseField(name);
                    row.add(field, null);
                }
                rq.getDescriptor().getObjectBuilder().assignReturnRow(obj, (AbstractSession)uow, (AbstractRecord)row, null);
            }
            uow.commit();
            for (i = 0; i < objects.size(); ++i) {
                Object original = objects.elementAt(i);
                Object copy = UpdateAllQueryTestHelper.buildCopy(descriptor, original, uow);
                objectsAfterOneByOneUpdate.add(copy);
            }
        }
        finally {
            session.rollbackTransaction();
        }
        UpdateAllQueryTestHelper.clearCache(mainSession);
        uow = mainSession.acquireUnitOfWork();
        session = uow.getParent();
        Vector<Object> objectsAfterUpdateAll = new Vector<Object>(objects.size());
        session.beginTransaction();
        try {
            uow.executeQuery((DatabaseQuery)uq);
            uow.commit();
            for (int i = 0; i < objects.size(); ++i) {
                Object original = objects.elementAt(i);
                Object copy = UpdateAllQueryTestHelper.buildCopy(descriptor, original, uow);
                objectsAfterUpdateAll.add(copy);
            }
        }
        finally {
            session.rollbackTransaction();
        }
        UpdateAllQueryTestHelper.clearCache(mainSession);
        String classErrorMsg = "";
        for (int i = 0; i < objects.size(); ++i) {
            Object obj = objects.elementAt(i);
            Object obj1 = objectsAfterOneByOneUpdate.elementAt(i);
            Object obj2 = objectsAfterUpdateAll.elementAt(i);
            boolean equal = rq.getDescriptor().getObjectBuilder().compareObjects(obj, obj2, session);
            if (equal) continue;
            classErrorMsg = classErrorMsg + "Difference: original = " + obj.toString() + "; afterOneByOneUpdate = " + obj1.toString() + "; afterUpdateAll = " + obj2.toString() + ";";
        }
        if (classErrorMsg.length() > 0) {
            errorMsg = errorMsg + classErrorMsg;
        }
        if (handleChildren && descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren()) {
            for (ClassDescriptor childDescriptor : descriptor.getInheritancePolicy().getChildDescriptors()) {
                Class childReferenceClass = childDescriptor.getJavaClass();
                UpdateAllQuery childUq = (UpdateAllQuery)uq.clone();
                childUq.setReferenceClass(childReferenceClass);
                childUq.setIsPrepared(false);
                errorMsg = errorMsg + UpdateAllQueryTestHelper.execute(mainSession, childUq, handleChildren, rootClass);
            }
        }
        return errorMsg;
    }

    protected static void clearCache(Session mainSession) {
        mainSession.getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public static UpdateAllQuery createUpdateAllQuery(Class referenceClass, HashMap updateClauses, Expression selectionExpression) {
        UpdateAllQuery uq = new UpdateAllQuery(referenceClass, selectionExpression);
        for (Map.Entry entry : updateClauses.entrySet()) {
            uq.addUpdate((String)entry.getKey(), entry.getValue());
        }
        return uq;
    }

    protected static Object buildCopy(ClassDescriptor descriptor, Object original, UnitOfWork uow) {
        Object copy = descriptor.getCopyPolicy().buildClone(original, (Session)uow);
        descriptor.getObjectBuilder().copyInto(original, copy, true);
        return copy;
    }

    protected static String getQualifiedFieldNameFromKey(Object key, Class referenceClass, ClassDescriptor descriptor, Session session) {
        DatabaseField field = null;
        if (key instanceof String) {
            String name = (String)key;
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(name);
            if (mapping != null) {
                field = (DatabaseField)mapping.getFields().firstElement();
            }
        } else if (key instanceof DataExpression) {
            DataExpression fieldExpression = (DataExpression)key;
            field = descriptor.getObjectBuilder().getFieldForQueryKeyName(fieldExpression.getName());
            if (field == null) {
                DataExpression fieldExpressionClone = (DataExpression)fieldExpression.clone();
                fieldExpressionClone.getBuilder().setQueryClass(referenceClass);
                fieldExpressionClone.getBuilder().setSession((AbstractSession)session);
                field = fieldExpressionClone.getField();
            }
        }
        if (field != null) {
            return field.getQualifiedName();
        }
        return null;
    }
}

