/*
 * Copyright (c) 2014, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//      Marcel Valovy - initial API and implementation
// ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
package org.eclipse.persistence.testing.jaxb.beanvalidation.special;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = CustomAnnotationValidator.class)
public @interface CustomAnnotation {

    String message() default "{org.eclipse.persistence.moxy.CustomAnnotation.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

}
