/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.tests.proxyindirection;


/*
 * E-mail implementation.
 *
 * An Implementation of the Contact interface.
 *
 * @author        Rick Barkhouse
 * @since        08/25/2000 16:36:20
 */
public class EmailImpl implements Contact {
    public int id;
    public boolean isPublic;
    public String username;
    public String domain;
    public boolean wantsHTMLMail;

    public String getDomain() {
        return this.domain;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    public void setDomain(String value) {
        this.domain = value;
    }

    @Override
    public void setID(int value) {
        this.id = value;
    }

    @Override
    public void setIsPublic(boolean value) {
        this.isPublic = value;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public void setWantsHTMLMail(boolean value) {
        this.wantsHTMLMail = value;
    }

    public String toString() {
        return "[E-mail #" + getID() + "] <" + getUsername() + "@" + getDomain() + ">";
    }

    public boolean wantsHTMLMail() {
        return this.wantsHTMLMail;
    }
}
