/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;

public class VerifyDeletedObjectsTest
extends ComplexUpdateTest {
    public Vector numbers;

    @Override
    protected void changeObject() {
        Employee employee = (Employee)this.workingCopy;
        employee.setFirstName("Bob");
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("home", "613", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("office", "416", "8224599"));
    }

    @Override
    public void setup() {
        this.originalObject = this.getSession().readObject(Employee.class);
        super.setup();
        this.numbers = (Vector)((Employee)this.distributedCopy).getPhoneNumbers().clone();
    }

    @Override
    public void verify() {
        Employee distEmp = (Employee)this.getObjectFromDistributedSession((DatabaseQuery)this.query);
        Enumeration enumtr = this.numbers.elements();
        while (enumtr.hasMoreElements()) {
            if (!distEmp.getPhoneNumbers().contains(enumtr.nextElement())) continue;
            throw new TestErrorException("Failed to delete private owned objects from distributed cache");
        }
    }
}

