/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.tests.clientserver.ClientServerSequenceDeadlockTest;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeClient;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeSeqDeadlockClient;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeSeqDeadlockClient2;
import org.eclipse.persistence.testing.tests.clientserver.FIFO;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerSequenceDeadlockTest2
extends ClientServerSequenceDeadlockTest {
    protected FIFO[] fifoInArray = new FIFO[NUM_CLIENTS];
    protected boolean[] firstHalfDone = new boolean[NUM_CLIENTS];

    public ClientServerSequenceDeadlockTest2() {
        this.numObjects = 10;
        this.setDescription("Tests concurrent writing of objects of two types for sequencing deadlock - one big transaction per thread");
    }

    @Override
    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(this.login);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.serverSession.getLogin().getDefaultSequence().setPreallocationSize(this.numObjects / 2);
        this.server.serverSession.getSequencingControl().setShouldUseSeparateConnection(true);
        this.server.login();
        this.server.copyDescriptors(this.getSession());
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            boolean createEmployeesFirst = i % 2 == 0;
            this.fifoArray[i] = new FIFO(this.numObjects);
            this.fifoInArray[i] = new FIFO(this.numObjects);
            this.getClients().addElement(new EmployeeSeqDeadlockClient2(this.server, this.getSession(), "Client " + i, this.numObjects, createEmployeesFirst, this.fifoArray[i], this.fifoInArray[i]));
            this.clientStateArray[i] = 0;
            this.clientLastActionTimeArray[i] = 0L;
            this.firstHalfDone[i] = false;
        }
        this.doneClients = 0;
        this.deadlock = false;
    }

    @Override
    public void test() {
        int i;
        for (i = 0; i < NUM_CLIENTS; ++i) {
            EmployeeSeqDeadlockClient client = (EmployeeSeqDeadlockClient)this.clients.elementAt(i);
            client.start();
            this.clientStateArray[i] = 0;
        }
        while (this.doneClients < NUM_CLIENTS) {
            for (i = 0; i < NUM_CLIENTS; ++i) {
                if (this.clientStateArray[i] != 0) continue;
                if (NUM_CLIENTS - this.doneClients == 1) {
                    ((EmployeeClient)this.getClients().elementAt(i)).pleaseStop();
                }
                long currentTime = System.currentTimeMillis();
                if (!this.fifoArray[i].isEmpty()) {
                    this.clientLastActionTimeArray[i] = currentTime;
                    int objectNumber = (Integer)this.fifoArray[i].removeHead();
                    if (objectNumber == this.numObjects / 2) {
                        int j;
                        this.firstHalfDone[i] = true;
                        boolean firstHalfDoneForAll = true;
                        for (j = 0; j < NUM_CLIENTS; ++j) {
                            firstHalfDoneForAll = firstHalfDoneForAll && this.firstHalfDone[j];
                        }
                        if (firstHalfDoneForAll) {
                            for (j = 0; j < NUM_CLIENTS; ++j) {
                                this.fifoInArray[j].insertTail(true);
                            }
                        }
                    }
                    if (objectNumber != this.numObjects && objectNumber != -1) continue;
                    this.clientStateArray[i] = 2;
                    ++this.doneClients;
                    continue;
                }
                if (this.clientLastActionTimeArray[i] == 0L) {
                    this.clientLastActionTimeArray[i] = System.currentTimeMillis();
                    continue;
                }
                if (currentTime - this.clientLastActionTimeArray[i] < 300000L) continue;
                this.clientStateArray[i] = 1;
                this.deadlock = true;
                ++this.doneClients;
                ((Thread)this.getClients().elementAt(i)).stop();
            }
        }
    }
}

