/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.ResultInterface;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;

public abstract class TestCollection
extends TestSuite
implements TestEntity {
    private String name;
    private Vector tests;
    private TestResultsSummary summary;
    private String description;
    private transient TestExecutor executor;
    private TestEntity container;
    private int nestedCounter;
    private String indentationString;
    private Vector finishedTests;
    protected boolean isSRG;

    public TestCollection() {
        this.initialize();
    }

    public TestCollection(Class theClass, String name) {
        super(theClass, name);
        this.initialize();
    }

    public TestCollection(Class theClass) {
        super(theClass);
        this.initialize();
    }

    public void initialize() {
        this.description = "";
        this.nestedCounter = -1;
        this.tests = new Vector();
        this.finishedTests = new Vector();
        this.summary = new TestResultsSummary(this);
        if (this.getName() == null || this.getName().length() == 0) {
            this.setName(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        } else {
            this.setName(this.getName());
        }
    }

    @Override
    public String getName() {
        if (super.getName() == null) {
            this.setName(this.name);
        }
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.name = name;
    }

    public final void addTest(Test test) {
        super.addTest(test);
        if (test instanceof TestEntity) {
            ((TestEntity)test).setContainer(this);
        }
        this.getTests().add(test);
    }

    public abstract void addTests();

    public void addSRGTests() {
    }

    public final void addTests(Vector theTests) {
        Enumeration allTests = theTests.elements();
        while (allTests.hasMoreElements()) {
            Test test = (Test)allTests.nextElement();
            this.addTest(test);
        }
    }

    public final void addServerTest(TestCase theTest) {
        Object[] args = new Object[1];
        try {
            Class<?> serverTestCaseClass = Class.forName("org.eclipse.persistence.testing.framework.ejb.ServerTestCase");
            args[0] = theTest;
            TestCase serverTestCase = (TestCase)serverTestCaseClass.getConstructors()[0].newInstance(args);
            serverTestCase.setName(theTest.getName());
            this.addTest(serverTestCase);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void appendTestResult(TestResultsSummary summary) {
        summary.appendTestCollectionResult(this);
    }

    @Override
    public void computeNestedLevel() {
        TestEntity testContainer = this.getContainer();
        if (testContainer != null && testContainer.getNestedCounter() != -1) {
            this.setNestedCounter(testContainer.getNestedCounter() + 1);
        } else {
            this.incrementNestedCounter();
        }
    }

    @Override
    public Session defaultLogin() {
        return new TestSystem().login();
    }

    @Override
    public TestEntity getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    protected TestExecutor getExecutor() {
        return this.executor;
    }

    public Vector getFinishedTests() {
        return this.finishedTests;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    @Override
    public int getNestedCounter() {
        return this.nestedCounter;
    }

    @Override
    public ResultInterface getReport() {
        return this.getSummary();
    }

    protected Session getSession() {
        return this.getExecutor().getSession();
    }

    public DatabaseSession getDatabaseSession() {
        return (DatabaseSession)this.getExecutor().getSession();
    }

    public AbstractSession getAbstractSession() {
        return (AbstractSession)this.getExecutor().getSession();
    }

    protected TestResultsSummary getSummary() {
        return this.summary;
    }

    public Vector getTests() {
        return this.tests;
    }

    public int countTestCases() {
        if (this.getTests().isEmpty()) {
            return 1;
        }
        return super.countTestCases();
    }

    public int testCount() {
        return this.getTests().size();
    }

    public Enumeration tests() {
        return this.getTests().elements();
    }

    public Test testAt(int index) {
        return (Test)this.getTests().elementAt(index);
    }

    @Override
    public void incrementNestedCounter() {
        this.setNestedCounter(this.getNestedCounter() + 1);
    }

    public void run(junit.framework.TestResult result) {
        TestExecutor.setDefaultJUnitTestResult(result);
        try {
            TestExecutor executor = this.getExecutor();
            if (executor == null) {
                executor = TestExecutor.getDefaultExecutor();
            }
            this.execute(executor);
        }
        catch (Throwable exception) {
            if (exception instanceof TestWarningException) {
                System.out.println("WARNING: " + exception);
            }
            result.addError((Test)this, exception);
        }
    }

    protected abstract void logFootNote(Writer var1);

    protected abstract void logRegressionHeadNote(Writer var1);

    protected abstract void logHeadNote(Writer var1);

    @Override
    public void logRegressionResult(Writer log) {
        this.logResult(log, false, true);
    }

    @Override
    public void logResult(Writer log) {
        this.logResult(log, false, false);
    }

    @Override
    public void logResult(Writer log, boolean logOnlyErrors) {
        this.logResult(log, logOnlyErrors, false);
    }

    public void logResult(Writer log, boolean logOnlyErrors, boolean regression) {
        this.computeResultSummary();
        this.setIndentationString(Helper.getTabs((int)this.getNestedCounter()));
        if (regression) {
            this.logRegressionHeadNote(log);
        } else {
            this.logHeadNote(log);
        }
        Enumeration tests = this.getFinishedTests().elements();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (test instanceof TestEntity) {
                TestEntity testEntity = (TestEntity)test;
                if (regression) {
                    if (testEntity instanceof TestCase && (testEntity.getReport().hasPassed() || ((TestResult)testEntity.getReport()).hasWarning())) continue;
                    testEntity.logRegressionResult(log);
                    continue;
                }
                if (testEntity instanceof TestCase && !testEntity.getReport().shouldLogResult() || logOnlyErrors && testEntity instanceof TestCollection && testEntity.getReport().hasPassed()) continue;
                testEntity.logResult(log, logOnlyErrors);
                continue;
            }
            TestExecutor.logJUnitResult(test, log, Helper.getTabs((int)(this.getNestedCounter() + 1)));
        }
        this.logFootNote(log);
        if (regression) {
            this.getSummary().logRegressionResult(log);
        } else {
            this.getSummary().logResult(log);
        }
    }

    public void computeResultSummary() {
        this.getSummary().resetTotals();
        Enumeration tests = this.getFinishedTests().elements();
        while (tests.hasMoreElements()) {
            TestEntity testEntity;
            Test test = (Test)tests.nextElement();
            if (test instanceof TestCase) {
                testEntity = (TestCase)test;
                ((TestCase)testEntity).appendTestResult(this.getSummary());
                continue;
            }
            if (test instanceof TestCollection) {
                testEntity = (TestCollection)test;
                ((TestCollection)testEntity).computeResultSummary();
                ((TestCollection)testEntity).appendTestResult(this.getSummary());
                continue;
            }
            junit.framework.TestResult result = (junit.framework.TestResult)TestExecutor.getJUnitTestResults().get(test);
            this.getSummary().appendTestResult(result);
        }
    }

    protected void removeTest(TestEntity test) {
        this.getTests().removeElement(test);
    }

    @Override
    public boolean requiresDatabase() {
        return true;
    }

    @Override
    public abstract void resetEntity();

    @Override
    public void resetNestedCounter() {
        this.setNestedCounter(-1);
        Enumeration tests = this.getTests().elements();
        while (tests.hasMoreElements()) {
            Object test = tests.nextElement();
            if (!(test instanceof TestEntity)) continue;
            ((TestEntity)test).resetNestedCounter();
        }
    }

    @Override
    public void setContainer(TestEntity testEntity) {
        this.container = testEntity;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutor(TestExecutor anExecutor) {
        this.executor = anExecutor;
    }

    public void setFinishedTests(Vector finishedTests) {
        this.finishedTests = finishedTests;
    }

    public void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    @Override
    public void setNestedCounter(int level) {
        this.nestedCounter = level;
    }

    protected void setSummary(TestResultsSummary theSummary) {
        this.summary = theSummary;
        theSummary.setTestCollection(this);
    }

    @Override
    public void setReport(ResultInterface summary) {
        this.setSummary((TestResultsSummary)summary);
    }

    protected final void setTests(Vector theTests) {
        this.tests = theTests;
    }

    public abstract void setupEntity() throws Throwable;

    public String toString() {
        return this.getName();
    }
}

