/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple.sequencing;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.Server;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSequencingTestSuite {
    static final String TABLE_NAME = "SIMPLE_TABLE_SEQ";
    public static final String SEQ_TABLE_NAME = "TEST_SEQ";
    static final String ENTITY_TYPE = "Simple";
    static EntityManagerFactory emf;
    static JPADynamicHelper helper;

    @Test
    public void verifyConfig() throws Exception {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)emf);
        ClassDescriptor descriptor = session.getClassDescriptorForAlias(ENTITY_TYPE);
        Assert.assertNotNull((String)"No descriptor found for alias: Simple", (Object)descriptor);
        DynamicTypeImpl simpleType = (DynamicTypeImpl)helper.getType(ENTITY_TYPE);
        Assert.assertNotNull((String)"EntityType not found for alias: Simple", (Object)simpleType);
        Assert.assertEquals((Object)descriptor, (Object)simpleType.getDescriptor());
    }

    @Test
    public void createSingleInstances() {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)emf);
        DynamicTypeImpl simpleType = (DynamicTypeImpl)helper.getType(ENTITY_TYPE);
        EntityManager em = emf.createEntityManager();
        DynamicEntity simpleInstance = this.createSimpleInstance(1);
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(o) FROM Simple o").getSingleResult()).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        IdentityMapAccessor cache = session.getIdentityMapAccessor();
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
        em.clear();
        cache.initializeAllIdentityMaps();
        DynamicEntity findResult = (DynamicEntity)em.find(simpleType.getJavaClass(), (Object)1);
        Assert.assertNotNull((Object)findResult);
        Assert.assertEquals((Object)simpleInstance.get("id"), (Object)findResult.get("id"));
        Assert.assertEquals((Object)simpleInstance.get("value1"), (Object)findResult.get("value1"));
        em.close();
    }

    @Test
    public void createTwoInstances() {
        EntityManager em = emf.createEntityManager();
        DynamicTypeImpl simpleType = (DynamicTypeImpl)helper.getType(ENTITY_TYPE);
        DynamicEntity simpleInstance1 = this.createSimpleInstance(1);
        DynamicEntity simpleInstance2 = this.createSimpleInstance(2);
        int simpleCount = ((Number)em.createQuery("SELECT COUNT(o) FROM Simple o").getSingleResult()).intValue();
        Assert.assertEquals((long)2L, (long)simpleCount);
        IdentityMapAccessor cache = helper.getSession().getIdentityMapAccessor();
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance1));
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance2));
        em.clear();
        cache.initializeAllIdentityMaps();
        DynamicEntity findResult1 = (DynamicEntity)em.find(simpleType.getJavaClass(), (Object)1);
        DynamicEntity findResult2 = (DynamicEntity)em.find(simpleType.getJavaClass(), (Object)2);
        Assert.assertNotNull((Object)findResult1);
        Assert.assertNotNull((Object)findResult2);
        Assert.assertEquals((Object)simpleInstance1.get("id"), (Object)findResult1.get("id"));
        Assert.assertEquals((Object)simpleInstance2.get("value1"), (Object)findResult2.get("value1"));
        em.close();
    }

    public DynamicEntity createSimpleInstance(int expectedId) {
        EntityManager em = emf.createEntityManager();
        DynamicType simpleEntityType = helper.getType(ENTITY_TYPE);
        Assert.assertNotNull((Object)simpleEntityType);
        DynamicEntity simpleInstance = simpleEntityType.newDynamicEntity();
        simpleInstance.set("value1", (Object)TABLE_NAME);
        em.getTransaction().begin();
        Assert.assertEquals((long)0L, (long)((Number)simpleInstance.get("id")).intValue());
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        Assert.assertEquals((long)expectedId, (long)((Number)simpleInstance.get("id")).intValue());
        em.close();
        return simpleInstance;
    }
}

