/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.simple;

import jakarta.persistence.EntityManager;
import java.util.Calendar;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.simple.SimpleTypeTestSuite;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypeCompositeKeyTestSuite
extends SimpleTypeTestSuite {
    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        helper = new JPADynamicHelper(emf);
        DynamicClassLoader dcl = helper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("model.Simple");
        JPADynamicTypeBuilder typeBuilder = new JPADynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TYPE"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID1", "SID2"});
        typeBuilder.addDirectMapping("id1", Integer.TYPE, "SID1");
        typeBuilder.addDirectMapping("id2", Integer.TYPE, "SID2");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        typeBuilder.addDirectMapping("value3", Calendar.class, "VAL_3");
        typeBuilder.addDirectMapping("value4", Character.class, "VAL_4");
        helper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
        simpleType = helper.getType("Simple");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (emf != null && emf.isOpen()) {
            EntityManager em = emf.createEntityManager();
            em.getTransaction().begin();
            em.createNativeQuery("DROP TABLE SIMPLE_TYPE").executeUpdate();
            em.getTransaction().commit();
            em.close();
            emf.close();
        }
    }

    @Override
    @Test
    public void verifyConfig() throws Exception {
        super.verifyConfig();
        Assert.assertNotNull((Object)simpleType.getDescriptor().getCMPPolicy());
        Assert.assertEquals(Object[].class, (Object)simpleType.getDescriptor().getCMPPolicy().getPKClass());
    }

    @Override
    protected void assertDefaultValues(DynamicEntity simpleInstance) {
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertEquals((String)"id1 not default value", (long)0L, (long)((Integer)simpleInstance.get("id1")).intValue());
        Assert.assertEquals((String)"id2 not default value", (long)0L, (long)((Integer)simpleInstance.get("id2")).intValue());
        Assert.assertFalse((String)"value1 set on new instance", (boolean)simpleInstance.isSet("value1"));
        Assert.assertEquals((String)"value2 not default value on new instance", (Object)false, (Object)((Boolean)simpleInstance.get("value2")));
        Assert.assertFalse((String)"value3 set on new instance", (boolean)simpleInstance.isSet("value3"));
        Assert.assertFalse((String)"value4 set on new instance", (boolean)simpleInstance.isSet("value4"));
    }

    @Override
    public DynamicEntity createSimpleInstance(int id) {
        EntityManager em = emf.createEntityManager();
        Assert.assertNotNull((Object)simpleType);
        DynamicEntity simpleInstance = simpleType.newDynamicEntity();
        simpleInstance.set("id1", (Object)id);
        simpleInstance.set("id2", (Object)id);
        simpleInstance.set("value2", (Object)true);
        Assert.assertEquals((long)0L, (long)((Number)em.createQuery("SELECT COUNT(s) FROM Simple s").getSingleResult()).intValue());
        em.getTransaction().begin();
        em.persist((Object)simpleInstance);
        em.getTransaction().commit();
        Assert.assertEquals((long)1L, (long)((Number)em.createQuery("SELECT COUNT(s) FROM Simple s").getSingleResult()).intValue());
        DynamicEntity foundEntity = this.find(em, 1);
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object)simpleInstance.get("id1"), (Object)foundEntity.get("id1"));
        Assert.assertEquals((Object)simpleInstance.get("id2"), (Object)foundEntity.get("id2"));
        Assert.assertEquals((Object[])((Object[])simpleInstance.get("value1")), (Object[])((Object[])foundEntity.get("value1")));
        Assert.assertEquals((Object)simpleInstance.get("value2"), (Object)foundEntity.get("value2"));
        em.close();
        return simpleInstance;
    }

    @Override
    protected DynamicEntity find(EntityManager em, Object id) {
        return (DynamicEntity)em.find(simpleType.getJavaClass(), (Object)new Object[]{id, id});
    }
}

