/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.multitenant;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.AdvancedMultiTenantTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Boss;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Candidate;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Capo;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Card;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Contract;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Envelope;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.MafiaFamily;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Mafioso;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Mason;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Party;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Riding;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Soldier;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.SubCapo;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.SubTask;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Supporter;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.SupporterInfo;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.SupporterInfoSub;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Task;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Trowel;
import org.eclipse.persistence.testing.models.jpa.advanced.multitenant.Underboss;

public class AdvancedMultiTenantJunitTest
extends JUnitTestCase {
    public String MULTI_TENANT_VPD_PU;
    public String MULTI_TENANT_PU;
    public String MULTI_TENANT_PU_123;
    public String MULTI_TENANT_TABLE_PER_TENANT_PU;
    public String MULTI_TENANT_TABLE_PER_TENANT_C_PU;
    public static long candidateAId;
    public static long supporter1Id;
    public static long supporter2Id;
    public static int ridingId;
    public static int partyId;
    public static int masonId;
    public static int family707;
    public static int family007;
    public static int family123;
    public static int capo123Id;
    public static int soldier123Id;
    public static List<Integer> family707Mafiosos;
    public static List<Integer> family707Contracts;
    public static List<Integer> family007Mafiosos;
    public static List<Integer> family007Contracts;
    public static List<Integer> family123Mafiosos;
    public static List<Integer> family123Contracts;

    public AdvancedMultiTenantJunitTest() {
    }

    public AdvancedMultiTenantJunitTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedMultiTenantJunitTest");
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testCreateMafiaFamily707"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testCreateMafiaFamily007"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testCreateEMF123WithoutAllTenantPropertiesSet"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testCreateMafiaFamily123"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testValidateMafiaFamily707"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testValidateMafiaFamily007"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testValidateMafiaFamily707and007WithSameEM"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testValidateMafiaFamily123"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testComplexMultitenantQueries"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testVPDEMPerTenant"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testMultitenantOneToOneReadObjectRead"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testMultitenantPrimaryKeyWithIdClass"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantA"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantAQueries"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantB"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantBQueries"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantC"));
        suite.addTest((Test)new AdvancedMultiTenantJunitTest("testTablePerTenantCQueries"));
        return suite;
    }

    public String getMULTI_TENANT_PU() {
        return "multi-tenant-shared-emf";
    }

    public String getMULTI_TENANT_PU_123() {
        return "multi-tenant-123";
    }

    public String getMULTI_TENANT_VPD_PU() {
        return "multi-tenant-vpd";
    }

    public String getMULTI_TENANT_TABLE_PER_TENANT_PU() {
        return "multi-tenant-table-per-tenant";
    }

    public String getMULTI_TENANT_TABLE_PER_TENANT_C_PU() {
        return "multi-tenant-table-per-tenant-C";
    }

    public EntityManager createSharedEMFEntityManager() {
        return AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_PU());
    }

    public EntityManager create123EntityManager() {
        return AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_PU_123());
    }

    public EntityManager createTenant123EntityManager() {
        HashMap<String, String> properties = new HashMap<String, String>();
        EntityManager em = null;
        if (!AdvancedMultiTenantJunitTest.isOnServer()) {
            properties.putAll(JUnitTestCaseHelper.getDatabaseProperties((String)this.getMULTI_TENANT_PU_123()));
            properties.put("eclipselink.tenant-id", "123");
            em = AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_PU_123(), properties);
        } else {
            em = this.create123EntityManager();
        }
        return em;
    }

    public EntityManager createVPDEntityManager() {
        return AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_VPD_PU());
    }

    public EntityManager createTableTenantEntityManager() {
        return AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_TABLE_PER_TENANT_PU());
    }

    public EntityManager createTableTenantCEntityManager() {
        return AdvancedMultiTenantJunitTest.createEntityManager((String)this.getMULTI_TENANT_TABLE_PER_TENANT_C_PU());
    }

    public void testSetup() {
        new AdvancedMultiTenantTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)this.createSharedEMFEntityManager()).getServerSession());
    }

    public void testTablePerTenantA() {
        EntityManager em = this.createTableTenantEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"A");
            Candidate candidateA = new Candidate();
            candidateA.setName("CA");
            candidateA.addHonor("Raised most money");
            candidateA.addHonor("Highest win margin");
            candidateA.setSalary(9999999);
            Supporter supporter1 = new Supporter();
            supporter1.setName("Supporter1a");
            SupporterInfo supporter1Info = new SupporterInfo();
            supporter1Info.setDescription("Supporter1aDesc");
            SupporterInfoSub supporter1InfoSub = new SupporterInfoSub();
            supporter1InfoSub.setSubDescription("Supporter1aSubDesc");
            supporter1Info.setSubInfo(supporter1InfoSub);
            supporter1.setInfo(supporter1Info);
            candidateA.addSupporter(supporter1);
            Supporter supporter2 = new Supporter();
            supporter2.setName("Supporter2a");
            SupporterInfo supporter2Info = new SupporterInfo();
            supporter2Info.setDescription("Supporter2aDesc");
            SupporterInfoSub supporter2InfoSub = new SupporterInfoSub();
            supporter2InfoSub.setSubDescription("Supporter2aSubDesc");
            supporter2Info.setSubInfo(supporter2InfoSub);
            supporter2.setInfo(supporter2Info);
            candidateA.addSupporter(supporter2);
            Supporter supporter3 = new Supporter();
            supporter3.setName("Supporter3a");
            SupporterInfo supporter3Info = new SupporterInfo();
            supporter3Info.setDescription("Supporter3aDesc");
            SupporterInfoSub supporter3InfoSub = new SupporterInfoSub();
            supporter3InfoSub.setSubDescription("Supporter3aSubDesc");
            supporter3Info.setSubInfo(supporter3InfoSub);
            supporter3.setInfo(supporter3Info);
            candidateA.addSupporter(supporter3);
            Party party = new Party();
            party.setName("Conservatives");
            party.addCandidate(candidateA);
            Riding riding = new Riding();
            riding.setName("Ottawa");
            candidateA.setRiding(riding);
            em.persist((Object)party);
            em.persist((Object)candidateA);
            em.persist((Object)supporter1);
            em.persist((Object)supporter2);
            em.persist((Object)supporter3);
            em.persist((Object)riding);
            Mason mason = new Mason();
            mason.setName("FromTenantA");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), "Best pointer");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), "Least screw-ups");
            Trowel trowel = new Trowel();
            trowel.setType("Pointing");
            mason.setTrowel(trowel);
            trowel.setMason(mason);
            em.persist((Object)mason);
            em.persist((Object)trowel);
            candidateAId = candidateA.getId();
            ridingId = riding.getId();
            partyId = party.getId();
            supporter1Id = supporter1.getId();
            supporter2Id = supporter2.getId();
            masonId = mason.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantAQueries() {
        EntityManager em = this.createTableTenantEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"A");
            List resultsFromNamedQuery = em.createNamedQuery("Supporter.findAll").getResultList();
            List resultsFromDynamicQuery = em.createQuery("SELECT s FROM Supporter s ORDER BY s.id DESC").getResultList();
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from named query.", (resultsFromNamedQuery.size() == 3 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from dynamic query.", (resultsFromDynamicQuery.size() == 3 ? 1 : 0) != 0);
            List results = em.createNamedQuery("Supporter.findBySupporterInfo").setParameter("desc", (Object)"Supporter1aDesc").getResultList();
            AdvancedMultiTenantJunitTest.assertFalse((String)"No results returned.", (results == null ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Single result not returned.", (results.size() == 1 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Didn't return supporter1a", (boolean)((Supporter)results.get(0)).getName().equals("Supporter1a"));
            results = em.createNamedQuery("Supporter.findBySupporterInfoSub").setParameter("subDesc", (Object)"Supporter3aSubDesc").getResultList();
            AdvancedMultiTenantJunitTest.assertFalse((String)"No results returned.", (results == null ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Single result not returned.", (results.size() == 1 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Didn't return supporter3a", (boolean)((Supporter)results.get(0)).getName().equals("Supporter3a"));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantB() {
        EntityManager em = this.createTableTenantEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"B");
            AdvancedMultiTenantJunitTest.assertNull((String)"CandidateA was found from tenant B.", (Object)em.find(Candidate.class, (Object)candidateAId));
            AdvancedMultiTenantJunitTest.assertNull((String)"Supporter1 was found from tenant B.", (Object)em.find(Supporter.class, (Object)supporter1Id));
            AdvancedMultiTenantJunitTest.assertNull((String)"Supporter2 was found from tenant B.", (Object)em.find(Supporter.class, (Object)supporter2Id));
            AdvancedMultiTenantJunitTest.assertNull((String)"Mason was found from tenant B.", (Object)em.find(Mason.class, (Object)masonId));
            Riding riding = (Riding)em.find(Riding.class, (Object)ridingId);
            AdvancedMultiTenantJunitTest.assertNotNull((String)"Riding was not found from tenant B", (Object)riding);
            Party party = (Party)em.find(Party.class, (Object)partyId);
            AdvancedMultiTenantJunitTest.assertNotNull((String)"Party was not found from tenant B", (Object)party);
            Candidate candidateB = new Candidate();
            candidateB.setName("CB");
            candidateB.setSalary(100);
            em.persist((Object)candidateB);
            this.commitTransaction(em);
            em.clear();
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_TABLE_PER_TENANT_PU());
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"B");
            Candidate candidateBRefreshed = (Candidate)em.find(Candidate.class, (Object)candidateB.getId());
            AdvancedMultiTenantJunitTest.assertNull((String)"Candidate B has a Party when he shouldn't have.", (Object)candidateBRefreshed.getParty());
            AdvancedMultiTenantJunitTest.assertNull((String)"Candidate B has a Riding when he shouldn't have.", (Object)candidateBRefreshed.getRiding());
            AdvancedMultiTenantJunitTest.assertTrue((String)"Candidate B had supporters when he shouldn't have.", (boolean)candidateBRefreshed.getSupporters().isEmpty());
            AdvancedMultiTenantJunitTest.assertTrue((String)"Candidate B had honors when he shouldn't have.", (boolean)candidateBRefreshed.getHonors().isEmpty());
            AdvancedMultiTenantJunitTest.assertTrue((String)"Candidate B had the incorrect salary.", (candidateBRefreshed.getSalary() == 100 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantBQueries() {
        EntityManager em = this.createTableTenantEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("eclipselink.tenant-id", (Object)"B");
            List resultsFromNamedQuery = em.createNamedQuery("Supporter.findAll").getResultList();
            List resultsFromDynamicQuery = em.createQuery("SELECT s FROM Supporter s ORDER BY s.id DESC").getResultList();
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from named query.", (boolean)resultsFromNamedQuery.isEmpty());
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from dynamic query.", (boolean)resultsFromDynamicQuery.isEmpty());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantC() {
        EntityManager em = this.createTableTenantCEntityManager();
        try {
            this.beginTransaction(em);
            Candidate candidate = new Candidate();
            candidate.setName("C");
            candidate.addHonor("Raised most money");
            candidate.addHonor("Highest win margin");
            candidate.setSalary(9999999);
            Supporter supporter1 = new Supporter();
            supporter1.setName("Supporter1c");
            candidate.addSupporter(supporter1);
            Supporter supporter2 = new Supporter();
            supporter2.setName("Supporter2c");
            candidate.addSupporter(supporter2);
            Party party = new Party();
            party.setName("Conservatives");
            party.addCandidate(candidate);
            Riding riding = new Riding();
            riding.setName("Ottawa");
            candidate.setRiding(riding);
            em.persist((Object)party);
            em.persist((Object)candidate);
            em.persist((Object)supporter2);
            em.persist((Object)supporter1);
            em.persist((Object)riding);
            Mason mason = new Mason();
            mason.setName("FromTenantC");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1)), "Best pointer");
            mason.addAward((Date)Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2010, (int)5, (int)9)), "Least screw-ups");
            Trowel trowel = new Trowel();
            trowel.setType("Pointing");
            mason.setTrowel(trowel);
            trowel.setMason(mason);
            em.persist((Object)mason);
            em.persist((Object)trowel);
            candidateAId = candidate.getId();
            ridingId = riding.getId();
            partyId = party.getId();
            supporter1Id = supporter1.getId();
            supporter2Id = supporter2.getId();
            masonId = mason.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTablePerTenantCQueries() {
        EntityManager em = this.createTableTenantCEntityManager();
        try {
            this.beginTransaction(em);
            List resultsFromNamedQuery = em.createNamedQuery("Supporter.findAll").getResultList();
            List resultsFromDynamicQuery = em.createQuery("SELECT s FROM Supporter s ORDER BY s.id DESC").getResultList();
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from named query.", (resultsFromNamedQuery.size() == 2 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertTrue((String)"Incorrect number of supporters returned from dynamic query.", (resultsFromDynamicQuery.size() == 2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testCreateMafiaFamily707() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"707");
            em.setProperty("eclipselink.tenant-id", (Object)"707");
            MafiaFamily family = new MafiaFamily();
            family.setName("Gonzo");
            family.setRevenue(Double.valueOf(1.0E7));
            family.addTag("firstTag");
            family.addTag("secondTag");
            family.addTag("thirdTag");
            Boss boss = new Boss();
            boss.setFirstName("707");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Male);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Under");
            underboss.setLastName("Boss");
            underboss.setGender(Mafioso.Gender.Male);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Giggaloo");
            capo1.setGender(Mafioso.Gender.Female);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("CrazyGlue");
            capo2.setGender(Mafioso.Gender.Male);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("Soldier");
            soldier1.setLastName("One");
            soldier1.setGender(Mafioso.Gender.Female);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Soldier");
            soldier2.setLastName("Two");
            soldier2.setGender(Mafioso.Gender.Male);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Soldier");
            soldier3.setLastName("Three");
            soldier3.setGender(Mafioso.Gender.Male);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Soldier");
            soldier4.setLastName("Four");
            soldier4.setGender(Mafioso.Gender.Male);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Soldier");
            soldier5.setLastName("Four");
            soldier5.setGender(Mafioso.Gender.Female);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 007 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire fully-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Steal some money");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier5);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            em.persist((Object)family);
            family707 = family.getId();
            family707Mafiosos.add(boss.getId());
            family707Mafiosos.add(underboss.getId());
            family707Mafiosos.add(capo1.getId());
            family707Mafiosos.add(capo2.getId());
            family707Mafiosos.add(soldier1.getId());
            family707Mafiosos.add(soldier2.getId());
            family707Mafiosos.add(soldier3.getId());
            family707Mafiosos.add(soldier4.getId());
            family707Mafiosos.add(soldier5.getId());
            family707Contracts.add(contract1.getId());
            family707Contracts.add(contract2.getId());
            family707Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testCreateMafiaFamily007() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"007");
            em.setProperty("eclipselink.tenant-id", (Object)"007");
            MafiaFamily family = new MafiaFamily();
            family.setName("Bond");
            family.setRevenue(Double.valueOf(9.8765432103E8));
            family.addTag("tag1");
            family.addTag("tag2");
            family.addTag("tag3");
            family.addTag("tag4");
            family.addTag("tag5");
            Boss boss = new Boss();
            boss.setFirstName("007");
            boss.setLastName("Boss");
            boss.setGender(Mafioso.Gender.Female);
            Underboss underboss = new Underboss();
            underboss.setFirstName("Second");
            underboss.setLastName("InCommand");
            underboss.setGender(Mafioso.Gender.Female);
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Lubey");
            capo1.setGender(Mafioso.Gender.Male);
            Capo capo2 = new Capo();
            capo2.setFirstName("Capo");
            capo2.setLastName("Greasy");
            capo2.setGender(Mafioso.Gender.Female);
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("First");
            soldier1.setLastName("Grunt");
            soldier1.setGender(Mafioso.Gender.Male);
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Second");
            soldier2.setLastName("Grunt");
            soldier2.setGender(Mafioso.Gender.Female);
            Soldier soldier3 = new Soldier();
            soldier3.setFirstName("Third");
            soldier3.setLastName("Grunt");
            soldier3.setGender(Mafioso.Gender.Female);
            Soldier soldier4 = new Soldier();
            soldier4.setFirstName("Fourth");
            soldier4.setLastName("Grunt");
            soldier4.setGender(Mafioso.Gender.Female);
            Soldier soldier5 = new Soldier();
            soldier5.setFirstName("Fifth");
            soldier5.setLastName("Grunt");
            soldier5.setGender(Mafioso.Gender.Male);
            Soldier soldier6 = new Soldier();
            soldier6.setFirstName("Sixth");
            soldier6.setLastName("Grunt");
            soldier6.setGender(Mafioso.Gender.Male);
            Soldier soldier7 = new Soldier();
            soldier7.setFirstName("Seventh");
            soldier7.setLastName("Grunt");
            soldier7.setGender(Mafioso.Gender.Male);
            Contract contract1 = new Contract();
            contract1.setDescription("Whack 707 family boss");
            Contract contract2 = new Contract();
            contract2.setDescription("Acquire semi-automatic guns");
            Contract contract3 = new Contract();
            contract3.setDescription("Set up new financing deals");
            contract1.addSoldier(soldier1);
            contract1.addSoldier(soldier5);
            contract2.addSoldier(soldier1);
            contract2.addSoldier(soldier3);
            contract2.addSoldier(soldier7);
            contract3.addSoldier(soldier2);
            contract3.addSoldier(soldier3);
            contract3.addSoldier(soldier4);
            contract3.addSoldier(soldier5);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo2.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo1.addSoldier(soldier2);
            capo2.addSoldier(soldier3);
            capo2.addSoldier(soldier4);
            capo2.addSoldier(soldier5);
            capo2.addSoldier(soldier6);
            capo2.addSoldier(soldier7);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            family.addMafioso((Mafioso)soldier3);
            family.addMafioso((Mafioso)soldier4);
            family.addMafioso((Mafioso)soldier5);
            family.addMafioso((Mafioso)soldier6);
            family.addMafioso((Mafioso)soldier7);
            em.persist((Object)family);
            family007 = family.getId();
            family007Mafiosos.add(boss.getId());
            family007Mafiosos.add(underboss.getId());
            family007Mafiosos.add(capo1.getId());
            family007Mafiosos.add(capo2.getId());
            family007Mafiosos.add(soldier1.getId());
            family007Mafiosos.add(soldier2.getId());
            family007Mafiosos.add(soldier3.getId());
            family007Mafiosos.add(soldier4.getId());
            family007Mafiosos.add(soldier5.getId());
            family007Mafiosos.add(soldier6.getId());
            family007Mafiosos.add(soldier7.getId());
            family007Contracts.add(contract1.getId());
            family007Contracts.add(contract2.getId());
            family007Contracts.add(contract3.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEMF123WithoutAllTenantPropertiesSet() {
        EntityManager em = null;
        boolean exceptionCaught = false;
        try {
            em = this.create123EntityManager();
        }
        catch (RuntimeException e) {
            exceptionCaught = true;
        }
        finally {
            if (em != null) {
                this.closeEntityManager(em);
            }
            AdvancedMultiTenantJunitTest.closeEntityManagerFactory((String)this.getMULTI_TENANT_PU_123());
        }
        AdvancedMultiTenantJunitTest.assertTrue((String)"No exception received on a non shared emf without all tenant properties provided", (boolean)exceptionCaught);
    }

    public void testCreateMafiaFamily123() {
        EntityManager em = this.createTenant123EntityManager();
        try {
            this.beginTransaction(em);
            MafiaFamily family = new MafiaFamily();
            family.setName("Galore");
            family.setRevenue(Double.valueOf(4321.03));
            family.addTag("newtag1");
            Boss boss = new Boss();
            boss.setFirstName("Kitty");
            boss.setLastName("Galore");
            boss.setGender(Mafioso.Gender.Female);
            boss.addReward("Reward 1");
            boss.addReward("Reward 2");
            boss.setAddress(new Address("1st Street", "Ottawa", "Ontario", "Canada", "B1T 2Y1"));
            Underboss underboss = new Underboss();
            underboss.setFirstName("Number2");
            underboss.setLastName("Galore");
            underboss.setGender(Mafioso.Gender.Male);
            underboss.addReward("Reward 3");
            underboss.addReward("Reward 4");
            underboss.setAddress(new Address("2nd Street", "Ottawa", "Ontario", "Canada", "B1T 2Y2"));
            Capo capo1 = new Capo();
            capo1.setFirstName("Capo");
            capo1.setLastName("Galore");
            capo1.setGender(Mafioso.Gender.Male);
            capo1.setAddress(new Address("3rd Street", "Ottawa", "Ontario", "Canada", "B1T 2Y3"));
            Capo capo2 = new Capo();
            capo2.setFirstName("Drill");
            capo2.setLastName("Bit");
            capo2.setGender(Mafioso.Gender.Male);
            capo2.setAddress(new Address("4th Street", "Ottawa", "Ontario", "Canada", "B1T 2Y4"));
            Soldier soldier1 = new Soldier();
            soldier1.setFirstName("Grunt");
            soldier1.setLastName("Galore");
            soldier1.setGender(Mafioso.Gender.Male);
            soldier1.addReward("Reward 5");
            soldier1.addReward("Reward 6");
            soldier1.addReward("Reward 7");
            soldier1.addReward("Reward 8");
            soldier1.setAddress(new Address("5th Street", "Ottawa", "Ontario", "Canada", "B1T 2Y5"));
            Soldier soldier2 = new Soldier();
            soldier2.setFirstName("Hammer");
            soldier2.setLastName("Head");
            soldier2.setGender(Mafioso.Gender.Male);
            soldier2.addReward("Reward 9");
            soldier2.addReward("Reward 10");
            soldier2.setAddress(new Address("6th Street", "Ottawa", "Ontario", "Canada", "B1T 2Y6"));
            Contract contract1 = new Contract();
            contract1.setDescription("Whack all other family bosses");
            Contract contract2 = new Contract();
            contract2.setDescription("Pillage, pillage, pillage!");
            contract1.addSoldier(soldier1);
            contract2.addSoldier(soldier1);
            boss.setUnderboss(underboss);
            capo1.setUnderboss(underboss);
            capo1.addSoldier(soldier1);
            capo2.addSoldier(soldier2);
            underboss.addCapo(capo1);
            underboss.addCapo(capo2);
            family.addMafioso((Mafioso)boss);
            family.addMafioso((Mafioso)underboss);
            family.addMafioso((Mafioso)capo1);
            family.addMafioso((Mafioso)capo2);
            family.addMafioso((Mafioso)soldier1);
            family.addMafioso((Mafioso)soldier2);
            em.persist((Object)family);
            capo123Id = capo1.getId();
            soldier123Id = soldier1.getId();
            family123 = family.getId();
            family123Mafiosos.add(boss.getId());
            family123Mafiosos.add(underboss.getId());
            family123Mafiosos.add(capo1.getId());
            family123Mafiosos.add(soldier1.getId());
            family123Contracts.add(contract1.getId());
            family123Contracts.add(contract2.getId());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily707() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.validateMafiaFamily707(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily007() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.validateMafiaFamily007(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily707and007WithSameEM() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.validateMafiaFamily707(em);
            this.validateMafiaFamily007(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testValidateMafiaFamily123() {
        EntityManager em = this.createTenant123EntityManager();
        try {
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU_123());
            em.clear();
            MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family123);
            AdvancedMultiTenantJunitTest.assertNotNull((String)("The Mafia Family with id: " + family123 + ", was not found"), (Object)family);
            AdvancedMultiTenantJunitTest.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [1]"), (family.getTags().size() == 1 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family707 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family707));
            AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family007 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family007));
            AdvancedMultiTenantJunitTest.assertFalse((String)"No mafiosos part of 123 family", (boolean)family.getMafiosos().isEmpty());
            for (Integer id : family707Mafiosos) {
                AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 mafioso.", (Object)em.find(Mafioso.class, (Object)id));
            }
            boolean exceptionCaught = false;
            List mafiaFamilies = null;
            try {
                mafiaFamilies = em.createNativeQuery("select * from JPA_MAFIA_FAMILY").getResultList();
            }
            catch (Exception e) {
                exceptionCaught = true;
            }
            AdvancedMultiTenantJunitTest.assertTrue((String)"No exception was caught from issuing a native query.", (boolean)exceptionCaught);
            exceptionCaught = false;
            try {
                mafiaFamilies = em.createNamedQuery("findSQLMafiaFamilies").getResultList();
            }
            catch (Exception e) {
                exceptionCaught = true;
            }
            AdvancedMultiTenantJunitTest.assertTrue((String)"No exception was caught from issuing a named native query.", (boolean)exceptionCaught);
            Boss otherBoss = (Boss)em.find(Boss.class, (Object)family707Mafiosos.get(0));
            AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 boss.", (Object)otherBoss);
            for (Integer id : family707Contracts) {
                AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 contract. ", (Object)em.find(Contract.class, (Object)id));
            }
            List families = em.createNamedQuery("findAllMafiaFamilies").getResultList();
            AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of families were returned [" + families.size() + "], expected [1]"), (families.size() == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected void validateMafiaFamily007(EntityManager em) {
        AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU());
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"007");
        em.setProperty("eclipselink.tenant-id", (Object)"007");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family007);
        AdvancedMultiTenantJunitTest.assertNotNull((String)("The Mafia Family with id: " + family007 + ", was not found"), (Object)family);
        AdvancedMultiTenantJunitTest.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [5]"), (family.getTags().size() == 5 ? 1 : 0) != 0);
        AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family707 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family707));
        AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family123 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family123));
        AdvancedMultiTenantJunitTest.assertFalse((String)"No mafiosos part of 007 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer n : family707Mafiosos) {
            AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 mafioso.", (Object)em.find(Mafioso.class, (Object)n));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family707Mafiosos.get(0));
        AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 boss.", (Object)otherBoss);
        for (Integer n : family707Contracts) {
            AdvancedMultiTenantJunitTest.assertNull((String)"Found family 707 contract.", (Object)em.find(Contract.class, (Object)n));
        }
        List list = em.createNamedQuery("FindAllContracts").getResultList();
        AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of contracts were returned [" + list.size() + "], expected[3]"), (list.size() == 3 ? 1 : 0) != 0);
        for (Contract contract : list) {
            AdvancedMultiTenantJunitTest.assertFalse((String)"Contract description was voided.", (boolean)contract.getDescription().equals("voided"));
        }
        List list2 = em.createNamedQuery("findAllMafiaFamilies").getResultList();
        AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of families were returned [" + list2.size() + "], expected [1]"), (list2.size() == 1 ? 1 : 0) != 0);
        Boss boss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        AdvancedMultiTenantJunitTest.assertFalse((String)"The Boss name has been compromised", (boolean)boss.getFirstName().equals("Compromised"));
        this.commitTransaction(em);
    }

    protected void validateMafiaFamily707(EntityManager em) {
        AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU());
        em.clear();
        this.beginTransaction(em);
        em.setProperty("tenant.id", (Object)"707");
        em.setProperty("eclipselink.tenant-id", (Object)"707");
        MafiaFamily family = (MafiaFamily)em.find(MafiaFamily.class, (Object)family707);
        AdvancedMultiTenantJunitTest.assertNotNull((String)("The Mafia Family with id: " + family707 + ", was not found"), (Object)family);
        AdvancedMultiTenantJunitTest.assertTrue((String)("The Mafia Family had an incorrect number of tags [" + family.getTags().size() + "], expected [3]"), (family.getTags().size() == 3 ? 1 : 0) != 0);
        AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family007 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family007));
        AdvancedMultiTenantJunitTest.assertNull((String)("The Mafia Family with id: " + family123 + ", was found (when it should not have been)"), (Object)em.find(MafiaFamily.class, (Object)family123));
        AdvancedMultiTenantJunitTest.assertFalse((String)"No mafiosos part of 707 family", (boolean)family.getMafiosos().isEmpty());
        for (Integer n : family007Mafiosos) {
            AdvancedMultiTenantJunitTest.assertNull((String)"Found family 007 mafioso.", (Object)em.find(Mafioso.class, (Object)n));
        }
        Boss otherBoss = (Boss)em.find(Boss.class, (Object)family007Mafiosos.get(0));
        AdvancedMultiTenantJunitTest.assertNull((String)"Found family 007 boss.", (Object)otherBoss);
        for (Integer id : family007Contracts) {
            AdvancedMultiTenantJunitTest.assertNull((String)"Found family 007 contract.", (Object)em.find(Contract.class, (Object)id));
        }
        Query query = em.createNamedQuery("DeleteContractByPrimaryKey");
        query.setParameter("id", (Object)family007Contracts.get(0));
        int result = query.executeUpdate();
        AdvancedMultiTenantJunitTest.assertTrue((String)"Was able to delete a contract from the 007 family", (result == 0 ? 1 : 0) != 0);
        Query updateAllQuery = em.createNamedQuery("UpdateAllContractDescriptions");
        updateAllQuery.executeUpdate();
        AdvancedMultiTenantJunitTest.assertTrue((String)"Tenant discriminator column not found in update all query", (boolean)((EJBQueryImpl)updateAllQuery).getDatabaseQuery().getCall().getSQLString().contains("TENANT_ID"));
        List contracts = em.createNamedQuery("FindAllContracts").getResultList();
        int contractNumber = contracts.size();
        AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of contracts were returned [" + contracts.size() + "], expected [3]"), (contracts.size() == 3 ? 1 : 0) != 0);
        for (Contract contract : contracts) {
            AdvancedMultiTenantJunitTest.assertTrue((String)"Contract description was not voided.", (boolean)contract.getDescription().equals("voided"));
        }
        List soldiers = em.createQuery("SELECT s from Soldier s").getResultList();
        AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of soldiers were returned [" + soldiers.size() + "], expected [5]"), (soldiers.size() == 5 ? 1 : 0) != 0);
        if (AdvancedMultiTenantJunitTest.getServerSession((String)this.getMULTI_TENANT_PU()).getPlatform().isSymfoware()) {
            AdvancedMultiTenantJunitTest.getServerSession((String)this.getMULTI_TENANT_PU()).logMessage("Test AdvancedMultiTenantJunitTest partially skipped for this platform, which uses UpdateAll internally to check tenant-id when updating an entity using JOINED inheritance strategy. Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            this.commitTransaction(em);
            return;
        }
        Query query2 = em.createNamedQuery("UpdateBossName");
        query2.setParameter("name", (Object)"Compromised");
        query2.setParameter("id", (Object)family007Mafiosos.get(0));
        query2.executeUpdate();
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexMultitenantQueries() {
        EntityManager em = this.createTenant123EntityManager();
        try {
            TypedQuery query;
            Query q;
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU_123());
            em.clear();
            try {
                q = em.createQuery("SELECT s FROM Soldier s WHERE s.capo=?1");
                SubCapo subCapo = new SubCapo();
                subCapo.setId(capo123Id);
                q.setParameter(1, (Object)subCapo);
                List soldiers = q.getResultList();
                AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of soldiers returned [" + soldiers.size() + "], expected [1]"), (soldiers.size() == 1 ? 1 : 0) != 0);
                AdvancedMultiTenantJunitTest.assertTrue((String)"Mafioso returned was not a soldier", (boolean)((Soldier)soldiers.get(0)).isSoldier());
                AdvancedMultiTenantJunitTest.assertTrue((String)"Soldier returned was not the expected soldier", (((Soldier)soldiers.get(0)).getId() == soldier123Id ? 1 : 0) != 0);
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on named parameter query (with tenant discriminator columns) : " + e));
            }
            try {
                q = em.createQuery("SELECT m FROM MafiaFamily m ORDER BY m.id DESC", MafiaFamily.class);
                q.setHint("eclipselink.join-fetch", (Object)"m.mafiosos");
                q.getResultList();
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on join fetch query (with tenant discriminator columns): " + e));
            }
            try {
                q = em.createQuery("SELECT f FROM MafiaFamily f ORDER BY f.id ASC", MafiaFamily.class);
                q.setHint("eclipselink.join-fetch", (Object)"f.mafiosos.rewards");
                q.getResultList();
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on nested join fetch query (with tenant discriminator columns): " + e));
            }
            try {
                query = em.createQuery("SELECT f FROM MafiaFamily f", MafiaFamily.class);
                query.setHint("eclipselink.batch", (Object)"f.mafiosos");
                List families = query.getResultList();
                AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of families returned [" + families.size() + "], expected [1]"), (families.size() == 1 ? 1 : 0) != 0);
                int size = ((MafiaFamily)families.get(0)).getMafiosos().size();
                AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of mafiosos returned [" + size + "], expected [6]"), (size == 6 ? 1 : 0) != 0);
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on batch fetch query (with tenant discriminator columns): " + e));
            }
            try {
                query = em.createQuery("SELECT m.address, m.family FROM Mafioso m WHERE m.address.city = 'Ottawa' AND m.family.name LIKE 'Galore'", MafiaFamily.class);
                List results = query.getResultList();
                int size = results.size();
                AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of results returned [" + size + "], expected [6]"), (size == 6 ? 1 : 0) != 0);
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on mulitple select statement (with tenant discriminator columns): " + e));
            }
            try {
                this.beginTransaction(em);
                int contracts = em.createNamedQuery("FindAllContracts").getResultList().size();
                int deletes = em.createNamedQuery("DeleteAllContracts").executeUpdate();
                AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of contracts deleted [" + deletes + "], expected [" + contracts + "]"), (deletes == 2 ? 1 : 0) != 0);
                this.commitTransaction(em);
            }
            catch (Exception e) {
                AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on delete all query with single table (with tenant discriminator columns): " + e));
            }
            if (AdvancedMultiTenantJunitTest.getServerSession((String)this.getMULTI_TENANT_PU_123()).getPlatform().isSymfoware()) {
                AdvancedMultiTenantJunitTest.getServerSession((String)this.getMULTI_TENANT_PU_123()).logMessage("Test AdvancedMultiTenantJunitTest partially skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            } else {
                try {
                    this.beginTransaction(em);
                    List allFamilies = em.createNamedQuery("findAllMafiaFamilies").getResultList();
                    int families = allFamilies.size();
                    AdvancedMultiTenantJunitTest.assertTrue((String)("More than one family was found [" + families + "]"), (families == 1 ? 1 : 0) != 0);
                    Query deleteQuery = em.createNamedQuery("DeleteAllMafiaFamilies");
                    deleteQuery.setHint("eclipselink.jdbc.allow-native-sql-query", (Object)true);
                    int deletes = deleteQuery.executeUpdate();
                    AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of families deleted [" + deletes + "], expected [" + families + "]"), (deletes == 1 ? 1 : 0) != 0);
                    this.commitTransaction(em);
                }
                catch (Exception e) {
                    AdvancedMultiTenantJunitTest.fail((String)("Exception encountered on delete all query with multiple table (with tenant discriminator columns): " + e));
                }
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        EntityManager em007 = this.createSharedEMFEntityManager();
        try {
            List families = em007.createNativeQuery("select * from JPA_MAFIA_FAMILY", MafiaFamily.class).getResultList();
            AdvancedMultiTenantJunitTest.assertTrue((String)("Incorrect number of families found through SQL [" + families.size() + "], expected [2]"), (families.size() == 2 ? 1 : 0) != 0);
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU());
            em007.clear();
            this.beginTransaction(em007);
            em007.setProperty("tenant.id", (Object)"007");
            em007.setProperty("eclipselink.tenant-id", (Object)"007");
            MafiaFamily family = (MafiaFamily)em007.find(MafiaFamily.class, (Object)family007);
            AdvancedMultiTenantJunitTest.assertFalse((String)"Family 007 tags were nuked in delete all query above!", (boolean)family.getTags().isEmpty());
            AdvancedMultiTenantJunitTest.assertFalse((String)"Family 007 revenue was nuked in delete all query above!", (family.getRevenue() == null ? 1 : 0) != 0);
            this.commitTransaction(em007);
        }
        catch (Exception e) {
            AdvancedMultiTenantJunitTest.fail((String)("Exception caught: " + e));
        }
        finally {
            if (this.isTransactionActive(em007)) {
                this.rollbackTransaction(em007);
            }
            this.closeEntityManager(em007);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVPDEMPerTenant() {
        EntityManager em2;
        block11: {
            EntityManager em1 = null;
            em2 = null;
            try {
                em1 = this.createVPDEntityManager();
                em1.setProperty("tenant.id", (Object)"bsmith@here.com");
                em2 = this.createVPDEntityManager();
                em2.setProperty("tenant.id", (Object)"gdune@there.ca");
                this.testInsertTask(em1, "blah", false);
                this.testInsertTask(em2, "halb", false);
                AdvancedMultiTenantJunitTest.assertTrue((String)"Found more than one result", (em1.createQuery("Select t from Task t").getResultList().size() == 1 ? 1 : 0) != 0);
                AdvancedMultiTenantJunitTest.assertTrue((String)"Found more than one result", (em2.createQuery("Select t from Task t").getResultList().size() == 1 ? 1 : 0) != 0);
                Task task1 = this.testInsertTaskWithOneSubtask(em1, "Rock that Propsal", false, "Write Proposal", false);
                AdvancedMultiTenantJunitTest.assertNotNull((Object)em1.find(Task.class, (Object)task1.getId()));
                AdvancedMultiTenantJunitTest.assertNull((Object)em2.find(Task.class, (Object)task1.getId()));
                Task task3 = this.testInsertTask(em2, "mow lawn", true);
                AdvancedMultiTenantJunitTest.assertNull((Object)em1.find(Task.class, (Object)task3.getId()));
                AdvancedMultiTenantJunitTest.assertNotNull((Object)em2.find(Task.class, (Object)task3.getId()));
                SubTask task4 = this.testInsertSubTaskObject(em1, "SubTask Object Creation", true);
                AdvancedMultiTenantJunitTest.assertNotNull((Object)em1.find(SubTask.class, (Object)task4.getId()));
                AdvancedMultiTenantJunitTest.assertNull((Object)em2.find(SubTask.class, (Object)task4.getId()));
                if (em1 == null) break block11;
            }
            catch (RuntimeException e) {
                block12: {
                    try {
                        if (em1 != null && this.isTransactionActive(em1)) {
                            this.rollbackTransaction(em1);
                        }
                        if (em2 != null && this.isTransactionActive(em2)) {
                            this.rollbackTransaction(em2);
                        }
                        if (AdvancedMultiTenantJunitTest.getPlatform((String)this.getMULTI_TENANT_VPD_PU()).isOracle()) {
                            throw e;
                        }
                        AdvancedMultiTenantJunitTest.warning((String)"VPD tests currently run only on an Oracle platform");
                        if (em1 == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (em1 != null) {
                            this.closeEntityManager(em1);
                        }
                        if (em2 != null) {
                            this.closeEntityManager(em2);
                        }
                        throw throwable;
                    }
                    this.closeEntityManager(em1);
                }
                if (em2 != null) {
                    this.closeEntityManager(em2);
                }
            }
            this.closeEntityManager(em1);
        }
        if (em2 != null) {
            this.closeEntityManager(em2);
        }
    }

    public void testMultitenantPrimaryKeyWithIdClass() {
        EntityManager em = this.createSharedEMFEntityManager();
        PhoneNumber number = new PhoneNumber();
        number.setAreaCode("613");
        number.setNumber("123-4567");
        number.setType("Home");
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"707");
            em.persist((Object)number);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"707");
            PhoneNumber refreshedNumber = (PhoneNumber)em.find(PhoneNumber.class, (Object)number.buildPK());
            this.rollbackTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testMultitenantOneToOneReadObjectRead() {
        EntityManager em = this.createSharedEMFEntityManager();
        try {
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"371453");
            Envelope envelope = new Envelope();
            envelope.setColor("Red");
            Card card = new Card();
            card.setPrice(Double.valueOf(2.99));
            card.setColor("Yellow");
            card.setPrintYear(2012);
            card.setOccasion("Sympathy");
            card.setFrontCaption("Get well soon");
            card.setInsideCaption("Here's to a speedy recovery");
            card.setEnvelope(envelope);
            envelope.setCard(card);
            em.persist((Object)card);
            this.commitTransaction(em);
            em.clear();
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU());
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"371453");
            envelope = (Envelope)em.merge((Object)envelope);
            this.commitTransaction(em);
            em.clear();
            AdvancedMultiTenantJunitTest.clearCache((String)this.getMULTI_TENANT_PU());
            this.beginTransaction(em);
            em.setProperty("tenant.id", (Object)"371453");
            card = (Card)em.merge((Object)card);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    private Task testInsertTask(EntityManager em, String description, boolean isCompleted) {
        this.beginTransaction(em);
        Task task = new Task();
        task.setDescription(description);
        task.setCompleted(isCompleted);
        em.persist((Object)task);
        this.commitTransaction(em);
        return task;
    }

    private Task testInsertTaskWithOneSubtask(EntityManager em, String description, boolean isCompleted, String subtaskDesc, boolean isSubtaskCompleted) {
        this.beginTransaction(em);
        Task task = new Task();
        Task subtask = new Task();
        task.setDescription(description);
        task.setCompleted(isCompleted);
        subtask.setDescription(subtaskDesc);
        subtask.setCompleted(isSubtaskCompleted);
        task.addSubtask(subtask);
        em.persist((Object)subtask);
        em.persist((Object)task);
        this.commitTransaction(em);
        return task;
    }

    private SubTask testInsertSubTaskObject(EntityManager em, String description, boolean isCompleted) {
        this.beginTransaction(em);
        SubTask subTask = new SubTask();
        subTask.setDescription(description);
        subTask.setCompleted(isCompleted);
        em.persist((Object)subTask);
        this.commitTransaction(em);
        return subTask;
    }

    static {
        family707Mafiosos = new ArrayList<Integer>();
        family707Contracts = new ArrayList<Integer>();
        family007Mafiosos = new ArrayList<Integer>();
        family007Contracts = new ArrayList<Integer>();
        family123Mafiosos = new ArrayList<Integer>();
        family123Contracts = new ArrayList<Integer>();
    }
}

