/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ExceptionSerializationTestCase
extends AutoVerifyTestCase {
    protected ConversionException conversionException = null;

    public ExceptionSerializationTestCase() {
        this.setDescription("Ensure ConversionException and CacheSynchronizationException serialize correctly.");
    }

    public void setup() {
        this.conversionException = ConversionException.couldNotBeConverted((Object)new Object(), String.class);
        Exception exception = new Exception();
        Vector errors = new Vector();
        errors.addElement(errors);
        UnitOfWorkChangeSet changeSet = new UnitOfWorkChangeSet();
    }

    public void test() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject((Object)this.conversionException);
            objectOut.flush();
        }
        catch (IOException exception) {
            throw new TestErrorException("Exception while serializing exceptions: " + exception.toString(), (Throwable)exception);
        }
        byte[] data = byteOut.toByteArray();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        try {
            ObjectInputStream objectIn = new ObjectInputStream(byteIn);
            this.conversionException = (ConversionException)((Object)objectIn.readObject());
        }
        catch (Exception exception) {
            throw new TestErrorException("Exception while serializing exceptions: " + exception.toString(), (Throwable)exception);
        }
    }

    public void verify() {
        if (this.conversionException.getSourceObject() != null) {
            throw new TestErrorException("Source Object was sent by serialization and it should not be.");
        }
    }
}

