/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.orderedlist;

import java.util.List;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.orderedlist.EmployeeProject;
import org.eclipse.persistence.testing.models.orderedlist.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.orderedlist.NullsLastOrderedListContainerPolicy;

public class EmployeeSystem
extends TestSystem {
    boolean useListOrderField;
    boolean useIndirection;
    boolean isPrivatelyOwned;
    boolean useSecondaryTable;
    boolean useVarcharOrder;
    ChangeTracking changeTracking;
    OrderCorrectionType orderCorrectionType;
    boolean shouldOverrideContainerPolicy;
    JoinFetchOrBatchRead joinFetchOrBatchRead;

    public EmployeeSystem(boolean useListOrderField, boolean useIndirection, boolean isPrivatelyOwned, boolean useSecondaryTable, boolean useVarcharOrder, ChangeTracking changeTracking, OrderCorrectionType orderCorrectionType, boolean shouldOverrideContainerPolicy, JoinFetchOrBatchRead joinFetchOrBatchRead) {
        this.useListOrderField = useListOrderField;
        this.useIndirection = useIndirection;
        this.isPrivatelyOwned = isPrivatelyOwned;
        this.useSecondaryTable = useSecondaryTable;
        this.useVarcharOrder = useVarcharOrder;
        this.changeTracking = changeTracking;
        this.orderCorrectionType = orderCorrectionType;
        this.shouldOverrideContainerPolicy = shouldOverrideContainerPolicy;
        this.joinFetchOrBatchRead = joinFetchOrBatchRead;
        this.project = new EmployeeProject(useListOrderField, useIndirection, isPrivatelyOwned, useSecondaryTable, useVarcharOrder, changeTracking, orderCorrectionType, shouldOverrideContainerPolicy, joinFetchOrBatchRead);
    }

    public void createTables(DatabaseSession session) {
        new EmployeeTableCreator().replaceTables(session);
    }

    public void addDescriptors(DatabaseSession session) {
        if (this.shouldOverrideContainerPolicy) {
            List<CollectionMapping> listOrderMappings = ((EmployeeProject)this.project).getListOrderMappings();
            for (int i = 0; i < listOrderMappings.size(); ++i) {
                CollectionMapping mapping = listOrderMappings.get(i);
                mapping.setContainerPolicy((ContainerPolicy)new NullsLastOrderedListContainerPolicy(mapping.getContainerPolicy().getContainerClass()));
            }
        }
        session.addDescriptors(this.project);
    }

    public static List<CollectionMapping> getListOrderMappings(DatabaseSession session) {
        return EmployeeProject.getListOrderMappings(session);
    }

    public static enum JoinFetchOrBatchRead {
        NONE,
        INNER_JOIN,
        OUTER_JOIN,
        BATCH_FETCH,
        BATCH_IN_FETCH,
        BATCH_EXISTS_FETCH;


        public String toString() {
            if (this == NONE) {
                return "";
            }
            return super.toString();
        }
    }

    public static enum ChangeTracking {
        DEFERRED,
        ATTRIBUTE;

    }
}

