/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.concurrent;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.eclipse.persistence.testing.framework.ConcurrentPerformanceComparisonTest;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;

public class JPAUpdateEmployeeConcurrencyComparisonTest
extends ConcurrentPerformanceComparisonTest {
    protected List<Employee> employees;
    protected String lastName;
    protected int index;
    protected long count;
    protected int errors;

    public JPAUpdateEmployeeConcurrencyComparisonTest() {
        this.setDescription("This test compares the concurrency of update Employee.");
    }

    public synchronized int incrementIndex() {
        ++this.index;
        if (this.index >= this.employees.size()) {
            this.index = 0;
        }
        return this.index;
    }

    public void setup() {
        super.setup();
        EntityManager manager = this.createEntityManager();
        this.employees = manager.createQuery("Select e from Employee e").getResultList();
        this.lastName = this.employees.get(0).getLastName();
        manager.close();
        this.index = 0;
        this.count = 0L;
    }

    public void runTask() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee employee = (Employee)manager.find(Employee.class, (Object)this.employees.get(this.incrementIndex()).getId());
        ++this.count;
        employee.setLastName(this.lastName + this.count);
        try {
            manager.getTransaction().commit();
        }
        catch (Exception exception) {
            ++this.errors;
            System.out.println("" + this.errors + ":" + exception);
        }
        manager.close();
    }
}

