/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ConstructorResult
extends SQLResult {
    protected String targetClassName;
    protected transient Class targetClass;
    protected List<ColumnResult> columnResults = new ArrayList<ColumnResult>();
    protected transient Constructor constructor;
    protected Class[] constructorArgTypes;

    protected ConstructorResult() {
    }

    public ConstructorResult(Class targetClass) {
        this();
        if (targetClass == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_constructor_result"));
        }
        this.targetClass = targetClass;
        this.targetClassName = targetClass.getName();
    }

    public ConstructorResult(String targetClassName) {
        this();
        if (targetClassName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_constructor_result"));
        }
        this.targetClassName = targetClassName;
    }

    public void addColumnResult(ColumnResult columnResult) {
        this.columnResults.add(columnResult);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block7: {
            super.convertClassNamesToClasses(classLoader);
            for (ColumnResult columnResult : this.columnResults) {
                columnResult.convertClassNamesToClasses(classLoader);
            }
            if (this.targetClass == null && this.targetClassName != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            this.targetClass = AccessController.doPrivileged(new PrivilegedClassForName(this.targetClassName, true, classLoader));
                            break block7;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.targetClassName, exception.getException());
                        }
                    }
                    this.targetClass = PrivilegedAccessHelper.getClassForName(this.targetClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.targetClassName, exc);
                }
            }
        }
    }

    public List<ColumnResult> getColumnResults() {
        return this.columnResults;
    }

    @Override
    public Object getValueFromRecord(DatabaseRecord record, ResultSetMappingQuery query) {
        if (this.constructor == null) {
            this.initialize(record, query);
        }
        int columnResultsSize = this.getColumnResults().size();
        Object[] constructorArgs = new Object[columnResultsSize];
        for (int i = 0; i < columnResultsSize; ++i) {
            constructorArgs[i] = ConversionManager.getDefaultManager().convertObject(record.get(this.getColumnResults().get(i).getColumn()), this.constructorArgTypes[i]);
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.constructor, constructorArgs));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.exceptionWhileInitializingConstructor(exception.getException(), query, this.targetClass);
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.constructor, constructorArgs);
        }
        catch (IllegalAccessException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
        catch (InvocationTargetException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
        catch (InstantiationException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
    }

    protected void initialize(DatabaseRecord record, ResultSetMappingQuery query) {
        block8: {
            int columnResultsSize = this.getColumnResults().size();
            this.constructorArgTypes = new Class[columnResultsSize];
            for (int i = 0; i < columnResultsSize; ++i) {
                ColumnResult result = this.getColumnResults().get(i);
                DatabaseField resultField = result.getColumn();
                if (resultField.getType() == null) {
                    Object recordResultField = record.get(resultField);
                    if (recordResultField == null) {
                        throw QueryException.columnResultNotFound(resultField);
                    }
                    this.constructorArgTypes[i] = recordResultField.getClass();
                    continue;
                }
                this.constructorArgTypes[i] = resultField.getType();
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.constructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.targetClass, this.constructorArgTypes, true));
                        break block8;
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.exceptionWhileInitializingConstructor(exception.getException(), query, this.targetClass);
                    }
                }
                this.constructor = PrivilegedAccessHelper.getConstructorFor(this.targetClass, this.constructorArgTypes, true);
            }
            catch (NoSuchMethodException exception) {
                throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
            }
        }
    }

    @Override
    public boolean isConstructorResult() {
        return true;
    }

    public void setColumnResults(List<ColumnResult> columnResults) {
        this.columnResults = columnResults;
    }
}

