/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import com.sleepycat.je.BinaryEqualityComparator;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.UtfOps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.kv.FaultException;

public class Key
implements Comparable<Key> {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private static final int BINARY_COMP_DELIM = 0;
    private static final int BINARY_PATH_DELIM = 255;
    private static final int BINARY_NULL_DELIM = 1;
    static final String STRING_COMP_DELIM = "/";
    private static final String STRING_PATH_DELIM = "/-/";
    private static final String STRING_NULL_DELIM = null;
    private static final int STRING_DELIM_START = 47;
    private static final String STRING_PATH_DELIM_CHAR = "-";
    private static final String STRING_PATH_DELIM_ENCODED = "%2D";
    private static final String ZERO_ENCODED = "%00";
    private static final String SLASH_ENCODED = "%2F";
    private static final int MAX_KEY_LENGTH = Short.MAX_VALUE;
    private final List<String> majorPath;
    private final List<String> minorPath;

    public static Key createKey(List<String> majorPath, List<String> minorPath) {
        return new Key(Collections.unmodifiableList(majorPath), Collections.unmodifiableList(minorPath));
    }

    public static Key createKey(String majorComponent, List<String> minorPath) {
        return new Key(Collections.singletonList(majorComponent), Collections.unmodifiableList(minorPath));
    }

    public static Key createKey(List<String> majorPath, String minorComponent) {
        return new Key(Collections.unmodifiableList(majorPath), Collections.singletonList(minorComponent));
    }

    public static Key createKey(String majorComponent, String minorComponent) {
        return new Key(Collections.singletonList(majorComponent), Collections.singletonList(minorComponent));
    }

    public static Key createKey(List<String> majorPath) {
        return new Key(Collections.unmodifiableList(majorPath), EMPTY_LIST);
    }

    public static Key createKey(String majorComponent) {
        return new Key(Collections.singletonList(majorComponent), EMPTY_LIST);
    }

    private Key(List<String> majorPath, List<String> minorPath) {
        if (majorPath == null || minorPath == null) {
            throw new IllegalArgumentException("Major and minor path must not be null.");
        }
        if (majorPath.size() == 0) {
            throw new IllegalArgumentException("Major path must contain at least one component.");
        }
        for (String s : majorPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Major path component must not be null.");
        }
        for (String s : minorPath) {
            if (s != null) continue;
            throw new IllegalArgumentException("Minor path component must not be null.");
        }
        this.majorPath = majorPath;
        this.minorPath = minorPath;
    }

    public List<String> getFullPath() {
        ArrayList<String> fullPath = new ArrayList<String>(this.majorPath.size() + this.minorPath.size());
        fullPath.addAll(this.majorPath);
        fullPath.addAll(this.minorPath);
        return fullPath;
    }

    public List<String> getMajorPath() {
        return this.majorPath;
    }

    public List<String> getMinorPath() {
        return this.minorPath;
    }

    public boolean isPrefix(Key otherKey) {
        if (this.minorPath.size() == 0) {
            int majorSize = Math.min(this.majorPath.size(), otherKey.majorPath.size());
            return this.majorPath.equals(otherKey.majorPath.subList(0, majorSize));
        }
        if (!this.majorPath.equals(otherKey.majorPath)) {
            return false;
        }
        int minorSize = Math.min(this.minorPath.size(), otherKey.minorPath.size());
        return this.minorPath.equals(otherKey.minorPath.subList(0, minorSize));
    }

    @Override
    public int compareTo(Key otherKey) {
        int minMajorSize = Math.min(this.majorPath.size(), otherKey.majorPath.size());
        for (int i = 0; i < minMajorSize; ++i) {
            int cmp = this.majorPath.get(i).compareTo(otherKey.majorPath.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        int sizeCmp = this.majorPath.size() - otherKey.majorPath.size();
        if (sizeCmp != 0) {
            return sizeCmp;
        }
        int minMinorSize = Math.min(this.minorPath.size(), otherKey.minorPath.size());
        for (int i = 0; i < minMinorSize; ++i) {
            int cmp = this.minorPath.get(i).compareTo(otherKey.minorPath.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.minorPath.size() - otherKey.minorPath.size();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Key)) {
            return false;
        }
        Key otherKey = (Key)other;
        return this.majorPath.equals(otherKey.majorPath) && this.minorPath.equals(otherKey.minorPath);
    }

    public int hashCode() {
        return this.majorPath.hashCode() + this.minorPath.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        for (String comp : this.majorPath) {
            sb.append(STRING_COMP_DELIM);
            Key.appendPathComponent(sb, comp);
        }
        if (!this.minorPath.isEmpty()) {
            String delim = STRING_PATH_DELIM;
            for (String comp : this.minorPath) {
                sb.append(delim);
                Key.appendPathComponent(sb, comp);
                delim = STRING_COMP_DELIM;
            }
        }
        return sb.toString();
    }

    private static void appendPathComponent(StringBuilder sb, String comp) {
        URI uri;
        if (comp.equals(STRING_PATH_DELIM_CHAR)) {
            sb.append(STRING_PATH_DELIM_ENCODED);
            return;
        }
        try {
            uri = new URI("kv", null, "host", -1, STRING_COMP_DELIM + comp, null, null);
        }
        catch (URISyntaxException shouldNeverHappen) {
            throw new FaultException(shouldNeverHappen, false);
        }
        String rawPath = uri.getRawPath().substring(1);
        boolean startedEncoding = false;
        for (int i = 0; i < rawPath.length(); ++i) {
            char c = rawPath.charAt(i);
            if (c != '\u0000' && c != '/') {
                if (!startedEncoding) continue;
                sb.append(c);
                continue;
            }
            if (!startedEncoding) {
                startedEncoding = true;
                sb.append(rawPath.substring(0, i));
            }
            sb.append(c == '/' ? SLASH_ENCODED : ZERO_ENCODED);
        }
        if (!startedEncoding) {
            sb.append(rawPath);
        }
    }

    public static Key fromString(String pathString) {
        return Key.fromIterator(new StringKeyIterator(pathString));
    }

    public byte[] toByteArray() {
        byte[] keyBytes;
        FastOutputStream out = new FastOutputStream();
        int majorLast = this.majorPath.size() - 1;
        assert (majorLast >= 0);
        for (int i = 0; i <= majorLast; ++i) {
            Key.writeUTF(out, this.majorPath.get(i));
            if (i == majorLast) continue;
            out.writeFast(0);
        }
        int minorLast = this.minorPath.size() - 1;
        if (minorLast >= 0) {
            out.writeFast(255);
            for (int i = 0; i <= minorLast; ++i) {
                Key.writeUTF(out, this.minorPath.get(i));
                if (i == minorLast) continue;
                out.writeFast(0);
            }
        }
        if ((keyBytes = out.toByteArray()).length > Short.MAX_VALUE) {
            throw new FaultException("Serialized key length:" + keyBytes.length + " exceeds maximum key permissible length:" + Short.MAX_VALUE, false);
        }
        return keyBytes;
    }

    private static void writeUTF(FastOutputStream out, String s) {
        if (s.length() == 0) {
            return;
        }
        char[] chars = s.toCharArray();
        int utfLength = UtfOps.getByteLength(chars);
        out.makeSpace(utfLength);
        UtfOps.charsToBytes(chars, 0, out.getBufferBytes(), out.getBufferLength(), chars.length);
        out.addSize(utfLength);
    }

    public static Key fromByteArray(byte[] keyBytes) {
        return Key.fromIterator(new BinaryKeyIterator(keyBytes));
    }

    public static int findNextComponent(byte[] key, int prevOff) {
        int endOff = key.length;
        if (prevOff >= endOff) {
            return -1;
        }
        for (int i = prevOff; i < endOff; ++i) {
            if (!Key.isDelimiter(key[i])) continue;
            return i;
        }
        return endOff;
    }

    public static boolean isDelimiter(byte val) {
        int b = val & 0xFF;
        return b == 255 || b == 0;
    }

    private static Key fromIterator(KeyIterator iter) {
        String s1 = iter.next();
        if (iter.atEndOfKey()) {
            return Key.createKey(s1);
        }
        if (iter.atEndOfMajorPath()) {
            String s2 = iter.next();
            if (iter.atEndOfKey()) {
                return Key.createKey(s1, s2);
            }
            ArrayList<String> minorList = new ArrayList<String>(2);
            minorList.add(s2);
            do {
                minorList.add(iter.next());
            } while (!iter.atEndOfKey());
            return Key.createKey(s1, minorList);
        }
        ArrayList<String> majorList = new ArrayList<String>(2);
        majorList.add(s1);
        do {
            majorList.add(iter.next());
        } while (!iter.atEndOfKey() && !iter.atEndOfMajorPath());
        if (iter.atEndOfKey()) {
            return Key.createKey(majorList);
        }
        String s2 = iter.next();
        if (iter.atEndOfKey()) {
            return Key.createKey(majorList, s2);
        }
        ArrayList<String> minorList = new ArrayList<String>(2);
        minorList.add(s2);
        do {
            minorList.add(iter.next());
        } while (!iter.atEndOfKey());
        return Key.createKey(majorList, minorList);
    }

    public static int getMajorPathLength(byte[] keyBytes) {
        int len = keyBytes.length;
        for (int i = 0; i < len; ++i) {
            if ((keyBytes[i] & 0xFF) != 255) continue;
            return i;
        }
        return len;
    }

    public static int countComponents(byte[] keyBytes) {
        int len = keyBytes.length;
        int count = 1;
        for (int i = 0; i < len; ++i) {
            int b = keyBytes[i] & 0xFF;
            if (b != 255 && b != 0) continue;
            ++count;
        }
        return count;
    }

    public static int getPrefixKeySize(byte[] keyBytes, int nComponents) {
        int i;
        assert (nComponents > 0);
        int len = keyBytes.length;
        int count = 1;
        for (i = 0; i < len; ++i) {
            int b = keyBytes[i] & 0xFF;
            if (b != 255 && b != 0) continue;
            if (count == nComponents) break;
            ++count;
        }
        assert (count == nComponents);
        return i;
    }

    public static byte[] getPrefixKey(byte[] keyBytes, int nComponents) {
        int i = Key.getPrefixKeySize(keyBytes, nComponents);
        byte[] prefix = new byte[i];
        System.arraycopy(keyBytes, 0, prefix, 0, prefix.length);
        return prefix;
    }

    public static int getComponentLength(byte[] keyBytes, int off) {
        int len = keyBytes.length;
        for (int i = off; i < len; ++i) {
            int b = keyBytes[i] & 0xFF;
            if (b != 255 && b != 0) continue;
            return i - off;
        }
        return len - off;
    }

    public static byte[] addComponent(byte[] parentKey, boolean majorPathComplete, String component) {
        FastOutputStream out = new FastOutputStream();
        if (parentKey != null) {
            out.writeFast(parentKey);
            out.writeFast(Key.getNextDelim(parentKey, majorPathComplete));
        }
        Key.writeUTF(out, component);
        return out.toByteArray();
    }

    public static boolean keySpaceIsInternal(byte[] serKeyBytes) {
        return serKeyBytes.length == 0 || serKeyBytes.length > 0 && serKeyBytes[0] == 0;
    }

    public boolean keySpaceIsInternal() {
        return this.getMajorPath().get(0).isEmpty();
    }

    private static int getNextDelim(byte[] parentKey, boolean majorPathComplete) {
        assert (parentKey != null);
        if (majorPathComplete) {
            if (Key.getMajorPathLength(parentKey) < parentKey.length) {
                return 0;
            }
            return 255;
        }
        return 0;
    }

    public static class BytesComparator
    implements Comparator<byte[]>,
    BinaryEqualityComparator {
        @Override
        public int compare(byte[] key1, byte[] key2) {
            int minLen = Math.min(key1.length, key2.length);
            for (int i = 0; i < minLen; ++i) {
                byte b1 = key1[i];
                byte b2 = key2[i];
                if (b1 == b2) continue;
                int i1 = b1 & 0xFF;
                int i2 = b2 & 0xFF;
                if (i1 == 255) {
                    return -1;
                }
                if (i2 == 255) {
                    return 1;
                }
                return i1 - i2;
            }
            return key1.length - key2.length;
        }
    }

    private static interface KeyIterator {
        public String next();

        public boolean atEndOfKey();

        public boolean atEndOfMajorPath();
    }

    public static class BinaryKeyIterator
    implements KeyIterator {
        protected final byte[] buf;
        private int off = 0;
        private int delim = 1;
        private boolean endOfKey = false;

        public BinaryKeyIterator(byte[] bytes) {
            this.buf = bytes;
        }

        @Override
        public String next() {
            return this.next(true);
        }

        public void reset() {
            this.off = 0;
            this.endOfKey = false;
        }

        public void skip() {
            this.next(false);
        }

        private String next(boolean returnValue) {
            if (this.endOfKey) {
                throw new IllegalStateException();
            }
            int origOff = this.off;
            boolean foundDelim = false;
            int utfLength = 0;
            for (int i = origOff; i < this.buf.length; ++i) {
                int b = this.buf[i] & 0xFF;
                if (b == 255 || b == 0) {
                    this.delim = b;
                    foundDelim = true;
                    break;
                }
                ++utfLength;
            }
            this.off += utfLength;
            if (foundDelim) {
                ++this.off;
            } else {
                this.delim = 1;
                this.endOfKey = true;
            }
            if (!returnValue) {
                return null;
            }
            if (utfLength == 0) {
                return "";
            }
            return UtfOps.bytesToString(this.buf, origOff, utfLength);
        }

        @Override
        public boolean atEndOfKey() {
            return this.endOfKey;
        }

        @Override
        public boolean atEndOfMajorPath() {
            return this.delim == 255;
        }
    }

    private static class StringKeyIterator
    implements KeyIterator {
        private final String pathString;
        private int off;
        private String delim = Key.access$000();
        private boolean endOfKey = false;

        StringKeyIterator(String s) {
            if (s.length() == 0 || s.charAt(0) != '/') {
                throw new IllegalArgumentException("Path string does not begin with slash: " + s);
            }
            this.pathString = s;
            this.off = 1;
        }

        @Override
        public String next() {
            URI uri;
            if (this.endOfKey) {
                throw new IllegalStateException();
            }
            int origOff = this.off;
            boolean foundDelim = false;
            int compLength = 0;
            for (int i = origOff; i < this.pathString.length(); ++i) {
                char c = this.pathString.charAt(i);
                if (c == '/') {
                    foundDelim = true;
                    break;
                }
                ++compLength;
            }
            this.off += compLength;
            if (foundDelim) {
                String newDelim = Key.STRING_PATH_DELIM;
                for (int j = 1; newDelim == Key.STRING_PATH_DELIM && j < Key.STRING_PATH_DELIM.length(); ++j) {
                    if (this.off + j < this.pathString.length() && this.pathString.charAt(this.off + j) == Key.STRING_PATH_DELIM.charAt(j)) continue;
                    newDelim = Key.STRING_COMP_DELIM;
                }
                this.delim = newDelim;
                this.off += newDelim.length();
            } else {
                this.delim = STRING_NULL_DELIM;
                this.endOfKey = true;
            }
            if (compLength == 0) {
                return "";
            }
            String comp = this.pathString.substring(origOff, origOff + compLength);
            try {
                uri = new URI("kv://host/" + comp);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Path component syntax is invalid", e);
            }
            comp = uri.getPath();
            assert (comp.charAt(0) == '/');
            return comp.substring(1);
        }

        @Override
        public boolean atEndOfKey() {
            return this.endOfKey;
        }

        @Override
        public boolean atEndOfMajorPath() {
            return this.delim == Key.STRING_PATH_DELIM;
        }
    }
}

