/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;

public class CMP3Policy
extends CMPPolicy {
    protected transient CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected transient HashMap<DatabaseField, CMPPolicy.KeyElementAccessor> fieldToAccessorMap;
    protected String pkClassName;
    protected Class pkClass = null;

    protected void addWritableMapping(ClassDescriptor aDescriptor, DatabaseField field, List allMappings) {
        DatabaseMapping writableMapping = aDescriptor.getObjectBuilder().getMappingForField(field);
        if (writableMapping != null) {
            allMappings.add(writableMapping);
        }
    }

    protected void addReadOnlyMappings(ClassDescriptor aDescriptor, DatabaseField field, List allMappings) {
        List readOnlyMappings = aDescriptor.getObjectBuilder().getReadOnlyMappingsForField(field);
        if (readOnlyMappings != null) {
            allMappings.addAll(readOnlyMappings);
        }
    }

    public CMP3Policy clone() {
        CMP3Policy policy = new CMP3Policy();
        policy.setPrimaryKeyClassName(this.getPKClassName());
        policy.setPKClass(this.getPKClass());
        return policy;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class aPKClass = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        aPKClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException exception) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), exception.getException());
                    }
                } else {
                    aPKClass = PrivilegedAccessHelper.getClassForName((String)this.getPKClassName(), (boolean)true, (ClassLoader)classLoader);
                }
                this.setPKClass(aPKClass);
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"pk_class_not_found", (Object[])new Object[]{this.pkClassName}), exc);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String pkClassName) {
        this.pkClassName = pkClassName;
    }

    public Class getPKClass() {
        return this.pkClass;
    }

    public void setPKClass(Class pkClass) {
        this.pkClass = pkClass;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (IllegalAccessException ex) {
            throw DescriptorException.exceptionAccessingPrimaryKeyInstance((ClassDescriptor)this.getDescriptor(), (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw DescriptorException.exceptionAccessingPrimaryKeyInstance((ClassDescriptor)this.getDescriptor(), (Exception)ex);
        }
    }

    public Object createPrimaryKeyFromId(Object key, AbstractSession session) {
        CMPPolicy.KeyElementAccessor[] pkElementArray = this.getKeyClassFields();
        Object[] primaryKey = null;
        if (this.getDescriptor().getCacheKeyType() != CacheKeyType.ID_VALUE) {
            primaryKey = new Object[pkElementArray.length];
        }
        for (int index = 0; index < pkElementArray.length; ++index) {
            DatabaseMapping mapping = pkElementArray[index].getMapping();
            Object fieldValue = null;
            if (mapping.isAbstractColumnMapping()) {
                if (pkElementArray[index].isNestedAccessor()) {
                    DatabaseField keyField = pkElementArray[index].getDatabaseField();
                    Object keyToUse = key;
                    DatabaseMapping keyMapping = this.getDescriptor().getObjectBuilder().getMappingForField(keyField);
                    if (keyMapping.isAggregateMapping()) {
                        keyMapping = keyMapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(keyField);
                        while (keyMapping.isAggregateMapping()) {
                            keyToUse = keyMapping.getRealAttributeValueFromObject(keyToUse, session);
                            keyMapping = keyMapping.getReferenceDescriptor().getObjectBuilder().getMappingForField(keyField);
                        }
                        fieldValue = ((AbstractColumnMapping)mapping).getFieldValue(pkElementArray[index].getValue(keyToUse, session), session);
                    } else {
                        fieldValue = ((AbstractColumnMapping)mapping).getFieldValue(pkElementArray[index].getValue(keyToUse, session), session);
                    }
                } else {
                    fieldValue = ((AbstractColumnMapping)mapping).getFieldValue(pkElementArray[index].getValue(key, session), session);
                }
            } else {
                fieldValue = pkElementArray[index].getValue(key, session);
                if (fieldValue != null && this.pkClass != null && mapping.isOneToOneMapping()) {
                    OneToOneMapping refmapping = (OneToOneMapping)mapping;
                    DatabaseField targetKey = (DatabaseField)refmapping.getSourceToTargetKeyFields().get(pkElementArray[index].getDatabaseField());
                    CMPPolicy refPolicy = refmapping.getReferenceDescriptor().getCMPPolicy();
                    if (refPolicy.isCMP3Policy()) {
                        Class aPKClass = refPolicy.getPKClass();
                        if (aPKClass != null && aPKClass != fieldValue.getClass() && !aPKClass.isAssignableFrom(fieldValue.getClass())) {
                            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{aPKClass, fieldValue.getClass()}));
                        }
                        fieldValue = ((CMP3Policy)refPolicy).getPkValueFromKeyForField(fieldValue, targetKey, session);
                    }
                }
            }
            if (this.getDescriptor().getCacheKeyType() == CacheKeyType.ID_VALUE) {
                return fieldValue;
            }
            primaryKey[index] = fieldValue;
        }
        return new CacheId(primaryKey);
    }

    protected Field getField(Class cls, String fieldName) throws NoSuchFieldException {
        Field keyField = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                keyField = (Field)AccessController.doPrivileged(new PrivilegedGetField(cls, fieldName, true));
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchFieldException)exception.getException();
            }
        } else {
            keyField = PrivilegedAccessHelper.getField((Class)cls, (String)fieldName, (boolean)true);
        }
        return keyField;
    }

    public Object createBeanUsingKey(Object key, AbstractSession session) {
        try {
            Object bean = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElements = this.getKeyClassFields();
            for (int index = 0; index < keyElements.length; ++index) {
                Object toWriteInto = bean;
                Object keyFieldValue = keyElements[index].getValue(key, session);
                DatabaseField field = keyElements[index].getDatabaseField();
                DatabaseMapping mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName());
                if (mapping == null) {
                    mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                }
                while (mapping.isAggregateObjectMapping()) {
                    Object aggregate = mapping.getRealAttributeValueFromObject(toWriteInto, session);
                    if (aggregate == null) {
                        aggregate = mapping.getReferenceDescriptor().getJavaClass().newInstance();
                        mapping.setRealAttributeValueInObject(toWriteInto, aggregate);
                    }
                    if ((mapping = mapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElements[index].getAttributeName())) == null) {
                        mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                    }
                    toWriteInto = aggregate;
                }
                mapping.setRealAttributeValueInObject(toWriteInto, keyFieldValue);
            }
            return bean;
        }
        catch (Exception e) {
            throw DescriptorException.errorUsingPrimaryKey((Object)key, (ClassDescriptor)this.getDescriptor(), (Exception)e);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class keyClass, AbstractSession session) {
        CMPPolicy.KeyElementAccessor[] pkAttributes = null;
        ClassDescriptor aDescriptor = this.getDescriptor();
        this.fieldToAccessorMap = new HashMap();
        int numberOfIDFields = aDescriptor.getPrimaryKeyFields().size();
        pkAttributes = new CMPPolicy.KeyElementAccessor[numberOfIDFields];
        Iterator attributesIter = aDescriptor.getPrimaryKeyFields().iterator();
        int i = 0;
        while (attributesIter.hasNext()) {
            DatabaseField field = (DatabaseField)attributesIter.next();
            ArrayList allMappings = new ArrayList(1);
            this.addReadOnlyMappings(aDescriptor, field, allMappings);
            this.addWritableMapping(aDescriptor, field, allMappings);
            ReflectiveOperationException noSuchElementException = null;
            Class currentKeyClass = keyClass;
            for (int index = allMappings.size() - 1; index >= 0; --index) {
                DatabaseMapping mapping;
                block30: {
                    CMPPolicy refPolicy;
                    ClassDescriptor refDescriptor;
                    String fieldName;
                    mapping = (DatabaseMapping)allMappings.get(index);
                    if (!aDescriptor.hasDerivedId() || mapping.derivesId() ? mapping.isForeignReferenceMapping() && !mapping.isOneToOneMapping() : mapping.isAggregateMapping() && allMappings.size() > 1) continue;
                    if (mapping.isAggregateMapping()) {
                        this.addReadOnlyMappings(mapping.getReferenceDescriptor(), field, allMappings);
                        this.addWritableMapping(mapping.getReferenceDescriptor(), field, allMappings);
                        allMappings.remove(mapping);
                        index = allMappings.size();
                        currentKeyClass = mapping.getReferenceDescriptor().getJavaClass();
                        continue;
                    }
                    String string = fieldName = mapping.hasMapsIdValue() ? mapping.getMapsIdValue() : mapping.getAttributeName();
                    if (currentKeyClass == null || mapping.isMultitenantPrimaryKeyMapping()) {
                        pkAttributes[i] = new CMPPolicy.KeyIsElementAccessor(fieldName, field, mapping);
                        if (mapping.isAbstractDirectMapping()) {
                            this.setPKClass(ConversionManager.getObjectClass((Class)mapping.getAttributeClassification()));
                        } else if (mapping.isOneToOneMapping()) {
                            refDescriptor = mapping.getReferenceDescriptor();
                            if (!session.isRemoteSession()) {
                                refDescriptor.initialize(session);
                            }
                            refPolicy = refDescriptor.getCMPPolicy();
                            this.setPKClass(refPolicy.getPKClass());
                        }
                        this.fieldToAccessorMap.put(field, pkAttributes[i]);
                        noSuchElementException = null;
                    } else {
                        if (mapping.isOneToOneMapping()) {
                            refDescriptor = mapping.getReferenceDescriptor();
                            if (!session.isRemoteSession()) {
                                refDescriptor.initialize(session);
                            }
                            if ((refPolicy = refDescriptor.getCMPPolicy()) != null && refPolicy.isCMP3Policy() && refPolicy.getPKClass() == currentKeyClass) {
                                OneToOneMapping refmapping = (OneToOneMapping)mapping;
                                DatabaseField targetKey = (DatabaseField)refmapping.getSourceToTargetKeyFields().get(field);
                                pkAttributes[i] = ((CMP3Policy)refPolicy).fieldToAccessorMap.get(targetKey);
                                this.fieldToAccessorMap.put(field, pkAttributes[i]);
                                noSuchElementException = null;
                                break;
                            }
                        }
                        try {
                            pkAttributes[i] = new FieldAccessor(this, this.getField(currentKeyClass, fieldName), fieldName, field, mapping, currentKeyClass != keyClass);
                            this.fieldToAccessorMap.put(field, pkAttributes[i]);
                            noSuchElementException = null;
                        }
                        catch (NoSuchFieldException ex) {
                            String getMethodName = null;
                            String setMethodName = null;
                            if (mapping.isObjectReferenceMapping() && ((ObjectReferenceMapping)mapping).getIndirectionPolicy().isWeavedObjectBasicIndirectionPolicy()) {
                                WeavedObjectBasicIndirectionPolicy weavedIndirectionPolicy = (WeavedObjectBasicIndirectionPolicy)((ObjectReferenceMapping)mapping).getIndirectionPolicy();
                                if (weavedIndirectionPolicy.hasUsedMethodAccess()) {
                                    getMethodName = weavedIndirectionPolicy.getGetMethodName();
                                    setMethodName = weavedIndirectionPolicy.getSetMethodName();
                                }
                            } else {
                                getMethodName = mapping.getGetMethodName();
                                setMethodName = mapping.getSetMethodName();
                            }
                            if (getMethodName != null) {
                                try {
                                    Method getMethod = null;
                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                        try {
                                            getMethod = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(currentKeyClass, getMethodName, new Class[0], true));
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw (NoSuchMethodException)exception.getException();
                                        }
                                    } else {
                                        getMethod = PrivilegedAccessHelper.getMethod((Class)currentKeyClass, (String)getMethodName, (Class[])new Class[0], (boolean)true);
                                    }
                                    Method setMethod = null;
                                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                        try {
                                            setMethod = (Method)AccessController.doPrivileged(new PrivilegedGetMethod(currentKeyClass, setMethodName, new Class[]{getMethod.getReturnType()}, true));
                                        }
                                        catch (PrivilegedActionException exception) {
                                            throw (NoSuchMethodException)exception.getException();
                                        }
                                    } else {
                                        setMethod = PrivilegedAccessHelper.getMethod((Class)currentKeyClass, (String)setMethodName, (Class[])new Class[]{getMethod.getReturnType()}, (boolean)true);
                                    }
                                    pkAttributes[i] = new PropertyAccessor(this, getMethod, setMethod, fieldName, field, mapping, currentKeyClass != keyClass);
                                    this.fieldToAccessorMap.put(field, pkAttributes[i]);
                                    noSuchElementException = null;
                                }
                                catch (NoSuchMethodException exs) {
                                    noSuchElementException = exs;
                                }
                            } else {
                                noSuchElementException = ex;
                            }
                            if (noSuchElementException == null || !mapping.getAttributeAccessor().isValuesAccessor()) break block30;
                            pkAttributes[i] = new ValuesFieldAccessor(fieldName, field, mapping, currentKeyClass != keyClass);
                            noSuchElementException = null;
                        }
                    }
                }
                if (mapping.derivesId() || noSuchElementException == null) break;
            }
            if (noSuchElementException != null) {
                throw DescriptorException.errorUsingPrimaryKey((Object)keyClass, (ClassDescriptor)this.getDescriptor(), noSuchElementException);
            }
            ++i;
        }
        return pkAttributes;
    }

    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields() {
        return this.keyClassFields;
    }

    public Object getPkValueFromKeyForField(Object key, DatabaseField field, AbstractSession session) {
        Object fieldValue = null;
        CMPPolicy.KeyElementAccessor accessor = this.fieldToAccessorMap.get(field);
        DatabaseMapping mapping = accessor.getMapping();
        if (mapping.isAbstractColumnMapping()) {
            fieldValue = ((AbstractColumnMapping)mapping).getFieldValue(accessor.getValue(key, session), session);
        } else {
            fieldValue = accessor.getValue(key, session);
            if (mapping.isOneToOneMapping()) {
                OneToOneMapping refmapping = (OneToOneMapping)mapping;
                DatabaseField targetKey = (DatabaseField)refmapping.getSourceToTargetKeyFields().get(accessor.getDatabaseField());
                CMPPolicy refPolicy = refmapping.getReferenceDescriptor().getCMPPolicy();
                if (refPolicy.isCMP3Policy()) {
                    Class pkClass = refPolicy.getPKClass();
                    if (pkClass != null && pkClass != fieldValue.getClass() && !pkClass.isAssignableFrom(fieldValue.getClass())) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"invalid_pk_class", (Object[])new Object[]{refPolicy.getPKClass(), fieldValue.getClass()}));
                    }
                    fieldValue = ((CMP3Policy)refPolicy).getPkValueFromKeyForField(fieldValue, targetKey, session);
                }
            }
        }
        return fieldValue;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        super.initialize(descriptor, session);
        this.keyClassFields = this.initializePrimaryKeyFields(this.pkClass, session);
    }

    public void remoteInitialize(ClassDescriptor descriptor, AbstractSession session) throws DescriptorException {
        super.remoteInitialize(descriptor, session);
        this.keyClassFields = this.initializePrimaryKeyFields(null, session);
    }

    private static final class ValuesFieldAccessor
    extends CommonAccessor {
        public ValuesFieldAccessor(String attributeName, DatabaseField databaseField, DatabaseMapping mapping, boolean isNestedAccessor) {
            super(attributeName, databaseField, mapping, isNestedAccessor);
        }

        public Object getValue(Object object, AbstractSession session) {
            return this.mapping.getRealAttributeValueFromObject(object, session);
        }

        public void setValue(Object object, Object value) {
            this.mapping.setRealAttributeValueInObject(object, value);
        }
    }

    private static final class FieldAccessor
    extends CommonAccessor {
        private final Field field;
        private final CMPPolicy policy;

        public FieldAccessor(CMPPolicy policy, Field field, String attributeName, DatabaseField databaseField, DatabaseMapping mapping, boolean isNestedAccessor) {
            super(attributeName, databaseField, mapping, isNestedAccessor);
            this.field = field;
            this.policy = policy;
        }

        public Object getValue(Object object, AbstractSession session) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException exception) {
                        throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)exception.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField((Field)this.field, (Object)object);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)ex);
            }
        }

        public void setValue(Object object, Object value) {
            block5: {
                try {
                    Field pkField = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            pkField = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(pkField, object, value));
                            break block5;
                        }
                        catch (PrivilegedActionException exception) {
                            throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)exception.getException());
                        }
                    }
                    pkField = PrivilegedAccessHelper.getField(object.getClass(), (String)this.field.getName(), (boolean)true);
                    PrivilegedAccessHelper.setValueInField((Field)pkField, (Object)object, (Object)value);
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)ex);
                }
            }
        }
    }

    private static final class PropertyAccessor
    extends CommonAccessor {
        private final Method getMethod;
        private final Method setMethod;
        private final CMPPolicy policy;

        public PropertyAccessor(CMPPolicy policy, Method getMethod, Method setMethod, String attributeName, DatabaseField databaseField, DatabaseMapping mapping, boolean isNestedAccessor) {
            super(attributeName, databaseField, mapping, isNestedAccessor);
            this.getMethod = getMethod;
            this.setMethod = setMethod;
            this.policy = policy;
        }

        public Object getValue(Object object, AbstractSession session) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod, object, new Object[0]));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw (IllegalAccessException)throwableException;
                        }
                        throw (InvocationTargetException)throwableException;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)this.getMethod, (Object)object, (Object[])new Object[0]);
            }
            catch (Exception ex) {
                throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)ex);
            }
        }

        public void setValue(Object object, Object value) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(this.setMethod, object, new Object[]{value}));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            Exception throwableException = exception.getException();
                            if (throwableException instanceof IllegalAccessException) {
                                throw (IllegalAccessException)throwableException;
                            }
                            throw (InvocationTargetException)throwableException;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod((Method)this.setMethod, (Object)object, (Object[])new Object[]{value});
                }
                catch (Exception ex) {
                    throw DescriptorException.errorUsingPrimaryKey((Object)object, (ClassDescriptor)this.policy.getDescriptor(), (Exception)ex);
                }
            }
        }
    }

    private static abstract class CommonAccessor
    implements CMPPolicy.KeyElementAccessor {
        private final String attributeName;
        private final DatabaseField databaseField;
        protected final DatabaseMapping mapping;
        private final boolean isNestedAccessor;

        public CommonAccessor(String attributeName, DatabaseField field, DatabaseMapping mapping, boolean isNestedAccessor) {
            this.attributeName = attributeName;
            this.databaseField = field;
            this.mapping = mapping;
            this.isNestedAccessor = isNestedAccessor;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public boolean isNestedAccessor() {
            return this.isNestedAccessor;
        }
    }
}

