/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import java.util.Hashtable;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;

public class ExpressionNode {
    protected static String Equals = "(=) Equals";
    protected static String NotEquals = "(!=) Not Equals";
    protected static String LessThan = "(<) Less Than";
    protected static String LessThanEqual = "(<=) Less Than Equal";
    protected static String GreaterThan = "(>) Greater Than";
    protected static String GreaterThanEqual = "(>=) Greater Than Equal";
    protected static String Like = "Like";
    protected static String NotLike = "Not Like";
    protected static String In = "In";
    protected static String NotIn = "Not In";
    protected static String Between = "Between";
    protected static String NotBetween = "Not Between";
    protected static String Or = "Or";
    protected static String And = "And";
    protected static String Not = "Not";
    protected static String Upper = "Upper Case";
    protected static String Lower = "Lower Case";
    protected static String KeyWordAll = "All Key Words";
    protected static String KeyWordAny = "Any Key Words";
    protected static Hashtable operators;
    protected static Hashtable methods;
    protected Expression expression;

    public ExpressionNode(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public static String getMethod(String method) {
        return (String)ExpressionNode.getMethods().get(method);
    }

    public static Hashtable getMethods() {
        if (methods == null) {
            methods = new Hashtable();
            methods.put(Equals, "equal");
            methods.put(NotEquals, "notEqual");
            methods.put(LessThan, "lessThan");
            methods.put(LessThanEqual, "lessThanEqual");
            methods.put(GreaterThan, "greaterThan");
            methods.put(GreaterThanEqual, "greaterThanEqual");
            methods.put(Like, "like");
            methods.put(NotLike, "notLike");
            methods.put(In, "in");
            methods.put(NotIn, "notIn");
            methods.put(Between, "between");
            methods.put(NotBetween, "notBetween");
            methods.put(Or, "or");
            methods.put(And, "and");
            methods.put(Not, "not");
            methods.put(Lower, "toLowerCase");
            methods.put(Upper, "toUpperCase");
            methods.put(KeyWordAny, "containsAnyKeyWords");
            methods.put(KeyWordAll, "containsAllKeyWords");
        }
        return methods;
    }

    public static String getOperator(int anOperator) {
        return (String)ExpressionNode.getOperators().get(new Integer(anOperator));
    }

    public static Hashtable getOperators() {
        if (operators == null) {
            operators = new Hashtable();
            operators.put(new Integer(4), Equals);
            operators.put(new Integer(5), NotEquals);
            operators.put(new Integer(7), LessThan);
            operators.put(new Integer(8), LessThanEqual);
            operators.put(new Integer(9), GreaterThan);
            operators.put(new Integer(10), GreaterThanEqual);
            operators.put(new Integer(11), Like);
            operators.put(new Integer(12), NotLike);
            operators.put(new Integer(13), In);
            operators.put(new Integer(14), NotIn);
            operators.put(new Integer(15), Between);
            operators.put(new Integer(16), NotBetween);
            operators.put(new Integer(2), Or);
            operators.put(new Integer(1), And);
            operators.put(new Integer(3), Not);
            operators.put(new Integer(29), Lower);
            operators.put(new Integer(28), Upper);
        }
        return operators;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public String toString() {
        if (this.getExpression() == null) {
            return "True";
        }
        if (this.getExpression() instanceof ConstantExpression) {
            return ((ConstantExpression)this.getExpression()).getValue().toString();
        }
        if (this.getExpression() instanceof QueryKeyExpression) {
            return ((QueryKeyExpression)this.getExpression()).getName().toString();
        }
        String anOperator = ExpressionNode.getOperator(this.getExpression().getOperator().getSelector());
        if (anOperator == null) {
            return this.getExpression().getOperator().toString();
        }
        return anOperator;
    }
}

