/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.IndirectListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ConstructingDescriptorExceptionTests
extends AutoVerifyTestCase {
    Vector testResults = new Vector();
    EclipseLinkException caughtException = null;

    public ConstructingDescriptorExceptionTests() {
        this.setDescription("This creates all untestable Descriptor Exceptions by calling each static method contructor for Code Coverage (methods and error codes could be Deprecated)");
    }

    public void test() throws NoSuchMethodException {
        try {
            Class<ConstructingDescriptorExceptionTests> javaClass = ConstructingDescriptorExceptionTests.class;
            RelationalDescriptor descriptor = new RelationalDescriptor();
            descriptor.setJavaClass(javaClass);
            TestErrorException dummyException = new TestErrorException("no ERROR");
            DirectToFieldMapping mapping = new DirectToFieldMapping();
            OneToOneMapping mappingFR = new OneToOneMapping();
            IndirectListContainerPolicy policy = new IndirectListContainerPolicy();
            Object object = new Object();
            DatabaseRecord row = new DatabaseRecord();
            Class[] parmClasses = new Class[]{};
            Method method = javaClass.getDeclaredMethod("test", parmClasses);
            DescriptorException descriptorException = DescriptorException.javaClassNotSpecified((ClassDescriptor)descriptor);
            if (descriptorException.getErrorCode() != 39) {
                this.testResults.add("DescriptorException.javaClassNotSpecified");
            }
            if ((descriptorException = DescriptorException.writeLockFieldInChildDescriptor((ClassDescriptor)descriptor)).getErrorCode() != 109) {
                this.testResults.add("DescriptorException.writeLockFieldInChildDescriptor");
            }
            if ((descriptorException = DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent((ClassDescriptor)descriptor, (ClassDescriptor)descriptor, (String)"dummy")).getErrorCode() != 120) {
                this.testResults.add("DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent");
            }
            if ((descriptorException = DescriptorException.missingIndirectContainerConstructor(javaClass)).getErrorCode() != 145) {
                this.testResults.add("DescriptorException.missingIndirectContainerConstructor");
            }
            if ((descriptorException = DescriptorException.couldNotInstantiateIndirectContainerClass(javaClass, (Exception)dummyException)).getErrorCode() != 146) {
                this.testResults.add("DescriptorException.couldNotInstantiateIndirectContainerClass");
            }
            if ((descriptorException = DescriptorException.invalidContainerPolicy((ContainerPolicy)policy, javaClass)).getErrorCode() != 147) {
                this.testResults.add("DescriptorException.invalidContainerPolicy");
            }
            if ((descriptorException = DescriptorException.invalidUseOfNoIndirection((DatabaseMapping)mapping)).getErrorCode() != 149) {
                this.testResults.add("DescriptorException.invalidUseOfNoIndirection");
            }
            if ((descriptorException = DescriptorException.proxyIndirectionNotAvailable((DatabaseMapping)mapping)).getErrorCode() != 159) {
                this.testResults.add("DescriptorException.proxyIndirectionNotAvailable");
            }
            if ((descriptorException = DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor((String)"attributeName", (String)"objectName", (Throwable)dummyException)).getErrorCode() != 13) {
                this.testResults.add("DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileCloning((Object)object, (String)"methodName", (ClassDescriptor)descriptor, (Throwable)dummyException)).getErrorCode() != 14) {
                this.testResults.add("DescriptorException.illegalAccessWhileCloning");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileEventExecution((String)"eventMethodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 16) {
                this.testResults.add("DescriptorException.illegalAccessWhileEventExecution");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor((String)"methodName", (String)"objectName", (Throwable)dummyException)).getErrorCode() != 17) {
                this.testResults.add("DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileInstantiatingMethodBasedProxy((Throwable)dummyException)).getErrorCode() != 18) {
                this.testResults.add("DescriptorException.illegalAccessWhileInstantiatingMethodBasedProxy");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileInvokingAttributeMethod((DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 19) {
                this.testResults.add("DescriptorException.illegalAccessWhileInvokingAttributeMethod");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileInvokingFieldToMethod((String)"methodName", (DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 20) {
                this.testResults.add("DescriptorException.illegalAccessWhileInvokingFieldToMethod");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((AbstractRecord)row, (Method)method, (ClassDescriptor)descriptor, (Throwable)dummyException)).getErrorCode() != 21) {
                this.testResults.add("DescriptorException.illegalAccessWhileInvokingRowExtractionMethod");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileMethodInstantiation((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 22) {
                this.testResults.add("DescriptorException.illegalAccessWhileMethodInstantiation");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileObsoleteEventExecute((String)"eventMethodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 23) {
                this.testResults.add("DescriptorException.illegalAccessWhileObsoleteEventExecute");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor((String)"attributeName", (String)"objectName", (Object)object, (Throwable)dummyException)).getErrorCode() != 24) {
                this.testResults.add("DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor((String)"setMethodName", (Object)object, (Throwable)dummyException)).getErrorCode() != 25) {
                this.testResults.add("DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor");
            }
            if ((descriptorException = DescriptorException.missingClassForIndicatorFieldValue((Object)object, (ClassDescriptor)descriptor)).getErrorCode() != 43) {
                this.testResults.add("DescriptorException.missingClassForIndicatorFieldValue");
            }
            if ((descriptorException = DescriptorException.missingClassIndicatorField((AbstractRecord)row, (ClassDescriptor)descriptor)).getErrorCode() != 44) {
                this.testResults.add("DescriptorException.missingClassIndicatorField");
            }
            if ((descriptorException = DescriptorException.notDeserializable((DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 66) {
                this.testResults.add("DescriptorException.notDeserializable");
            }
            if ((descriptorException = DescriptorException.notSerializable((DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 67) {
                this.testResults.add("DescriptorException.notSerializable");
            }
            if ((descriptorException = DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor((String)"attributeName", (Object)object, (Throwable)dummyException)).getErrorCode() != 71) {
                this.testResults.add("DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor");
            }
            if ((descriptorException = DescriptorException.nullPointerWhileSettingValueThruMethodAccessor((String)"setMethodName", (Object)object, (Throwable)dummyException)).getErrorCode() != 72) {
                this.testResults.add("DescriptorException.nullPointerWhileSettingValueThruMethodAccessor");
            }
            if ((descriptorException = DescriptorException.securityOnFindMethod((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 82) {
                this.testResults.add("DescriptorException.securityOnFindMethod");
            }
            if ((descriptorException = DescriptorException.securityOnFindObsoleteMethod((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 83) {
                this.testResults.add("DescriptorException.securityOnFindObsoleteMethod");
            }
            if ((descriptorException = DescriptorException.securityOnInitializingAttributeMethod((String)"attributeMethodName", (DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 84) {
                this.testResults.add("DescriptorException.securityOnInitializingAttributeMethod");
            }
            if ((descriptorException = DescriptorException.securityWhileConvertingToMethod((String)"methodName", (DatabaseMapping)mapping, (Throwable)dummyException)).getErrorCode() != 85) {
                this.testResults.add("DescriptorException.securityWhileConvertingToMethod");
            }
            if ((descriptorException = DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor((String)"attributeName", (String)"javaClassName", (Throwable)dummyException)).getErrorCode() != 86) {
                this.testResults.add("DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor");
            }
            if ((descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor((String)"setMethodName", (String)"getMethodName", (String)"javaClassName")).getErrorCode() != 87) {
                this.testResults.add("DescriptorException.securityWhileInitializingAttributesInMethodAccessor");
            }
            if ((descriptorException = DescriptorException.securityWhileInitializingClassExtractionMethod((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 88) {
                this.testResults.add("DescriptorException.securityWhileInitializingClassExtractionMethod");
            }
            if ((descriptorException = DescriptorException.securityWhileInitializingCopyPolicy((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 89) {
                this.testResults.add("DescriptorException.securityWhileInitializingCopyPolicy");
            }
            if ((descriptorException = DescriptorException.securityWhileInitializingInstantiationPolicy((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 90) {
                this.testResults.add("DescriptorException.securityWhileInitializingInstantiationPolicy");
            }
            if ((descriptorException = DescriptorException.sizeMismatchOfForeignKeys((ForeignReferenceMapping)mappingFR)).getErrorCode() != 92) {
                this.testResults.add("DescriptorException.sizeMismatchOfForeignKeys");
            }
            if ((descriptorException = DescriptorException.targetForeignKeysSizeMismatch((ForeignReferenceMapping)mappingFR)).getErrorCode() != 96) {
                this.testResults.add("DescriptorException.targetForeignKeysSizeMismatch");
            }
            if ((descriptorException = DescriptorException.multipleTableInsertOrderMismatch((ClassDescriptor)descriptor)).getErrorCode() != 143) {
                this.testResults.add("DescriptorException.multipleTableInsertOrderMismatch");
            }
            if ((descriptorException = DescriptorException.variableOneToOneMappingIsNotDefinedProperly((DatabaseMapping)mapping, (ClassDescriptor)descriptor, (String)"targetKeyName")).getErrorCode() != 166) {
                this.testResults.add("DescriptorException.variableOneToOneMappingIsNotDefinedProperly");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileConstructorInstantiationOfFactory((ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 170) {
                this.testResults.add("DescriptorException.illegalAccessWhileConstructorInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory((ClassDescriptor)descriptor, (Throwable)dummyException)).getErrorCode() != 172) {
                this.testResults.add("DescriptorException.noSuchMethodWhileConstructorInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.nullPointerWhileConstructorInstantiationOfFactory((ClassDescriptor)descriptor, (Throwable)dummyException)).getErrorCode() != 173) {
                this.testResults.add("DescriptorException.nullPointerWhileConstructorInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.illegalAccessWhileMethodInstantiationOfFactory((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 174) {
                this.testResults.add("DescriptorException.illegalAccessWhileMethodInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.targetInvocationWhileMethodInstantiationOfFactory((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 175) {
                this.testResults.add("DescriptorException.targetInvocationWhileMethodInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.nullPointerWhileMethodInstantiationOfFactory((String)"methodName", (ClassDescriptor)descriptor, (Exception)dummyException)).getErrorCode() != 176) {
                this.testResults.add("DescriptorException.nullPointerWhileMethodInstantiationOfFactory");
            }
            if ((descriptorException = DescriptorException.mappingForAttributeIsMissing((String)"attributeName", (ClassDescriptor)descriptor)).getErrorCode() != 177) {
                this.testResults.add("DescriptorException.mappingForAttributeIsMissing");
            }
            if ((descriptorException = DescriptorException.attributeMappingIsMissingForEntityBean((String)"attributeName", (String)"beanName")).getErrorCode() != 178) {
                this.testResults.add("DescriptorException.attributeMappingIsMissingForEntityBean");
            }
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    protected void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("An exception was thrown:" + Helper.cr() + "caught exception was not null! \n\n[EXPECTING] no Exceptions ");
        }
        for (String item : this.testResults) {
            if (item.equalsIgnoreCase("passed")) continue;
            throw new TestErrorException("The proper exception was not created:" + Helper.cr() + "[Problem with METHOD] " + item);
        }
    }
}

