/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simplepojoclient;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.simplepojoclient.PojoEmployee;

public class SimplePojoSessionsXMLClientTest
extends TestCase {
    private SessionManager sessionManager = null;
    private SimplePojoSessionsXMLClientTest simplePojoSessionsXMLClient = null;
    private DatabaseSession session = null;

    public SimplePojoSessionsXMLClientTest() {
        this.setName("SimplePojoSessionsXMLClientTest");
    }

    public void setup() throws TestErrorException {
        this.simplePojoSessionsXMLClient = new SimplePojoSessionsXMLClientTest();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Now running Simple POJO test using Sessions XML file...");
        try {
            XMLSessionConfigLoader xmlLoader = new XMLSessionConfigLoader("SimplePojoClientSessions.xml");
            this.sessionManager = SessionManager.getManager();
            this.session = (DatabaseSession)this.sessionManager.getSession(xmlLoader, "Session", ((Object)((Object)this.simplePojoSessionsXMLClient)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new TestErrorException("Session failed to load properly.  Caught: " + e);
        }
    }

    public void test() throws TestErrorException {
        try {
            Vector objects = this.session.readAllObjects(PojoEmployee.class);
            Iterator itr = objects.iterator();
            while (itr.hasNext()) {
                this.simplePojoSessionsXMLClient.printObjectAttributes(itr.next());
            }
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Test using Project Deployment XML file is complete" + System.getProperty("line.separator") + System.getProperty("line.separator"));
        }
        catch (Exception e) {
            throw new TestErrorException("" + e);
        }
    }

    private void printObjectAttributes(Object object) throws Exception {
        System.out.println("Object Name: " + object.getClass().getName());
        System.out.println("Fields:");
        Field[] fields = object.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                field.setAccessible(true);
                System.out.println("    " + field.getName() + " = " + field.get(object));
                continue;
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }
}

