/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PredefinedQueryReadObjectTest
extends ReadObjectTest {
    protected Exception caughtException;

    public PredefinedQueryReadObjectTest(Object originalObject) {
        super(originalObject);
        this.setName("PredefinedQueryReadObjectTest");
    }

    public void reset() {
        this.getSession().removeQuery("getEmployee");
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression firstNameExpression = builder.get("firstName").equal(builder.getParameter("firstName"));
        Expression lastNameExpression = builder.get("lastName").equal(builder.getParameter("lastName"));
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(firstNameExpression.and(lastNameExpression));
        query.addArgument("firstName");
        query.addArgument("lastName");
        if (this.getSession() instanceof RemoteSession) {
            ClassDescriptor descriptor = RemoteModel.getServerSession().getDescriptor(Employee.class);
        } else {
            ClassDescriptor descriptor = this.getSession().getDescriptor(Employee.class);
        }
        this.getSession().removeQuery("getEmployee");
        this.getSession().addQuery("getEmployee", (DatabaseQuery)query);
    }

    protected void test() {
        try {
            this.objectFromDatabase = this.getSession().executeQuery("getEmployee", (Object)"Bob", (Object)"Smith");
        }
        catch (ClassCastException e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Testing predefined query. Adding to and removing from session. \nThis exception thrown while testing test case\n----- PredefinedQueryReadObjectTest() -----\n");
        }
    }
}

