/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Stack;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class DirectReadQueryTest1
extends TestCase {
    Stack stack;

    public DirectReadQueryTest1() {
        this.setDescription("This tests direct read queries with various container policies.");
    }

    public DirectReadQuery buildNewQuery() {
        return new DirectReadQuery("select L_NAME from EMPLOYEE");
    }

    public void test() {
        this.testStackContainerPolicy();
        this.testCursoredStreamPolicy();
    }

    public void testCursoredStreamPolicy() {
        ValueReadQuery sizeQuery = new ValueReadQuery("select count(*) from EMPLOYEE");
        DirectReadQuery query = this.buildNewQuery();
        query.useCursoredStream(5, 5, sizeQuery);
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        int count = 0;
        while (stream.hasMoreElements()) {
            ++count;
            String lastName = (String)stream.nextElement();
            if (lastName.length() != 0) continue;
            throw new TestErrorException("missing data");
        }
        if (count != this.stack.size()) {
            throw new TestErrorException("stream does not match stack - expected: " + this.stack.size() + " actual: " + count);
        }
    }

    public void testStackContainerPolicy() {
        DirectReadQuery query = this.buildNewQuery();
        query.useCollectionClass(Stack.class);
        this.stack = (Stack)this.getSession().executeQuery((DatabaseQuery)query);
        String lastName = (String)this.stack.peek();
        if (lastName.length() == 0) {
            throw new TestErrorException("missing data");
        }
    }
}

