/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInObject;

public class UpdateAllWithTimestampLockingTest
extends TransactionalTestCase {
    protected int rowsUpdated = 0;
    protected TimestampInObject timestampInObject;

    public UpdateAllWithTimestampLockingTest() {
        this.setDescription("Test performing an UpdateAllQuery using an object with a TimestampLockingPolicy");
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.timestampInObject = (TimestampInObject)this.getSession().readObject(TimestampInObject.class, new ExpressionBuilder().get("value").equal((Object)TimestampInObject.example1().value));
        UpdateAllWithTimestampLockingTest.assertNotNull((Object)this.timestampInObject);
        UpdateAllQuery query = new UpdateAllQuery(TimestampInObject.class);
        query.setShouldDeferExecutionInUOW(false);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("id").equal(this.timestampInObject.id);
        query.setSelectionCriteria(expression);
        query.addUpdate(builder.get("value"), (Object)"Updated Object");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.rowsUpdated = (Integer)uow.executeQuery((DatabaseQuery)query);
        uow.commit();
    }

    public void verify() {
        if (this.rowsUpdated != 1) {
            throw new TestErrorException(this.rowsUpdated + " rows were updated, expected 1 row to be updated");
        }
        UpdateAllWithTimestampLockingTest.assertNotNull((Object)this.timestampInObject);
        this.timestampInObject.verify((TestCase)this);
    }
}

