/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.optimisticlocking;

import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.optimisticlocking.AnimalProject;
import org.eclipse.persistence.testing.models.optimisticlocking.AnimalTableCreator;
import org.eclipse.persistence.testing.models.optimisticlocking.ChangedRow;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsoleProject;
import org.eclipse.persistence.testing.models.optimisticlocking.GamesConsoleTableCreator;
import org.eclipse.persistence.testing.models.optimisticlocking.ListHolder;
import org.eclipse.persistence.testing.models.optimisticlocking.ListItem;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInAggregateObject;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInCache;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInObject;
import org.eclipse.persistence.testing.models.optimisticlocking.ObjectVersion;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBand;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBandProject;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBandTableCreator;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInAggregateObject;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInCache;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInObject;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampVersion;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class OptimisticLockingSystem
extends TestSystem {
    public void addDescriptors(DatabaseSession session) {
        Vector<RelationalDescriptor> descriptors = new Vector<RelationalDescriptor>();
        descriptors.addElement(LockInCache.descriptor());
        descriptors.addElement(LockInObject.descriptor());
        descriptors.addElement(TimestampInCache.descriptor());
        descriptors.addElement(TimestampInObject.descriptor());
        descriptors.addElement(TimestampVersion.descriptor());
        descriptors.addElement(TimestampInAggregateObject.descriptor());
        descriptors.addElement(ObjectVersion.descriptor());
        descriptors.addElement(LockInAggregateObject.descriptor());
        descriptors.addElement(ChangedRow.descriptor());
        descriptors.addElement(ListItem.descriptor());
        descriptors.addElement(ListHolder.descriptor());
        session.addDescriptors(descriptors);
        session.addDescriptors((Project)new RockBandProject());
        session.addDescriptors((Project)new AnimalProject());
        session.addDescriptors((Project)new GamesConsoleProject());
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)LockInCache.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)LockInObject.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)TimestampInObject.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)TimestampInAggregateObject.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)LockInAggregateObject.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)TimestampInCache.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ChangedRow.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ListItem.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)ListHolder.tableDefinition());
        schemaManager.createSequences();
        new RockBandTableCreator().replaceTables(session);
        new AnimalTableCreator().replaceTables(session);
        new GamesConsoleTableCreator().replaceTables(session);
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        Object instance = LockInCache.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache example1");
        instance = LockInCache.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache example2");
        instance = LockInCache.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache example3");
        instance = LockInObject.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Object example1");
        instance = LockInObject.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Object example2");
        instance = LockInObject.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Object example3");
        instance = TimestampInCache.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache TS example1");
        instance = TimestampInCache.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache TS example2");
        instance = TimestampInCache.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Cache TS example3");
        instance = TimestampInObject.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Object TS example1");
        instance = TimestampInObject.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Object TS example2");
        instance = TimestampInObject.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Object TS example3");
        instance = ChangedRow.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "ChangedRow example1");
        instance = ChangedRow.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "ChangedRow example2");
        instance = ChangedRow.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "ChangedRow example3");
        instance = TimestampInAggregateObject.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Aggregate Object TS example1");
        instance = TimestampInAggregateObject.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Aggregate Object TS example2");
        instance = TimestampInAggregateObject.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Aggregate Object TS example3");
        instance = LockInAggregateObject.example1();
        session.writeObject(instance);
        manager.registerObject(instance, "Lock Object TS example1");
        instance = LockInAggregateObject.example2();
        session.writeObject(instance);
        manager.registerObject(instance, "Lock Object TS example2");
        instance = LockInAggregateObject.example3();
        session.writeObject(instance);
        manager.registerObject(instance, "Lock Object TS example3");
        UnitOfWork uow = session.acquireUnitOfWork();
        instance = uow.registerObject((Object)RockBand.example1());
        manager.registerObject(instance, "RockBand example1");
        instance = uow.registerObject((Object)RockBand.example2());
        manager.registerObject(instance, "RockBand example2");
        uow.commit();
    }
}

