/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.plsql;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleArrayType;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.plsql.Address;
import org.eclipse.persistence.testing.models.jpa.plsql.Employee;
import org.eclipse.persistence.testing.models.jpa.plsql.Phone;

public class PLSQLTestSuite
extends JUnitTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite("PLSQLTests");
        suite.addTest((Test)new PLSQLTestSuite("testSetup"));
        suite.addTest((Test)new PLSQLTestSuite("testSimpleProcedure"));
        suite.addTest((Test)new PLSQLTestSuite("testSimpleFunction"));
        suite.addTest((Test)new PLSQLTestSuite("testRecordOut"));
        suite.addTest((Test)new PLSQLTestSuite("testTableOut"));
        suite.addTest((Test)new PLSQLTestSuite("testEmpRecordInOut"));
        suite.addTest((Test)new PLSQLTestSuite("testConsultant"));
        suite.addTest((Test)new PLSQLTestSuite("testOracleTypeProcessing"));
        return suite;
    }

    public PLSQLTestSuite(String name) {
        super(name);
    }

    public String getPersistenceUnitName() {
        return "plsql";
    }

    public void testSetup() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            PLSQLTestSuite.warning((String)"This test can only be run on Oracle.");
            return;
        }
        this.createTables((DatabaseSession)this.getDatabaseSession());
    }

    public void createTables(DatabaseSession session) {
        try {
            session.executeNonSelectingSQL("DROP TABLE PLSQL_ADDRESS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            session.executeNonSelectingSQL("DROP TABLE PLSQL_CONSULTANT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.executeNonSelectingSQL("CREATE TABLE PLSQL_ADDRESS (ADDRESS_ID NUMBER(10) NOT NULL, STREET_NUM NUMBER(10), STREET VARCHAR2(30), CITY VARCHAR2(30), STATE VARCHAR2(30), PRIMARY KEY (ADDRESS_ID))");
        session.executeNonSelectingSQL("INSERT INTO PLSQL_ADDRESS (ADDRESS_ID, CITY) values (1234, 'Ottawa')");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_SIMPLE_IN(P_VARCHAR IN VARCHAR2 DEFAULT '', P_BOOLEAN IN BOOLEAN, P_BINARY_INTEGER IN BINARY_INTEGER, P_DEC IN DEC, P_INT IN INT, P_NATURAL IN NATURAL, P_NATURALN IN NATURALN, P_PLS_INTEGER IN PLS_INTEGER, P_POSITIVE IN POSITIVE, P_POSITIVEN IN POSITIVEN, P_SIGNTYPE IN SIGNTYPE, P_NUMBER IN NUMBER) AS BEGIN NULL; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_SIMPLE_IN_DEFAULTS(P_VARCHAR IN VARCHAR2 DEFAULT '', P_BOOLEAN IN BOOLEAN DEFAULT TRUE, P_BINARY_INTEGER IN BINARY_INTEGER DEFAULT 0, P_DEC IN DEC DEFAULT 0, P_INT IN INT DEFAULT 0, P_NATURAL IN NATURAL DEFAULT 1, P_NATURALN IN NATURALN DEFAULT 1, P_PLS_INTEGER IN PLS_INTEGER DEFAULT 0, P_POSITIVE IN POSITIVE DEFAULT 1, P_POSITIVEN IN POSITIVEN DEFAULT 1, P_SIGNTYPE IN SIGNTYPE DEFAULT 1, P_NUMBER IN NUMBER DEFAULT 0) AS BEGIN NULL; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_SIMPLE_OUT(P_VARCHAR OUT VARCHAR2, P_BOOLEAN OUT BOOLEAN, P_BINARY_INTEGER OUT BINARY_INTEGER, P_DEC OUT DEC, P_INT OUT INT, P_NATURAL OUT NATURAL, P_PLS_INTEGER OUT PLS_INTEGER, P_POSITIVE OUT POSITIVE, P_SIGNTYPE OUT SIGNTYPE, P_NUMBER OUT NUMBER) AS BEGIN P_VARCHAR := 'varchar'; P_BOOLEAN := true; P_BINARY_INTEGER := 123; P_DEC := 1; P_INT := 1; P_NATURAL := 1; P_PLS_INTEGER := 1; P_POSITIVE := 1; P_SIGNTYPE := 1; P_NUMBER := 123; \nEND;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_SIMPLE_INOUT(P_VARCHAR IN OUT VARCHAR2, P_BOOLEAN IN OUT BOOLEAN, P_BINARY_INTEGER IN OUT BINARY_INTEGER, P_DEC IN OUT DEC, P_INT IN OUT INT, P_NATURAL IN OUT NATURAL, P_NATURALN IN OUT NATURALN, P_PLS_INTEGER IN OUT PLS_INTEGER, P_POSITIVE IN OUT POSITIVE, P_POSITIVEN IN OUT POSITIVEN, P_SIGNTYPE IN OUT SIGNTYPE, P_NUMBER IN OUT NUMBER) AS BEGIN NULL; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_IN(P_ADDRESS IN PLSQL_ADDRESS%ROWTYPE) AS BEGIN NULL; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_IN_DATA(P_ADDRESS IN PLSQL_ADDRESS%ROWTYPE, P_LOCAL IN VARCHAR2) AS BEGIN NULL; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_OUT(P_ADDRESS OUT PLSQL_ADDRESS%ROWTYPE) AS BEGIN P_ADDRESS.ADDRESS_ID := 1234; P_ADDRESS.STREET_NUM := 17; P_ADDRESS.STREET := 'Bank'; P_ADDRESS.CITY := 'Ottawa'; P_ADDRESS.STATE := 'ON';  END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_OUT_DATA(P_ADDRESS OUT PLSQL_ADDRESS%ROWTYPE, P_LOCAL OUT VARCHAR2) AS BEGIN P_ADDRESS.ADDRESS_ID := 1234; P_ADDRESS.STREET_NUM := 17; P_ADDRESS.STREET := 'Bank'; P_ADDRESS.CITY := 'Ottawa'; P_ADDRESS.STATE := 'ON'; P_LOCAL := 'Local';  END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_INOUT(P_ADDRESS IN OUT PLSQL_ADDRESS%ROWTYPE) AS BEGIN P_ADDRESS.ADDRESS_ID := 1234; P_ADDRESS.STREET_NUM := 17; P_ADDRESS.STREET := 'Bank'; P_ADDRESS.CITY := 'Ottawa'; P_ADDRESS.STATE := 'ON';  END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE PROCEDURE PLSQL_ADDRESS_INOUT_DATA(P_ADDRESS IN OUT PLSQL_ADDRESS%ROWTYPE, P_LOCAL IN OUT VARCHAR2) AS BEGIN P_ADDRESS.ADDRESS_ID := 1234; P_ADDRESS.STREET_NUM := 17; P_ADDRESS.STREET := 'Bank'; P_ADDRESS.CITY := 'Ottawa'; P_ADDRESS.STATE := 'ON'; P_LOCAL := 'Local';  END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE FUNCTION PLSQL_SIMPLE_IN_FUNC(P_VARCHAR IN VARCHAR2, P_BOOLEAN IN BOOLEAN, P_BINARY_INTEGER IN BINARY_INTEGER, P_DEC IN DEC, P_INT IN INT, P_NATURAL IN NATURAL, P_NATURALN IN NATURALN, P_PLS_INTEGER IN PLS_INTEGER, P_POSITIVE IN POSITIVE, P_POSITIVEN IN POSITIVEN, P_SIGNTYPE IN SIGNTYPE, P_NUMBER IN NUMBER) RETURN BOOLEAN AS BEGIN RETURN TRUE; END;");
        session.executeNonSelectingSQL("CREATE OR REPLACE FUNCTION PLSQL_ADDRESS_OUT_FUNC RETURN PLSQL_ADDRESS%ROWTYPE AS  P_ADDRESS PLSQL_ADDRESS%ROWTYPE; BEGIN P_ADDRESS.ADDRESS_ID := 1234; P_ADDRESS.STREET_NUM := 17; P_ADDRESS.STREET := 'Bank'; P_ADDRESS.CITY := 'Ottawa'; P_ADDRESS.STATE := 'ON';  RETURN P_ADDRESS; END;");
        try {
            session.executeNonSelectingSQL("DROP TYPE PLSQL_P_PLSQL_EMP_REC FORCE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            session.executeNonSelectingSQL("DROP TYPE PLSQL_P_PLSQL_ADDRESS_REC FORCE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            session.executeNonSelectingSQL("DROP TYPE PLSQL_P_PLSQL_PHONE_REC FORCE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_ADDRESS_REC AS OBJECT (ADDRESS_ID NUMBER(10), STREET_NUM NUMBER(10), STREET VARCHAR2(30), CITY VARCHAR2(30), STATE VARCHAR2(2))");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_PHONE_REC AS OBJECT (AREA_CODE VARCHAR2(3), P_NUM VARCHAR2(7))");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_PHONE_LIST AS VARRAY(30) OF PLSQL_P_PLSQL_PHONE_REC");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_EMP_REC AS OBJECT (EMP_ID NUMBER(10), NAME VARCHAR2(30), ACTIVE NUMBER(1), ADDRESS PLSQL_P_PLSQL_ADDRESS_REC, PHONES PLSQL_P_PLSQL_PHONE_LIST)");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_CITY_LIST AS VARRAY(255) OF VARCHAR2(100)");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_ADDRESS_LIST AS VARRAY(255) OF PLSQL_P_PLSQL_ADDRESS_REC");
        session.executeNonSelectingSQL("CREATE OR REPLACE TYPE PLSQL_P_PLSQL_EMP_LIST AS VARRAY(255) OF PLSQL_P_PLSQL_EMP_REC");
        session.executeNonSelectingSQL("CREATE OR REPLACE PACKAGE PLSQL_P AS \nTYPE PLSQL_ADDRESS_REC IS RECORD (ADDRESS_ID NUMBER(10), STREET_NUM NUMBER(10), STREET VARCHAR2(30), CITY VARCHAR2(30), STATE VARCHAR2(2)); \nTYPE PLSQL_ADDRESS_CUR IS REF CURSOR RETURN PLSQL_ADDRESS%ROWTYPE; \nTYPE PLSQL_ADDRESS_REC_CUR IS REF CURSOR RETURN PLSQL_ADDRESS_REC; \nTYPE PLSQL_PHONE_REC IS RECORD (AREA_CODE VARCHAR2(3), P_NUM VARCHAR2(7)); \nTYPE PLSQL_PHONE_LIST IS TABLE OF PLSQL_PHONE_REC INDEX BY BINARY_INTEGER; \nTYPE PLSQL_EMP_REC IS RECORD (EMP_ID NUMBER(10), NAME VARCHAR2(30), ACTIVE BOOLEAN, ADDRESS PLSQL_ADDRESS_REC, PHONES PLSQL_PHONE_LIST); \nTYPE PLSQL_CITY_LIST IS TABLE OF VARCHAR2(100) INDEX BY BINARY_INTEGER; \nTYPE PLSQL_ADDRESS_LIST IS TABLE OF PLSQL_ADDRESS_REC INDEX BY BINARY_INTEGER; \nTYPE PLSQL_EMP_LIST IS TABLE OF PLSQL_EMP_REC INDEX BY BINARY_INTEGER; \nPROCEDURE PLSQL_CITY_LIST_IN(P_CITY_LIST IN PLSQL_CITY_LIST, P_CITY IN VARCHAR2); \nPROCEDURE PLSQL_CITY_LIST_OUT(P_CITY_LIST OUT PLSQL_CITY_LIST, P_CITY OUT VARCHAR2); \nPROCEDURE PLSQL_CITY_LIST_INOUT(P_CITY_LIST IN OUT PLSQL_CITY_LIST, P_CITY IN OUT VARCHAR2); \nPROCEDURE PLSQL_ADDRESS_LIST_IN(P_ADDRESS_LIST IN PLSQL_ADDRESS_LIST, P_CITY IN VARCHAR2); \nPROCEDURE PLSQL_ADDRESS_LIST_OUT(P_ADDRESS_LIST OUT PLSQL_ADDRESS_LIST, P_CITY OUT VARCHAR2); \nPROCEDURE PLSQL_ADDRESS_LIST_INOUT(P_ADDRESS_LIST IN OUT PLSQL_ADDRESS_LIST, P_CITY IN OUT VARCHAR2); \nPROCEDURE PLSQL_EMP_LIST_IN(P_EMP_LIST IN PLSQL_EMP_LIST, P_CITY IN VARCHAR2); \nPROCEDURE PLSQL_EMP_LIST_OUT(P_EMP_LIST OUT PLSQL_EMP_LIST, P_CITY OUT VARCHAR2); \nPROCEDURE PLSQL_EMP_LIST_INOUT(P_EMP_LIST IN OUT PLSQL_EMP_LIST, P_CITY IN OUT VARCHAR2); \nPROCEDURE PLSQL_EMP_IN(P_EMP IN PLSQL_EMP_REC, P_CITY IN VARCHAR2); \nPROCEDURE PLSQL_EMP_OUT(P_EMP OUT PLSQL_EMP_REC, P_CITY OUT VARCHAR2); \nPROCEDURE PLSQL_EMP_INOUT(P_EMP IN OUT PLSQL_EMP_REC, P_CITY IN OUT VARCHAR2); \nPROCEDURE PLSQL_ADDRESS_CUR_OUT(P_ADDRESS OUT PLSQL_ADDRESS_CUR); \nPROCEDURE PLSQL_ADDRESS_REC_CUR_OUT(P_ADDRESS OUT PLSQL_ADDRESS_REC_CUR); \nEND PLSQL_P; \n");
        session.executeNonSelectingSQL("CREATE OR REPLACE PACKAGE BODY PLSQL_P AS \nPROCEDURE PLSQL_CITY_LIST_IN(P_CITY_LIST IN PLSQL_CITY_LIST, P_CITY IN VARCHAR2) AS \nBEGIN \nNULL; \nEND PLSQL_CITY_LIST_IN; \nPROCEDURE PLSQL_CITY_LIST_OUT(P_CITY_LIST OUT PLSQL_CITY_LIST, P_CITY OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; \nP_CITY_LIST(1) := 'Ottawa'; \nEND PLSQL_CITY_LIST_OUT; \nPROCEDURE PLSQL_CITY_LIST_INOUT(P_CITY_LIST IN OUT PLSQL_CITY_LIST, P_CITY IN OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; \nP_CITY_LIST(1) := 'Ottawa'; \nEND PLSQL_CITY_LIST_INOUT; \nPROCEDURE PLSQL_ADDRESS_LIST_IN(P_ADDRESS_LIST IN PLSQL_ADDRESS_LIST, P_CITY IN VARCHAR2) AS \nBEGIN \nNULL; \nEND PLSQL_ADDRESS_LIST_IN; \nPROCEDURE PLSQL_ADDRESS_LIST_OUT(P_ADDRESS_LIST OUT PLSQL_ADDRESS_LIST, P_CITY OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; END PLSQL_ADDRESS_LIST_OUT; \nPROCEDURE PLSQL_ADDRESS_LIST_INOUT(P_ADDRESS_LIST IN OUT PLSQL_ADDRESS_LIST, P_CITY IN OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; \nEND PLSQL_ADDRESS_LIST_INOUT; \nPROCEDURE PLSQL_EMP_LIST_IN(P_EMP_LIST IN PLSQL_EMP_LIST, P_CITY IN VARCHAR2) AS \nBEGIN \nNULL; \nEND PLSQL_EMP_LIST_IN; \nPROCEDURE PLSQL_EMP_LIST_OUT(P_EMP_LIST OUT PLSQL_EMP_LIST, P_CITY OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; END PLSQL_EMP_LIST_OUT; \nPROCEDURE PLSQL_EMP_LIST_INOUT(P_EMP_LIST IN OUT PLSQL_EMP_LIST, P_CITY IN OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; END PLSQL_EMP_LIST_INOUT; \nPROCEDURE PLSQL_EMP_IN(P_EMP IN PLSQL_EMP_REC, P_CITY IN VARCHAR2) AS \nBEGIN \nNULL; \nEND PLSQL_EMP_IN; \nPROCEDURE PLSQL_EMP_OUT(P_EMP OUT PLSQL_EMP_REC, P_CITY OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; END PLSQL_EMP_OUT; \nPROCEDURE PLSQL_EMP_INOUT(P_EMP IN OUT PLSQL_EMP_REC, P_CITY IN OUT VARCHAR2) AS \nBEGIN \nP_CITY := 'Nepean'; \nEND PLSQL_EMP_INOUT; \nPROCEDURE PLSQL_ADDRESS_CUR_OUT(P_ADDRESS OUT PLSQL_ADDRESS_CUR) AS \nBEGIN \nOPEN P_ADDRESS FOR SELECT * FROM PLSQL_ADDRESS; \nEND PLSQL_ADDRESS_CUR_OUT; \nPROCEDURE PLSQL_ADDRESS_REC_CUR_OUT(P_ADDRESS OUT PLSQL_ADDRESS_REC_CUR) AS \nBEGIN \nOPEN P_ADDRESS FOR SELECT * FROM PLSQL_ADDRESS; \nEND PLSQL_ADDRESS_REC_CUR_OUT; \nEND PLSQL_P; \n");
        session.executeNonSelectingSQL("CREATE TABLE PLSQL_CONSULTANT (EMP_ID NUMBER(10), NAME VARCHAR2(30), ACTIVE NUMBER(1), ADDRESS PLSQL_P_PLSQL_ADDRESS_REC, PHONES PLSQL_P_PLSQL_PHONE_LIST, PRIMARY KEY (EMP_ID))");
    }

    public void testSimpleProcedure() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("PLSQL_SIMPLE_IN_DEFAULTS");
            query.setParameter("P_VARCHAR", (Object)"test");
            query.executeUpdate();
            query = em.createNamedQuery("PLSQL_SIMPLE_IN_DEFAULTS");
            query.setParameter("P_BOOLEAN", (Object)true);
            query.executeUpdate();
            query = em.createNamedQuery("PLSQL_SIMPLE_IN_DEFAULTS");
            query.setParameter("P_VARCHAR", (Object)"test");
            query.setParameter("P_BOOLEAN", (Object)true);
            query.setParameter("P_BINARY_INTEGER", (Object)1);
            query.setParameter("P_DEC", (Object)1);
            query.setParameter("P_INT", (Object)1);
            query.setParameter("P_NATURAL", (Object)1);
            query.setParameter("P_NATURALN", (Object)1);
            query.setParameter("P_PLS_INTEGER", (Object)1);
            query.setParameter("P_POSITIVE", (Object)1);
            query.setParameter("P_POSITIVEN", (Object)1);
            query.setParameter("P_SIGNTYPE", (Object)1);
            query.setParameter("P_NUMBER", (Object)1);
            query.executeUpdate();
            query.executeUpdate();
            query = em.createNamedQuery("PLSQL_SIMPLE_IN_DEFAULTS");
            query.setParameter("P_BOOLEAN", (Object)true);
            query.executeUpdate();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleFunction() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("PLSQL_SIMPLE_IN_FUNC");
            query.setParameter("P_VARCHAR", (Object)"test");
            query.setParameter("P_BOOLEAN", (Object)true);
            query.setParameter("P_BINARY_INTEGER", (Object)1);
            query.setParameter("P_DEC", (Object)1);
            query.setParameter("P_INT", (Object)1);
            query.setParameter("P_NATURAL", (Object)1);
            query.setParameter("P_NATURALN", (Object)1);
            query.setParameter("P_PLS_INTEGER", (Object)1);
            query.setParameter("P_POSITIVE", (Object)1);
            query.setParameter("P_POSITIVEN", (Object)1);
            query.setParameter("P_SIGNTYPE", (Object)1);
            query.setParameter("P_NUMBER", (Object)1);
            int result = (Integer)query.getSingleResult();
            if (result != 1) {
                PLSQLTestSuite.fail((String)"Incorrect result.");
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecordOut() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("PLSQL_ADDRESS_OUT");
            Object result = query.getSingleResult();
            if (!(result instanceof Address)) {
                PLSQLTestSuite.fail((String)("Incorrect result:" + result));
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmpRecordInOut() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("PLSQL_EMP_INOUT");
            Employee employee = new Employee();
            employee.setId(new BigDecimal(1234));
            employee.setName("Bob");
            employee.setAddress(new Address());
            employee.getAddress().setId(new BigDecimal(1234));
            employee.getAddress().setCity("Ottawa");
            employee.getAddress().setNumber(Integer.valueOf(12345));
            employee.getAddress().setState("ON");
            employee.getAddress().setStreet("Bank");
            Phone phone = new Phone();
            phone.setAreaCode("613");
            phone.setNumber("1234567");
            employee.getPhones().add(phone);
            query.setParameter("P_EMP", (Object)employee);
            Object[] result = (Object[])query.getSingleResult();
            if (!(result[0] instanceof Employee)) {
                PLSQLTestSuite.fail((String)("Incorrect result:" + result));
            }
            this.compareObjects(employee, result[0]);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableOut() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("PLSQL_ADDRESS_LIST_OUT");
            Object[] result = (Object[])query.getSingleResult();
            if (!(result[0] instanceof List)) {
                PLSQLTestSuite.fail((String)("Incorrect result:" + result));
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testConsultant() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("Select c from Consultant c").getResultList();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOracleTypeProcessing() {
        if (!PLSQLTestSuite.getServerSession().getPlatform().isOracle()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("TEST_ORACLE_TYPES");
            PLSQLTestSuite.assertNotNull((String)"EntityManager could not create query [TEST_ORACLE_TYPES]", (Object)query);
            PLSQLTestSuite.assertTrue((String)("Expected EJBQueryImpl but was [" + query.getClass().getName() + "]"), (boolean)(query instanceof EJBQueryImpl));
            DatabaseCall call = ((EJBQueryImpl)query).getDatabaseQuery().getCall();
            PLSQLTestSuite.assertNotNull((String)"The DatabaseCall was not set on the query", (Object)call);
            PLSQLTestSuite.assertTrue((String)("Expected PLSQLStoredProcedureCall but was [" + call.getClass().getName() + "]"), (boolean)(call instanceof PLSQLStoredProcedureCall));
            PLSQLStoredProcedureCall plsqlCall = (PLSQLStoredProcedureCall)call;
            List args = plsqlCall.getArguments();
            PLSQLTestSuite.assertTrue((String)("Expected 2 arguments, but was [" + args.size() + "]"), (args.size() == 2 ? 1 : 0) != 0);
            boolean foundINArg = false;
            boolean foundOUTArg = false;
            for (PLSQLargument arg : args) {
                if (arg.name.equals("P_IN")) {
                    foundINArg = true;
                    PLSQLTestSuite.assertNotNull((String)"databaseType for arg P_IN is null", (Object)arg.databaseType);
                    PLSQLTestSuite.assertTrue((String)("Expected arg P_IN to be an OracleArrayType, but was [" + arg.databaseType.getClass().getName() + "]"), (boolean)(arg.databaseType instanceof OracleArrayType));
                    OracleArrayType arrayType = (OracleArrayType)arg.databaseType;
                    PLSQLTestSuite.assertTrue((String)("Expected arg P_IN to have databaseType set with type name VARRAY_NUMERO_UNO, but was [" + arrayType.getTypeName() + "]"), (boolean)arrayType.getTypeName().equals("VARRAY_NUMERO_UNO"));
                    PLSQLTestSuite.assertNotNull((String)"Expected VARRAY_NUMERO_UNO to have nested type VARCHAR, but was null", (Object)arrayType.getNestedType());
                    PLSQLTestSuite.assertTrue((String)("Expected VARRAY_NUMERO_UNO to have nested type VARCHAR, but was [" + arrayType.getNestedType().getTypeName() + "]"), (boolean)arrayType.getNestedType().getTypeName().equals("VARCHAR"));
                    continue;
                }
                if (arg.name.equals("P_OUT")) {
                    foundOUTArg = true;
                    PLSQLTestSuite.assertNotNull((String)"databaseType for arg P_OUT is null", (Object)arg.databaseType);
                    PLSQLTestSuite.assertTrue((String)("Expected arg P_OUT to be an OracleObjectType, but was [" + arg.databaseType.getClass().getName() + "]"), (boolean)(arg.databaseType instanceof OracleObjectType));
                    OracleObjectType objectType = (OracleObjectType)arg.databaseType;
                    PLSQLTestSuite.assertTrue((String)("Expected arg P_OUT to have databaseType set with type name OBJECT_NUMERO_DOS, but was [" + objectType.getTypeName() + "]"), (boolean)objectType.getTypeName().equals("OBJECT_NUMERO_DOS"));
                    PLSQLTestSuite.assertTrue((String)("Expected OBJECT_NUMERO_DOS to have 2 fields, but was [" + objectType.getFields().size() + "]"), (objectType.getFields().size() == 2 ? 1 : 0) != 0);
                    for (String key : objectType.getFields().keySet()) {
                        DatabaseType dbType = (DatabaseType)objectType.getFields().get(key);
                        if (key.equals("OO_FLD1")) {
                            PLSQLTestSuite.assertTrue((String)("Expected field OO_FLD1 to have databaseType NUMERIC, but was [" + dbType.getTypeName() + "]"), (boolean)dbType.getTypeName().equals("NUMERIC"));
                            continue;
                        }
                        if (key.equals("OO_FLD2")) {
                            PLSQLTestSuite.assertTrue((String)("Expected field OO_FLD2 to have databaseType NUMERIC, but was [" + dbType.getTypeName() + "]"), (boolean)dbType.getTypeName().equals("NUMERIC"));
                            continue;
                        }
                        PLSQLTestSuite.fail((String)("Expected OBJECT_NUMERO_DOS to have fields OO_FLD1 and OO_FLD2 but encountered field [" + key + "]"));
                    }
                    continue;
                }
                PLSQLTestSuite.fail((String)("Expected arg name to be one of P_IN or P_OUT, but was [" + arg.name + "]"));
            }
            PLSQLTestSuite.assertTrue((String)"IN arg P_IN was not processed", (boolean)foundINArg);
            PLSQLTestSuite.assertTrue((String)"OUT arg P_OUT was not processed", (boolean)foundOUTArg);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }
}

