/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inherited;

import jakarta.persistence.EntityManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.Canadian;
import org.eclipse.persistence.testing.models.jpa.inherited.Certification;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.inherited.SerialNumber;
import org.eclipse.persistence.testing.models.jpa.inherited.TelephoneNumber;

public class EmbeddableSuperclassJunitTest
extends JUnitTestCase {
    private static Date m_savedDate;
    private static Integer m_alpineId;
    private static Integer m_alpineId1;
    private static Integer m_alpineId2;
    private static Integer m_canadianId;
    private static Integer m_beerConsumerId1;
    private static Integer m_beerConsumerId2;
    private static Integer m_certId1;
    private static Integer m_certId2;
    private static Integer m_certId3;
    private static Integer m_certId4;
    private static String m_canadianProperty1;
    private static String m_canadianProperty2;

    public EmbeddableSuperclassJunitTest() {
    }

    public EmbeddableSuperclassJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmbeddableSuperclassJunitTest");
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testSetup"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testExistenceCheckingSetting"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testCreateBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testCreateAlpine"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testCreateCanadian"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testCreateCertifications"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testCreateTelephoneNumbers"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testReadBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testReadAlpine"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testReadCanadian"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testInsertNewAlpine"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testInsertNewAlpineAndModifyOrderOfExistingAlpines"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateAlpine"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateAlpineThroughBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateCanadian"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateCanadianThroughBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateCertifications"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testUpdateTelephoneNumberThroughBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testShuffleTelephoneNumbersOnBeerConsumers"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testDeleteAlpine"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testDeleteCanadian"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testDeleteBeerConsumer"));
        suite.addTest((Test)new EmbeddableSuperclassJunitTest("testOptimisticLockingTest"));
        return suite;
    }

    public void testSetup() {
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testExistenceCheckingSetting() {
        ServerSession session = JUnitTestCase.getServerSession();
        ClassDescriptor canadianDescriptor = session.getDescriptor(Canadian.class);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Canadian existence checking was incorrect", (canadianDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 4 ? 1 : 0) != 0);
        ClassDescriptor alpineDescriptor = session.getDescriptor(Alpine.class);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Alpine existence checking was incorrect", (alpineDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 3 ? 1 : 0) != 0);
        ClassDescriptor blueDescriptor = session.getDescriptor(Blue.class);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Blue existence checking was incorrect", (blueDescriptor.getQueryManager().getDoesExistQuery().getExistencePolicy() == 3 ? 1 : 0) != 0);
    }

    public void testCreateAlpine() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
            SerialNumber serialNumber1 = new SerialNumber();
            em.persist((Object)serialNumber1);
            Alpine alpine1 = new Alpine(serialNumber1);
            alpine1.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)21));
            alpine1.setAlcoholContent((Object)5.0);
            alpine1.setBeerConsumer(beerConsumer);
            alpine1.setClassification(Alpine.Classification.BITTER);
            alpine1.addInspectionDate(new Date(System.currentTimeMillis()));
            em.persist((Object)alpine1);
            m_alpineId = (Integer)alpine1.getId();
            SerialNumber serialNumber2 = new SerialNumber();
            em.persist((Object)serialNumber2);
            Alpine alpine2 = new Alpine(serialNumber2);
            alpine2.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)17));
            alpine2.setAlcoholContent((Object)5.5);
            alpine2.setBeerConsumer(beerConsumer);
            alpine2.setClassification(Alpine.Classification.STRONG);
            em.persist((Object)alpine2);
            m_alpineId1 = (Integer)alpine2.getId();
            SerialNumber serialNumber3 = new SerialNumber();
            em.persist((Object)serialNumber3);
            Alpine alpine3 = new Alpine(serialNumber3);
            alpine3.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)22));
            alpine3.setAlcoholContent((Object)4.5);
            alpine3.setBeerConsumer(beerConsumer);
            alpine3.setClassification(Alpine.Classification.SWEET);
            em.persist((Object)alpine3);
            m_alpineId2 = (Integer)alpine3.getId();
            this.commitTransaction(em);
            this.clearCache();
            Alpine alpineReadOut = (Alpine)this.createEntityManager().find(Alpine.class, (Object)m_alpineId);
            EmbeddableSuperclassJunitTest.assertTrue((String)"Alpine1 object is not same as readout", (boolean)alpineReadOut.equals((Object)alpine1));
            Alpine alpineReadOut1 = (Alpine)this.createEntityManager().find(Alpine.class, (Object)m_alpineId1);
            EmbeddableSuperclassJunitTest.assertTrue((String)"Alpine2 object is not same as readout", (boolean)alpineReadOut1.equals((Object)alpine2));
            Alpine alpineReadOut2 = (Alpine)this.createEntityManager().find(Alpine.class, (Object)m_alpineId2);
            EmbeddableSuperclassJunitTest.assertTrue((String)"Alpine3 object is not same as readout", (boolean)alpineReadOut2.equals((Object)alpine3));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testCreateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer1 = new BeerConsumer();
            beerConsumer1.setName("Guy Pelletier");
            em.persist((Object)beerConsumer1);
            m_beerConsumerId1 = beerConsumer1.getId();
            BeerConsumer beerConsumer2 = new BeerConsumer();
            beerConsumer2.setName("Tom Ware");
            em.persist((Object)beerConsumer2);
            m_beerConsumerId2 = beerConsumer2.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testCreateCanadian() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            Canadian canadian1 = new Canadian();
            m_savedDate = Calendar.getInstance().getTime();
            canadian1.setBornOnDate(m_savedDate);
            canadian1.setAlcoholContent((Object)5.0);
            canadian1.setBeerConsumer(beerConsumer);
            canadian1.setFlavor(Canadian.Flavor.LAGER);
            canadian1.getProperties().put(m_canadianProperty1, new Date(System.currentTimeMillis()));
            em.persist((Object)canadian1);
            m_canadianId = (Integer)canadian1.getId();
            Canadian canadian2 = new Canadian();
            canadian2.setBornOnDate(Calendar.getInstance().getTime());
            canadian2.setAlcoholContent((Object)5.5);
            canadian2.setFlavor(Canadian.Flavor.ICE);
            canadian2.setBeerConsumer(beerConsumer);
            em.persist((Object)canadian2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testCreateCertifications() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Certification cert1 = new Certification();
            cert1.setDescription("Certification 1");
            em.persist((Object)cert1);
            m_certId1 = cert1.getId();
            Certification cert2 = new Certification();
            cert2.setDescription("Certification 2");
            em.persist((Object)cert2);
            m_certId2 = cert2.getId();
            Certification cert3 = new Certification();
            cert3.setDescription("Certification 3");
            em.persist((Object)cert3);
            m_certId3 = cert3.getId();
            Certification cert4 = new Certification();
            cert4.setDescription("Certification 4");
            em.persist((Object)cert4);
            m_certId4 = cert4.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testCreateTelephoneNumbers() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer1 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            TelephoneNumber telephoneNumber1 = new TelephoneNumber();
            telephoneNumber1.setType("Home");
            telephoneNumber1.setAreaCode("975");
            telephoneNumber1.setNumber("1234567");
            beerConsumer1.addTelephoneNumber(telephoneNumber1);
            TelephoneNumber telephoneNumber2 = new TelephoneNumber();
            telephoneNumber2.setType("Cell");
            telephoneNumber2.setAreaCode("975");
            telephoneNumber2.setNumber("7654321");
            beerConsumer1.addTelephoneNumber(telephoneNumber2);
            BeerConsumer beerConsumer2 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
            TelephoneNumber telephoneNumber3 = new TelephoneNumber();
            telephoneNumber3.setType("Home");
            telephoneNumber3.setAreaCode("555");
            telephoneNumber3.setNumber("5555555");
            beerConsumer2.addTelephoneNumber(telephoneNumber3);
            TelephoneNumber telephoneNumber4 = new TelephoneNumber();
            telephoneNumber4.setType("Cell");
            telephoneNumber4.setAreaCode("555");
            telephoneNumber4.setNumber("3331010");
            beerConsumer2.addTelephoneNumber(telephoneNumber4);
            TelephoneNumber telephoneNumber5 = new TelephoneNumber();
            telephoneNumber5.setType("Work");
            telephoneNumber5.setAreaCode("999");
            telephoneNumber5.setNumber("8648363");
            beerConsumer2.addTelephoneNumber(telephoneNumber5);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testDeleteAlpine() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Alpine.class, (Object)m_alpineId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error deleting an Alpine beer", (em.find(Alpine.class, (Object)m_alpineId) == null ? 1 : 0) != 0);
    }

    public void testDeleteBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(BeerConsumer.class, (Object)m_beerConsumerId1));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error deleting a BeerConsumer", (em.find(BeerConsumer.class, (Object)m_beerConsumerId1) == null ? 1 : 0) != 0);
    }

    public void testDeleteCanadian() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Canadian.class, (Object)m_canadianId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error deleting a Canadian beer", (em.find(Canadian.class, (Object)m_canadianId) == null ? 1 : 0) != 0);
    }

    public void testInsertNewAlpine() {
        Alpine alpine = null;
        EntityManager em = this.createEntityManager();
        BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        this.beginTransaction(em);
        try {
            beerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            alpine = new Alpine(serialNumber);
            em.persist((Object)alpine);
            alpine.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)18));
            alpine.setAlcoholContent((Object)5.4);
            alpine.setClassification(Alpine.Classification.BITTER);
            beerConsumer.addAlpineBeerToConsume(alpine, 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        Vector alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        EmbeddableSuperclassJunitTest.assertTrue((String)"The new alpine was not added at the correct index in the cache.", (alpinesFromCache.indexOf(alpine) == 0 ? 1 : 0) != 0);
        this.clearCache();
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        Vector alpinesFromDB = (Vector)beerConsumer.getAlpineBeersToConsume();
        EmbeddableSuperclassJunitTest.assertTrue((String)"The new alpine was not added at the correct index when retrieving from the database.", (alpinesFromDB.indexOf(alpine) == 1 ? 1 : 0) != 0);
    }

    public void testInsertNewAlpineAndModifyOrderOfExistingAlpines() {
        Alpine alpine1 = null;
        Alpine alpine2 = null;
        EntityManager em = this.createEntityManager();
        BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        this.beginTransaction(em);
        try {
            beerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            alpine1 = new Alpine(serialNumber);
            em.persist((Object)alpine1);
            alpine1.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)16));
            alpine1.setAlcoholContent((Object)5.6);
            alpine1.setClassification(Alpine.Classification.STRONG);
            beerConsumer.addAlpineBeerToConsume(alpine1, 0);
            alpine2 = beerConsumer.getAlpineBeerToConsume(4);
            alpine2.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)20));
            beerConsumer.moveAlpineBeerToConsume(4, 3);
            beerConsumer.removeAlpineBeerToConsume(4);
            beerConsumer.removeAlpineBeerToConsume(2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        Vector alpinesFromCache = (Vector)beerConsumer.getAlpineBeersToConsume();
        EmbeddableSuperclassJunitTest.assertTrue((String)"The new alpine was not added at the correct index in the cache.", (alpinesFromCache.indexOf(alpine1) == 0 ? 1 : 0) != 0);
        EmbeddableSuperclassJunitTest.assertTrue((String)"The alpine was not moved to the correct index in the cache.", (alpinesFromCache.indexOf(alpine2) == 2 ? 1 : 0) != 0);
        this.clearCache();
        em.clear();
        beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        Vector alpinesFromDB = (Vector)beerConsumer.getAlpineBeersToConsume();
        EmbeddableSuperclassJunitTest.assertTrue((String)"The new alpine was not added at the correct index when retrieving from the database.", (alpinesFromDB.indexOf(alpine1) == 0 ? 1 : 0) != 0);
        EmbeddableSuperclassJunitTest.assertTrue((String)"The alpine was not moved to the correct index when retrieving from the database.", (alpinesFromDB.indexOf(alpine2) == 2 ? 1 : 0) != 0);
    }

    public void testOptimisticLockingTest() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer beerConsumer = new BeerConsumer();
            beerConsumer.setName("Guy Pelletier");
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            Alpine alpine = new Alpine(serialNumber);
            em.persist((Object)alpine);
            alpine.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)21));
            alpine.setAlcoholContent((Object)5.0);
            alpine.setClassification(Alpine.Classification.BITTER);
            long currentTimeMillis = System.currentTimeMillis();
            alpine.addInspectionDate(new Date(currentTimeMillis));
            beerConsumer.addAlpineBeerToConsume(alpine);
            em.persist((Object)beerConsumer);
            Integer bid = beerConsumer.getId();
            this.commitTransaction(em);
            this.beginTransaction(em);
            BeerConsumer beerConsumerManaged = (BeerConsumer)em.find(BeerConsumer.class, (Object)bid);
            for (int i = beerConsumerManaged.getAlpineBeersToConsume().size() - 1; i >= 0; --i) {
                Alpine alpineManaged = beerConsumerManaged.removeAlpineBeerToConsume(i);
                em.remove((Object)alpineManaged);
                em.flush();
            }
            BeerConsumer beerConsumerDetached = new BeerConsumer();
            beerConsumerDetached.setName("Guy Pelletier");
            SerialNumber serialNumberAtt = new SerialNumber();
            em.persist((Object)serialNumberAtt);
            Alpine alpineDetached = new Alpine(serialNumberAtt);
            alpineDetached.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)21));
            alpineDetached.setAlcoholContent((Object)5.5);
            alpineDetached.setClassification(Alpine.Classification.BITTER);
            alpineDetached.addInspectionDate(new Date(currentTimeMillis));
            beerConsumerDetached.addAlpineBeerToConsume(alpineDetached);
            beerConsumerDetached.setId(bid);
            beerConsumerDetached.setVersion(beerConsumerManaged.getVersion());
            alpineDetached.setVersion(null);
            em.merge((Object)beerConsumerDetached);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            e.printStackTrace();
            this.closeEntityManager(em);
            EmbeddableSuperclassJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testReadAlpine() {
        Alpine alpine = (Alpine)this.createEntityManager().find(Alpine.class, (Object)m_alpineId);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error on reading back an Alpine beer", (alpine != null ? 1 : 0) != 0);
        EmbeddableSuperclassJunitTest.assertTrue((String)"The enum was not read back in properly.", (alpine.getClassification() == Alpine.Classification.BITTER ? 1 : 0) != 0);
    }

    public void testReadBeerConsumer() {
        BeerConsumer beerConsumer = (BeerConsumer)this.createEntityManager().find(BeerConsumer.class, (Object)m_beerConsumerId1);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error on reading back a BeerConsumer", (beerConsumer != null ? 1 : 0) != 0);
    }

    public void testReadCanadian() {
        Canadian canadian = (Canadian)this.createEntityManager().find(Canadian.class, (Object)m_canadianId);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error on reading back a Canadian beer", (canadian != null ? 1 : 0) != 0);
        EmbeddableSuperclassJunitTest.assertTrue((String)"The enum was not read back in properly.", (canadian.getFlavor() == Canadian.Flavor.LAGER ? 1 : 0) != 0);
    }

    public void testShuffleTelephoneNumbersOnBeerConsumers() {
        int beerConsumer1TelephoneCountStart = 0;
        int beerConsumer2TelephoneCountStart = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer1 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            beerConsumer1TelephoneCountStart = beerConsumer1.getTelephoneNumbers().size();
            BeerConsumer beerConsumer2 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
            beerConsumer2TelephoneCountStart = beerConsumer2.getTelephoneNumbers().size();
            TelephoneNumber phone = (TelephoneNumber)beerConsumer1.getTelephoneNumbers().values().iterator().next();
            phone.setBeerConsumer(beerConsumer2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        BeerConsumer newBeerConsumer1 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
        int beerConsumer1TelephoneCountEnd = newBeerConsumer1.getTelephoneNumbers().size();
        BeerConsumer newBeerConsumer2 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
        int beerConsumer2TelephoneCountEnd = newBeerConsumer2.getTelephoneNumbers().size();
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a TelephoneNumber's beer consumer", (beerConsumer1TelephoneCountEnd + 1 == beerConsumer1TelephoneCountStart ? 1 : 0) != 0);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a TelephoneNumber's beer consumer", (beerConsumer2TelephoneCountEnd - 1 == beerConsumer2TelephoneCountStart ? 1 : 0) != 0);
    }

    public void testUpdateAlpine() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Alpine alpine = (Alpine)em.find(Alpine.class, (Object)m_alpineId);
            alpine.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)19));
            em.merge((Object)alpine);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Alpine newAlpine = (Alpine)em.find(Alpine.class, (Object)m_alpineId);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating an Alpine beer.", (boolean)newAlpine.getBestBeforeDate().equals(Helper.dateFromYearMonthDate((int)2005, (int)8, (int)19)));
    }

    public void testUpdateAlpineThroughBeerConsumer() {
        int id = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
            Alpine alpine = (Alpine)beerConsumer.getAlpineBeersToConsume().iterator().next();
            alpine.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)9, (int)19));
            id = (Integer)alpine.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Alpine newAlpine = (Alpine)em.find(Alpine.class, (Object)id);
        this.closeEntityManager(em);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating an Alpine beer.", (boolean)newAlpine.getBestBeforeDate().equals(Helper.dateFromYearMonthDate((int)2005, (int)9, (int)19)));
    }

    public void testUpdateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            beerConsumer.setName("Big beer gut");
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        BeerConsumer newBeerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a BeerConsumer", (boolean)newBeerConsumer.getName().equals("Big beer gut"));
    }

    public void testUpdateCanadian() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Canadian canadian = (Canadian)em.find(Canadian.class, (Object)m_canadianId);
            canadian.getBornOnDate().setTime(Helper.dateFromYearMonthDate((int)2005, (int)8, (int)19).getTime());
            canadian.getProperties().put(m_canadianProperty2, new Date(System.currentTimeMillis()));
            em.merge((Object)canadian);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        em.clear();
        Canadian newCanadian = (Canadian)em.find(Canadian.class, (Object)m_canadianId);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a Canadian beer's BornOnDate", (boolean)newCanadian.getBornOnDate().equals(Helper.dateFromYearMonthDate((int)2005, (int)8, (int)19)));
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a Canadian beer's Properties", (newCanadian.getProperties().size() == 2 ? 1 : 0) != 0);
    }

    public void testUpdateCanadianThroughBeerConsumer() {
        int id = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            Canadian canadian = (Canadian)beerConsumer.getCanadianBeersToConsume().values().iterator().next();
            canadian.setBornOnDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)9, (int)19));
            id = (Integer)canadian.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        Canadian newCanadian = (Canadian)em.find(Canadian.class, (Object)id);
        EmbeddableSuperclassJunitTest.assertTrue((String)"Error updating a Canadian beer.", (boolean)newCanadian.getBornOnDate().equals(Helper.dateFromYearMonthDate((int)2005, (int)9, (int)19)));
    }

    public void testUpdateTelephoneNumberThroughBeerConsumer() {
        TelephoneNumber oldPhone = null;
        TelephoneNumber newPhone = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            oldPhone = (TelephoneNumber)beerConsumer.getTelephoneNumbers().values().iterator().next();
            beerConsumer.removePhoneNumber(oldPhone);
            em.remove((Object)oldPhone);
            newPhone = new TelephoneNumber();
            newPhone.setAreaCode("XXX");
            newPhone.setNumber(oldPhone.getNumber());
            newPhone.setType(oldPhone.getType());
            beerConsumer.addTelephoneNumber(newPhone);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        BeerConsumer bc = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
        EmbeddableSuperclassJunitTest.assertTrue((String)"The new/updated phone was not persisted.", (boolean)bc.hasTelephoneNumber(newPhone));
        EmbeddableSuperclassJunitTest.assertFalse((String)"The old phone was not removed.", (boolean)bc.hasTelephoneNumber(oldPhone));
    }

    public void testUpdateCertifications() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer1 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId1);
            Certification cert1 = (Certification)em.find(Certification.class, (Object)m_certId1);
            cert1.setBeerConsumer(beerConsumer1);
            Certification cert2 = (Certification)em.find(Certification.class, (Object)m_certId2);
            cert2.setBeerConsumer(beerConsumer1);
            BeerConsumer beerConsumer2 = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId2);
            Certification cert3 = (Certification)em.find(Certification.class, (Object)m_certId3);
            cert3.setBeerConsumer(beerConsumer2);
            Certification cert4 = (Certification)em.find(Certification.class, (Object)m_certId4);
            cert4.setBeerConsumer(beerConsumer2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    static {
        m_canadianProperty1 = "string1";
        m_canadianProperty2 = "string2";
    }
}

