/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import jakarta.persistence.EntityManager;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.PerformanceTireInfo;
import org.eclipse.persistence.testing.models.jpa.inheritance.TireInfo;

public class ReportQueryMultipleReturnInheritanceTestSuite
extends JUnitTestCase {
    protected boolean m_reset = false;
    protected PerformanceTireInfo tireInfo;

    public ReportQueryMultipleReturnInheritanceTestSuite() {
    }

    public ReportQueryMultipleReturnInheritanceTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ReportQueryMultipleReturnInheritanceTestSuite.class);
        return suite;
    }

    public void setUp() {
        super.setUp();
        this.m_reset = true;
        this.tireInfo = new PerformanceTireInfo();
        this.tireInfo.setPressure(Integer.valueOf(32));
        this.tireInfo.setSpeedRating(Integer.valueOf(220));
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)this.tireInfo);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
    }

    public void tearDown() {
        if (this.m_reset) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                TireInfo localTire = (TireInfo)em.find(TireInfo.class, (Object)this.tireInfo.getId());
                em.remove((Object)localTire);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            this.m_reset = false;
            super.tearDown();
        }
    }

    public void testInheritanceMultiTableException() {
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.returnWithoutReportQueryResult();
        reportQuery.setReferenceClass(TireInfo.class);
        reportQuery.addAttribute("tireinfo", (Expression)reportQuery.getExpressionBuilder());
        List result = (List)ReportQueryMultipleReturnInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)reportQuery);
        Object resultItem = result.get(0);
        ReportQueryMultipleReturnInheritanceTestSuite.assertTrue((String)"Failed to return Employees correctly, Not A PerformanceTireInfo", (boolean)PerformanceTireInfo.class.isAssignableFrom(resultItem.getClass()));
        ReportQueryMultipleReturnInheritanceTestSuite.assertTrue((String)"Did not populate all fields.  Missing 'pressure'", (((PerformanceTireInfo)resultItem).getPressure() != null ? 1 : 0) != 0);
        ReportQueryMultipleReturnInheritanceTestSuite.assertTrue((String)"Did not populate all fields.  Missing 'speedrating'", (((PerformanceTireInfo)resultItem).getSpeedRating() != null ? 1 : 0) != 0);
    }
}

