/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.relationships;

import jakarta.persistence.EntityManager;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.RelationshipsTableManager;

public class ExpressionJUnitTestSuite
extends JUnitTestCase {
    public ExpressionJUnitTestSuite() {
    }

    public ExpressionJUnitTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        ExpressionJUnitTestSuite.clearCache((String)"fieldaccess");
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
    }

    public void testLeftTrimWithTrimChar() throws Exception {
        Platform dbPlatform = ExpressionJUnitTestSuite.getPlatform((String)"fieldaccess");
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").logMessage("Test testLeftTrimWithTrimChar skipped for this platform");
            return;
        }
        Customer c = RelationshipsExamples.customerExample4();
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").leftTrim((Object)"M").equal((Object)"anotick");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Customer.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (result.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)"Manotick".equals(returned.getCity()));
        }
        catch (Exception e) {
            block11: {
                block10: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block10;
                        this.rollbackTransaction(em);
                    }
                }
                this.closeEntityManager(em);
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block11;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLeftTrimWithoutTrimChar() throws Exception {
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity(" anotick");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").leftTrim().equal((Object)"anotick");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Customer.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (result.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)" anotick".equals(returned.getCity()));
        }
        catch (Exception e) {
            block10: {
                block9: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block9;
                        this.rollbackTransaction(em);
                    }
                }
                this.closeEntityManager(em);
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block10;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testRightTrimWithTrimChar() throws Exception {
        Platform dbPlatform = ExpressionJUnitTestSuite.getPlatform((String)"fieldaccess");
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").logMessage("Test testRightTrimWithTrimChar skipped for this platform");
            return;
        }
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity("ManotickM");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").rightTrim((Object)"M").equal((Object)"Manotick");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Customer.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)"ManotickM".equals(returned.getCity()));
        }
        catch (Exception e) {
            block11: {
                block10: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block10;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block11;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testRightTrimWithoutTrimChar() throws Exception {
        Customer c = RelationshipsExamples.customerExample4();
        c.setCity("Manotic ");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)c);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("city").rightTrim().equal((Object)"Manotic");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Customer.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Customer returned = (Customer)result.get(0);
            if (!ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isMaxDB() && !ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isSybase()) {
                ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Customers found", (boolean)"Manotic ".equals(returned.getCity()));
            }
        }
        catch (Exception e) {
            block11: {
                block10: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block10;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                this.beginTransaction(em);
                c = (Customer)em.find(Customer.class, (Object)c.getCustomerId());
                em.remove((Object)c);
                try {
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block11;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testTrimWithTrimChar() throws Exception {
        Platform dbPlatform = ExpressionJUnitTestSuite.getPlatform((String)"fieldaccess");
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").logMessage("Test testTrimWithTrimChar skipped for this platform");
            return;
        }
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").trim((Object)"i").equal((Object)"tem");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Item.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block11: {
                block10: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block10;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block11;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testTrimWithoutTrimChar() throws Exception {
        Platform dbPlatform = ExpressionJUnitTestSuite.getPlatform((String)"fieldaccess");
        if (!(dbPlatform.isOracle() || dbPlatform.isMySQL() || dbPlatform.isPostgreSQL() || dbPlatform.isInformix() || dbPlatform.isSQLAnywhere() || dbPlatform.isHSQL() || dbPlatform.isSymfoware())) {
            ExpressionJUnitTestSuite.getServerSession((String)"fieldaccess").logMessage("Test testTrimWithoutTrimChar skipped for this platform");
            return;
        }
        Item i = new Item();
        i.setName(" tem ");
        i.setDescription("itemi description");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").trim().equal((Object)"tem");
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Item.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (boolean)" tem ".equals(returned.getName()));
        }
        catch (Exception e) {
            block11: {
                block10: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block10;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block11;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLocateWithSingleArgument() throws Exception {
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").locate((Object)"t").equal((Object)new Integer(2));
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Item.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: IncorrectItem found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block10: {
                block9: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block9;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block10;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testLocateWithDoubleArgument() throws Exception {
        Item i = new Item();
        i.setName("itemi");
        i.setDescription("itemi description");
        EntityManager em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)i);
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.closeEntityManager(em);
        em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("name").locate("i", 2).equal((Object)new Integer(5));
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(Item.class);
            query.setSelectionCriteria(expression);
            List result = ((JpaEntityManager)em.getDelegate()).createQuery((DatabaseQuery)query).getResultList();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: No Items found", (result.size() != 0 ? 1 : 0) != 0);
            Item returned = (Item)result.get(0);
            ExpressionJUnitTestSuite.assertTrue((String)"Test error: IncorrectItem found", (boolean)"itemi".equals(returned.getName()));
        }
        catch (Exception e) {
            block10: {
                block9: {
                    try {
                        this.commitTransaction(em);
                    }
                    catch (Throwable t) {
                        if (!this.isTransactionActive(em)) break block9;
                        this.rollbackTransaction(em);
                    }
                }
                em = ExpressionJUnitTestSuite.createEntityManager((String)"fieldaccess");
                try {
                    this.beginTransaction(em);
                    i = (Item)em.find(Item.class, (Object)i.getItemId());
                    em.remove((Object)i);
                    this.commitTransaction(em);
                }
                catch (Throwable t) {
                    if (!this.isTransactionActive(em)) break block10;
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
            throw e;
        }
    }
}

